/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.ogm.context.EntityFilter;
import org.neo4j.ogm.context.GraphEntityMapper;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.context.ResponseMapper;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.GraphRowListModel;
import org.neo4j.ogm.model.GraphRowModel;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.EntityInstantiator;

public class GraphRowListModelMapper
implements ResponseMapper<GraphRowListModel> {
    private final GraphEntityMapper delegate;

    public GraphRowListModelMapper(MetaData metaData, MappingContext mappingContext, EntityInstantiator entityInstantiator) {
        this.delegate = new GraphEntityMapper(metaData, mappingContext, entityInstantiator);
    }

    @Override
    public <T> Iterable<T> map(Class<T> type, final Response<GraphRowListModel> response) {
        final LinkedHashSet idsOfResultEntities = new LinkedHashSet();
        Response<GraphModel> graphResponse = new Response<GraphModel>(){
            GraphRowListModel currentIteratedModel;
            int currentIndex = 0;

            public GraphModel next() {
                List listOfRowModels;
                if (this.currentIteratedModel == null) {
                    this.currentIteratedModel = (GraphRowListModel)response.next();
                    if (this.currentIteratedModel == null) {
                        return null;
                    }
                    this.currentIndex = 0;
                }
                if ((listOfRowModels = this.currentIteratedModel.model()).size() <= this.currentIndex) {
                    this.currentIteratedModel = null;
                    return this.next();
                }
                GraphRowModel graphRowModel = (GraphRowModel)listOfRowModels.get(this.currentIndex++);
                Set idsInCurrentRow = Arrays.stream(graphRowModel.getRow()).filter(Number.class::isInstance).map(Number.class::cast).map(Number::longValue).collect(Collectors.toSet());
                idsOfResultEntities.addAll(idsInCurrentRow);
                return graphRowModel.getGraph();
            }

            public void close() {
                response.close();
            }

            public String[] columns() {
                return response.columns();
            }
        };
        EntityFilter includeModelObject = (graphModel, nativeId, isNode) -> idsOfResultEntities.contains(nativeId);
        return this.delegate.map(type, graphResponse, includeModelObject);
    }
}

