/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.Collections;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DescriptorMappings;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.reflect.EntityAccessManager;

public final class MappingSupport {
    public static void writeProperty(ClassInfo classInfo, Object instance, String propertyName, Object value) {
        FieldInfo writer = classInfo.getFieldInfo(propertyName);
        value = MappingSupport.convertValue(classInfo, propertyName, value, writer);
        writer.write(instance, value);
    }

    public static Object convertValue(ClassInfo classInfo, String propertyName, Object value, FieldInfo fieldInfo) {
        if (fieldInfo.type().isArray() || Iterable.class.isAssignableFrom(fieldInfo.type())) {
            Class<?> paramType = fieldInfo.type();
            Class<?> elementType = MappingSupport.underlyingElementType(classInfo, propertyName);
            if (paramType.isArray()) {
                return EntityAccessManager.merge(paramType, value, new Object[0], elementType);
            }
            return EntityAccessManager.merge(paramType, value, Collections.emptyList(), elementType);
        }
        return value;
    }

    private static Class<?> underlyingElementType(ClassInfo classInfo, String propertyName) {
        FieldInfo fieldInfo = MappingSupport.fieldInfoForPropertyName(propertyName, classInfo);
        Class<?> clazz = null;
        if (fieldInfo != null) {
            clazz = DescriptorMappings.getType(fieldInfo.getTypeDescriptor());
        }
        return clazz;
    }

    private static FieldInfo fieldInfoForPropertyName(String propertyName, ClassInfo classInfo) {
        FieldInfo labelField = classInfo.labelFieldOrNull();
        if (labelField != null && labelField.getName().equalsIgnoreCase(propertyName)) {
            return labelField;
        }
        return classInfo.propertyField(propertyName);
    }
}

