/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.schema;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.metadata.schema.Node;
import org.neo4j.ogm.metadata.schema.NodeImpl;
import org.neo4j.ogm.metadata.schema.Relationship;
import org.neo4j.ogm.metadata.schema.RelationshipImpl;
import org.neo4j.ogm.metadata.schema.Schema;

class SchemaImpl
implements Schema {
    private Map<String, NodeImpl> nodes = new HashMap<String, NodeImpl>();
    private Map<String, Relationship> relationships = new HashMap<String, Relationship>();

    SchemaImpl() {
    }

    void addNode(String label, NodeImpl node) {
        this.nodes.put(label, node);
    }

    void addRelationship(RelationshipImpl relationship) {
        this.relationships.put(relationship.type(), relationship);
    }

    @Override
    public Node findNode(String label) {
        if (!this.nodes.containsKey(label)) {
            throw new IllegalArgumentException("Unknown label `" + label + "`");
        }
        return this.nodes.get(label);
    }

    @Override
    public Relationship findRelationship(String type) {
        if (!this.relationships.containsKey(type)) {
            throw new IllegalArgumentException("Unknown type " + type);
        }
        return this.relationships.get(type);
    }

    Relationship getRelationship(String type) {
        return this.relationships.get(type);
    }
}

