/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.exception.core.InvalidDepthException;
import org.neo4j.ogm.session.request.FilteredQuery;
import org.neo4j.ogm.session.request.FilteredQueryBuilder;
import org.neo4j.ogm.session.request.strategy.LoadClauseBuilder;
import org.neo4j.ogm.session.request.strategy.MatchClauseBuilder;
import org.neo4j.ogm.session.request.strategy.QueryStatements;
import org.neo4j.ogm.session.request.strategy.impl.IdCollectionMatchRelationshipClauseBuilder;
import org.neo4j.ogm.session.request.strategy.impl.IdMatchRelationshipClauseBuilder;
import org.neo4j.ogm.session.request.strategy.impl.PathRelationshipLoadClauseBuilder;
import org.neo4j.ogm.session.request.strategy.impl.RelationshipTypeMatchClauseBuilder;

public class RelationshipQueryStatements<ID extends Serializable>
implements QueryStatements<ID> {
    private MatchClauseBuilder idMatchClauseBuilder = new IdMatchRelationshipClauseBuilder();
    private MatchClauseBuilder idCollectionMatchClauseBuilder = new IdCollectionMatchRelationshipClauseBuilder();
    private MatchClauseBuilder relTypeMatchClauseBuilder = new RelationshipTypeMatchClauseBuilder();
    private LoadClauseBuilder loadClauseBuilder;
    private String primaryId;

    public RelationshipQueryStatements() {
        this.loadClauseBuilder = new PathRelationshipLoadClauseBuilder();
    }

    public RelationshipQueryStatements(String primaryId, LoadClauseBuilder loadClauseBuilder) {
        this.primaryId = primaryId;
        this.loadClauseBuilder = loadClauseBuilder;
    }

    @Override
    public PagingAndSortingQuery findOne(ID id, int depth) {
        if (depth > 0) {
            String matchClause = this.idMatchClauseBuilder.build("");
            String returnClause = this.loadClauseBuilder.build("r0", "", depth);
            return new PagingAndSortingQuery(matchClause, returnClause, Collections.singletonMap("id", id), true, true, "r0");
        }
        throw new InvalidDepthException("Cannot load a relationship entity with depth 0 i.e. no start or end node");
    }

    @Override
    public PagingAndSortingQuery findOneByType(String label, ID id, int depth) {
        if (label == null || label.equals("")) {
            throw new IllegalArgumentException("no label provided");
        }
        if (depth > 0) {
            String matchClause = this.primaryId == null ? this.idMatchClauseBuilder.build(label) : this.idMatchClauseBuilder.build(label, this.primaryId);
            String returnClause = this.loadClauseBuilder.build("r0", label, depth);
            return new PagingAndSortingQuery(matchClause, returnClause, Collections.singletonMap("id", id), true, true, "r0");
        }
        throw new InvalidDepthException("Cannot load a relationship entity with depth 0 i.e. no start or end node");
    }

    @Override
    public PagingAndSortingQuery findAllByType(String type, Collection<ID> ids, int depth) {
        if (depth > 0) {
            String matchClause = this.primaryId == null ? this.idCollectionMatchClauseBuilder.build(type) : this.idCollectionMatchClauseBuilder.build(type, this.primaryId);
            String loadClause = this.loadClauseBuilder.build("r0", type, depth);
            return new PagingAndSortingQuery(matchClause, loadClause, Collections.singletonMap("ids", ids), true, true, "r0");
        }
        throw new InvalidDepthException("Cannot load a relationship entity with depth 0 i.e. no start or end node");
    }

    @Override
    public PagingAndSortingQuery findByType(String type, int depth) {
        if (depth > 0) {
            String matchClause = this.relTypeMatchClauseBuilder.build(type);
            String loadClause = this.loadClauseBuilder.build("r0", type, depth);
            return new PagingAndSortingQuery(matchClause, loadClause, Collections.emptyMap(), true, true, "r0");
        }
        throw new InvalidDepthException("Cannot load a relationship entity with depth 0 i.e. no start or end node");
    }

    @Override
    public PagingAndSortingQuery findByType(String type, Filters parameters, int depth) {
        if (depth > 0) {
            FilteredQuery query = FilteredQueryBuilder.buildRelationshipQuery(type, parameters);
            String matchClause = query.statement() + " WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m";
            String returnClause = this.loadClauseBuilder.build("r0", type, depth);
            return new PagingAndSortingQuery(matchClause, returnClause, query.parameters(), true, true, "r0");
        }
        throw new InvalidDepthException("Cannot load a relationship entity with depth 0 i.e. no start or end node");
    }

    private int min(int depth) {
        return Math.min(0, depth);
    }

    private int max(int depth) {
        return Math.max(0, depth);
    }
}

