/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.transaction;

import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.exception.core.TransactionManagerException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.transaction.AbstractTransactionManager;
import org.neo4j.ogm.transaction.Transaction;

public final class DefaultTransactionManager
extends AbstractTransactionManager {
    private final ThreadLocal<Transaction> currentThreadLocalTransaction = new ThreadLocal();

    public DefaultTransactionManager(Driver driver, Session session) {
        super(driver, session);
    }

    public Transaction getCurrentTransaction() {
        return this.currentThreadLocalTransaction.get();
    }

    @Override
    protected Transaction openOrExtend(Supplier<Transaction> opener, UnaryOperator<Transaction> extender) {
        Transaction current = this.getCurrentTransaction();
        if (current == null) {
            Transaction newTransaction = opener.get();
            this.currentThreadLocalTransaction.set(newTransaction);
            return newTransaction;
        }
        return (Transaction)extender.apply(current);
    }

    @Override
    protected void removeIfCurrent(Transaction transaction, Runnable action) {
        if (transaction != this.getCurrentTransaction()) {
            throw new TransactionManagerException("Transaction is not current for this thread");
        }
        action.run();
        this.currentThreadLocalTransaction.remove();
    }
}

