/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler.builders.statement;

import org.neo4j.ogm.model.PropertyContainer;

final class OptimisticLockingUtils {
    private static final String VERSION_PROPERTY_CHECK_FOR_EXISTING_NODES_AND_RELATIONSHIPS = "AND %1$s.`%2$s` = row.`%2$s` SET %1$s.`%2$s` = %1$s.`%2$s` + %3$d WITH %1$s, row WHERE %1$s.`%2$s` = row.`%2$s` + %3$d ";
    private static final String VERSION_PROPERTY_CHECK_FOR_NEW_OR_EXISTING_NODES = "WITH %1$s, row WHERE (row.`%2$s` IS NULL AND %1$s.`%2$s` IS NULL) OR %1$s.`%2$s` = row.`%2$s`   SET %1$s.`%2$s` = COALESCE(%1$s.`%2$s`, -1) + 1 WITH %1$s, row WHERE (row.`%2$s` IS NULL OR %1$s.`%2$s` = row.`%2$s` + 1) ";

    static String getFragmentForExistingNodesAndRelationships(PropertyContainer container, String variable) {
        return OptimisticLockingUtils.getFragmentForExistingNodesAndRelationships(container, variable, 1);
    }

    static String getFragmentForExistingNodesAndRelationships(PropertyContainer container, String variable, int increment) {
        String key = (String)container.getVersion().getKey();
        return String.format(VERSION_PROPERTY_CHECK_FOR_EXISTING_NODES_AND_RELATIONSHIPS, variable, key, increment);
    }

    static String getFragmentForNewOrExistingNodes(PropertyContainer container, String variable) {
        String key = (String)container.getVersion().getKey();
        return String.format(VERSION_PROPERTY_CHECK_FOR_NEW_OR_EXISTING_NODES, variable, key);
    }

    private OptimisticLockingUtils() {
    }
}

