/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.lang.annotation.Annotation;

public final class KotlinDetector {
    private static final Class<? extends Annotation> kotlinMetadata;

    public static boolean isKotlinPresent() {
        return kotlinMetadata != null;
    }

    public static boolean isKotlinType(Class<?> clazz) {
        return kotlinMetadata != null && clazz.getDeclaredAnnotation(kotlinMetadata) != null;
    }

    private KotlinDetector() {
    }

    static {
        Class<?> metadata;
        ClassLoader classLoader = KotlinDetector.class.getClassLoader();
        try {
            metadata = Class.forName("kotlin.Metadata", false, classLoader);
        }
        catch (ClassNotFoundException ex) {
            metadata = null;
        }
        kotlinMetadata = metadata;
    }
}

