/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.MetaInfCache;
import org.openide.util.lookup.implspi.SharedClassObjectBridge;

final class MetaInfServicesLookup
extends AbstractLookup {
    static final Logger LOGGER = Logger.getLogger(MetaInfServicesLookup.class.getName());
    private static final MetaInfCache CACHE = new MetaInfCache(512);
    private static Reference<Executor> RP = new WeakReference<Object>(null);
    private final Map<Class<?>, Object> classes = new WeakHashMap();
    private final ClassLoader loader;
    private final String prefix;

    static synchronized Executor getRP() {
        Executor res = RP.get();
        if (res == null) {
            try {
                Class<?> seek = Class.forName("org.openide.util.RequestProcessor");
                res = (Executor)seek.newInstance();
            }
            catch (Throwable t) {
                try {
                    res = Executors.newSingleThreadExecutor();
                }
                catch (Throwable t2) {
                    res = new Executor(){

                        @Override
                        public void execute(Runnable command) {
                            command.run();
                        }
                    };
                }
            }
            RP = new SoftReference<Executor>(res);
        }
        return res;
    }

    public MetaInfServicesLookup(ClassLoader loader, String prefix) {
        this.loader = loader;
        this.prefix = prefix;
        LOGGER.log(Level.FINE, "Created: {0}", this);
    }

    @Override
    public String toString() {
        return "MetaInfServicesLookup[" + this.loader + "]";
    }

    @Override
    void beforeLookupResult(Lookup.Template<?> template) {
        this.beforeLookup(template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void beforeLookup(Lookup.Template<?> t) {
        Class<?> c = t.getType();
        ArrayList toAdd = null;
        MetaInfServicesLookup metaInfServicesLookup = this;
        synchronized (metaInfServicesLookup) {
            if (this.classes.get(c) != null) {
                return;
            }
            toAdd = new ArrayList();
        }
        if (toAdd != null) {
            HashSet all = new HashSet();
            for (Class clazz : this.allSuper(c, all)) {
                this.search(clazz, toAdd);
            }
        }
        HashSet<AbstractLookup.R> listeners = null;
        MetaInfServicesLookup metaInfServicesLookup2 = this;
        synchronized (metaInfServicesLookup2) {
            if (this.classes.put(c, "") == null) {
                LinkedHashSet<AbstractLookup.Pair<?>> linkedHashSet = this.getPairsAsLHS();
                ArrayList<Item> arr = new ArrayList<Item>();
                for (AbstractLookup.Pair pair : linkedHashSet) {
                    arr.add((Item)pair);
                }
                for (AbstractLookup.Pair pair : toAdd) {
                    this.insertItem((Item)pair, arr);
                }
                listeners = this.setPairsAndCollectListeners(arr);
            }
        }
        if (listeners != null) {
            this.notifyIn(MetaInfServicesLookup.getRP(), listeners);
        }
    }

    private Set<Class<?>> allSuper(Class<?> clazz, Set<Class<?>> all) {
        all.add(clazz);
        Class<?> sup = clazz.getSuperclass();
        if (sup != null && sup != Object.class) {
            all.add(sup);
        }
        for (Class<?> c : clazz.getInterfaces()) {
            this.allSuper(c, all);
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search(Class<?> clazz, Collection<AbstractLookup.Pair<?>> result) {
        Enumeration<URL> en;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Searching for {0} in {1} from {2}", new Object[]{clazz.getName(), clazz.getClassLoader(), this});
        }
        String res = this.prefix + clazz.getName();
        try {
            en = this.loader.getResources(res);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        ArrayList<Item> foundClasses = new ArrayList<Item>();
        ArrayList removeClasses = new ArrayList();
        boolean foundOne = false;
        while (en.hasMoreElements()) {
            if (!foundOne) {
                foundOne = true;
                Class<?> realMcCoy = null;
                try {
                    realMcCoy = this.loader.loadClass(clazz.getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (realMcCoy != clazz) {
                    if (realMcCoy != null) {
                        LOGGER.log(Level.WARNING, "{0} is not the real McCoy! Actually found it in {1} (from {2}) but searched for from {3}", new Object[]{clazz.getName(), realMcCoy.getClassLoader(), this.loader, clazz.getClassLoader()});
                    } else {
                        LOGGER.log(Level.WARNING, "{0} could not be found in {1}", new Object[]{clazz.getName(), this.loader});
                    }
                    return;
                }
            }
            URL url = en.nextElement();
            Item currentItem = null;
            try (InputStream is = url.openStream();){
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#position=")) {
                        if (currentItem == null) {
                            LOGGER.log(Level.INFO, "Found line ''{0}'' in {1} but there is no item to associate it with", new Object[]{line, url});
                            continue;
                        }
                        try {
                            currentItem.position = Integer.parseInt(line.substring(10));
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                    if (currentItem != null) {
                        this.insertItem(currentItem, foundClasses);
                        currentItem = null;
                    }
                    if (line.length() == 0) continue;
                    boolean remove = false;
                    if (line.charAt(0) == '#') {
                        if (line.length() == 1 || line.charAt(1) != '-') continue;
                        remove = true;
                        line = line.substring(2);
                    }
                    Class<?> inst = null;
                    try {
                        Object ldr = url.getContent(new Class[]{ClassLoader.class});
                        if (ldr instanceof ClassLoader) {
                            inst = Class.forName(line, false, (ClassLoader)ldr);
                        }
                    }
                    catch (LinkageError ldr) {
                    }
                    catch (ClassNotFoundException ex) {
                        LOGGER.log(Level.FINER, "No class found in " + url, ex);
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.FINER, "URL does not support classloader protocol " + url, ex);
                    }
                    if (inst == null) {
                        try {
                            inst = Class.forName(line, false, this.loader);
                        }
                        catch (LinkageError err) {
                            if (remove) continue;
                            throw new ClassNotFoundException(err.getMessage(), err);
                        }
                        catch (ClassNotFoundException cnfe) {
                            if (remove) continue;
                            throw cnfe;
                        }
                    }
                    if (!clazz.isAssignableFrom(inst)) {
                        throw new ClassNotFoundException(MetaInfServicesLookup.clazzToString(inst) + " not a subclass of " + MetaInfServicesLookup.clazzToString(clazz));
                    }
                    if (remove) {
                        removeClasses.add(inst);
                        continue;
                    }
                    currentItem = new Item(inst);
                }
                if (currentItem == null) continue;
                this.insertItem(currentItem, foundClasses);
                currentItem = null;
            }
            catch (ClassNotFoundException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        LOGGER.log(Level.FINER, "Found impls of {0}: {1} and removed: {2} from: {3}", new Object[]{clazz.getName(), foundClasses, removeClasses, this});
        for (Item item : foundClasses) {
            if (removeClasses.contains(item.clazz())) continue;
            result.add(item);
        }
    }

    private static String clazzToString(Class<?> clazz) {
        String loc = null;
        try {
            if (clazz.getProtectionDomain() != null && clazz.getProtectionDomain().getCodeSource() != null) {
                loc = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
            }
        }
        catch (Throwable ex) {
            loc = ex.getMessage();
        }
        return clazz.getName() + "@" + clazz.getClassLoader() + ":" + loc;
    }

    private void insertItem(Item item, List<Item> list) {
        if (item.position == -1) {
            if (!list.contains(item)) {
                list.add(item);
            }
            return;
        }
        int foundIndex = -1;
        int index = -1;
        for (Item i : list) {
            if (i.equals(item)) {
                return;
            }
            ++index;
            if (foundIndex >= 0 || i.position != -1 && i.position <= item.position) continue;
            foundIndex = index;
        }
        if (foundIndex < 0) {
            list.add(item);
        } else {
            list.add(foundIndex, item);
        }
    }

    static Item createPair(Class<?> clazz) {
        return new Item(clazz);
    }

    private static final class CantInstantiate {
        final Class<?> clazz;

        public CantInstantiate(Class<?> clazz) {
            assert (clazz != null);
            this.clazz = clazz;
        }
    }

    private static final class Item
    extends AbstractLookup.Pair<Object> {
        private Object object;
        private int position = -1;

        public Item(Class<?> clazz) {
            this.object = clazz;
        }

        @Override
        public String toString() {
            return "MetaInfServicesLookup.Item[" + this.clazz().getName() + "]";
        }

        private Class<? extends Object> clazz() {
            Object o = this.object;
            if (o instanceof CantInstantiate) {
                return ((CantInstantiate)o).clazz;
            }
            if (o instanceof Class) {
                return (Class)o;
            }
            if (o != null) {
                return o.getClass();
            }
            return Object.class;
        }

        public boolean equals(Object o) {
            if (o instanceof Item) {
                return ((Item)o).clazz().equals(this.clazz());
            }
            return false;
        }

        public int hashCode() {
            return this.clazz().hashCode();
        }

        @Override
        protected boolean instanceOf(Class<?> c) {
            return c.isAssignableFrom(this.clazz());
        }

        @Override
        public Class<?> getType() {
            return this.clazz();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getInstance() {
            Object o = this.object;
            if (o instanceof CantInstantiate) {
                return null;
            }
            if (o instanceof Class) {
                Object object = o;
                synchronized (object) {
                    Class c = (Class)o;
                    try {
                        o = CACHE.findInstance(c);
                        if (o == null) {
                            o = SharedClassObjectBridge.newInstance(c);
                            Object other = CACHE.findInstance(c);
                            if (other != null) {
                                this.object = other;
                                return this.object;
                            }
                            CACHE.storeInstance(o);
                        }
                        this.object = o;
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.INFO, "Cannot create " + this.object, ex);
                        this.object = new CantInstantiate(c);
                        return null;
                    }
                    catch (LinkageError x) {
                        LOGGER.log(Level.FINE, "Cannot create " + this.object, x);
                        this.object = new CantInstantiate(c);
                        return null;
                    }
                }
            }
            return this.object;
        }

        @Override
        public String getDisplayName() {
            return this.clazz().getName();
        }

        @Override
        public String getId() {
            return this.clazz().getName();
        }

        @Override
        protected boolean creatorOf(Object obj) {
            return obj == this.object;
        }
    }
}

