/*
 * Decompiled with CFR 0.152.
 */
package hero.client.grapheditor;

import hero.client.events.JMSServicesClient;
import hero.client.grapheditor.Frame;
import hero.client.grapheditor.Info;
import hero.client.grapheditor.WFGraph;
import hero.client.grapheditor.WFPersistence;
import hero.client.grapheditor.WFWindowManager;
import hero.net.ProjectSession.StrutsNodeValue;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class WFManager {
    static ResourceBundle resource = ResourceBundle.getBundle("resources.Traduction");
    Frame frame;
    WFGraph wfGraph;
    WFWindowManager windowManager;
    WFPersistence wfPersistence;
    boolean automatic = true;
    Vector clipboardEdges;
    int clipboardNodes;
    String activeProject = null;
    String activeUser;
    Listener ml;
    private JMSServicesClient jms;
    public static final String imageBase = "images/";
    public static final ImageIcon icon = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/icon.png"));

    public void makeJMSConnection(String name) {
        try {
            this.ml.subscription("projectName = '" + name + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WFManager(Frame frame, WFPersistence persist) {
        try {
            this.frame = frame;
            this.wfPersistence = persist;
            this.windowManager = new WFWindowManager(this, this.wfPersistence);
            this.clipboardNodes = 0;
            this.clipboardEdges = new Vector();
            this.activeUser = this.wfPersistence.getUser();
            this.ml = new Listener();
            this.jms = new JMSServicesClient();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void setWFGraph(WFGraph wfGraph) {
        this.wfGraph = wfGraph;
    }

    public void addEdge() {
        this.wfGraph.setAddEdgeState(true);
    }

    public void setEdgeCondition(String edgeName) {
        try {
            String condition = this.windowManager.setEdgeCondition(edgeName);
            this.wfPersistence.setEdgeCondition(edgeName, condition);
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, resource.getString("wfmanager.edgeerror"));
        }
    }

    public void addNodeProperty(String nodeName) {
        this.windowManager.addNodePropertyWindow(nodeName);
    }

    public void addProjectProperty() {
        this.windowManager.addProjectPropertyWindow();
    }

    public void iterate(String nodeName) {
        this.windowManager.iterate(nodeName);
    }

    public void setNodeHook(String nodeName) {
        try {
            Vector hook = this.windowManager.addInterHook();
            if (hook.size() != 0) {
                this.wfPersistence.addNodeInterHook(nodeName, (String)hook.get(0), (String)hook.get(1), (String)hook.get(2));
                String value = this.windowManager.setInterHookValue((String)hook.get(2));
                this.wfPersistence.setNodeInterHookValue(nodeName, (String)hook.get(0), value);
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, resource.getString("wfmanager.hookerror"));
        }
    }

    public void setProjectHook() {
        try {
            Vector hook = this.windowManager.addInterHook();
            if (hook.size() != 0) {
                this.wfPersistence.addProjectInterHook((String)hook.get(0), (String)hook.get(1), (String)hook.get(2));
                String value = this.windowManager.setInterHookValue((String)hook.get(2));
                this.wfPersistence.setProjectInterHookValue((String)hook.get(0), value);
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, resource.getString("wfmanager.hookerror"));
        }
    }

    public void editNode(String nodeName) {
        try {
            this.windowManager.editNode(nodeName);
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, resource.getString("wfmanager.errordesc"));
        }
    }

    public void addPerformerAssigment(String nodeName) {
        this.windowManager.addPerformerAssigment(nodeName);
    }

    public void addNode() {
        try {
            this.wfGraph.setAddEdgeState(false);
            Vector addNode = this.windowManager.addNode();
            String name = (String)addNode.elementAt(0);
            if (!name.equalsIgnoreCase("")) {
                this.wfPersistence.addNode(name, (String)addNode.elementAt(1));
            }
            this.updateStatus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addNodeSubProcess() {
        try {
            this.wfGraph.setAddEdgeState(false);
            Vector addNode = this.windowManager.addNodeSubProcess();
            String name = (String)addNode.elementAt(0);
            this.wfPersistence.addNodeSubProcess(name, (String)addNode.elementAt(1));
            this.updateStatus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearSelection() {
        this.wfGraph.clearSelection();
    }

    public void selectAll() {
        this.wfGraph.selectAll();
    }

    public void exit() {
        this.frame.setPropertyChange();
        this.frame.dispose();
    }

    public void deleteSelection() {
        try {
            int option = JOptionPane.showConfirmDialog(null, resource.getString("wfmanager.willdelete"), resource.getString("wfmanager.deletesel"), 2, 3, icon);
            if (option == 0) {
                Object[] nodes = this.wfGraph.getSelectionNodes();
                Object[] edges = this.wfGraph.getSelectionEdges();
                if (edges.length > 0) {
                    this.wfPersistence.deleteEdges(edges);
                }
                for (int i = 0; i < nodes.length; ++i) {
                    this.wfPersistence.deleteNode((String)nodes[i]);
                }
                JOptionPane.showMessageDialog(null, resource.getString("wfmanager.removesucc"), resource.getString("wfmanager.deletesel"), 1, icon);
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, e1.getMessage(), resource.getString("wfmanager.delproj"), 1, icon);
        }
    }

    public void copySelection() {
        this.clipboardEdges = new Vector();
        this.clipboardNodes = this.wfGraph.getSelectionNodes().length;
        Object[] nodes = this.wfGraph.getVertices(this.wfGraph.getSelectionCells());
        if (nodes.length > 1) {
            for (int i = 0; i < nodes.length; ++i) {
                for (int j = 0; j < nodes.length; ++j) {
                    Object target;
                    Object[] edge = this.wfGraph.getEdgesBetween(nodes[i], nodes[j]);
                    if (edge.length <= 0 || !nodes[i].equals(target = this.wfGraph.getSourceVertex(edge[0]))) continue;
                    Edge e = new Edge();
                    e.target = i;
                    e.source = j;
                    this.clipboardEdges.add(e);
                }
            }
        }
    }

    public void pasteSelection() {
        try {
            Object[] nodes = new Object[this.clipboardNodes];
            for (int i = 0; i < this.clipboardNodes; ++i) {
                Vector node = this.windowManager.addNode();
                nodes[i] = (String)node.elementAt(0);
                if (((String)nodes[i]).equals("")) {
                    return;
                }
                this.wfPersistence.addNode((String)nodes[i], (String)node.elementAt(1));
            }
            Enumeration e = this.clipboardEdges.elements();
            while (e.hasMoreElements()) {
                Edge edge = (Edge)e.nextElement();
                this.wfPersistence.addEdge((String)nodes[edge.source], (String)nodes[edge.target]);
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, resource.getString("wfmanager.pasteerror"));
        }
    }

    public void newProject() {
        String temp = this.windowManager.newProjectWindow();
        if (temp != null) {
            this.activeProject = temp;
            this.wfGraph.newGraph();
            this.makeJMSConnection(this.activeProject);
        }
        this.updateStatus();
    }

    public void cloneProject() {
        this.windowManager.cloneProjectWindow();
    }

    public void openProject() {
        this.windowManager.openProject();
        this.updateStatus();
    }

    public void Info() {
        Info.showInfo();
    }

    public void openProject(String project) throws Exception {
        try {
            this.wfPersistence.openProject(project);
            this.wfGraph.openGraph(project);
            this.makeJMSConnection(project);
            this.activeProject = project;
            this.setTitle(project);
            this.setLayout1();
            this.updateStatus();
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, resource.getString("jprojectlist.modify"));
            throw new Exception(resource.getString("wfmanager.openerror"));
        }
    }

    public void setLayout1() {
        this.wfGraph.setLayout1();
    }

    public void setLayout2() {
        this.wfGraph.setExpand();
    }

    public void automaticLayout() {
        if (this.automatic) {
            this.automatic = false;
            this.wfGraph.setAutomaticLayout(false);
        } else {
            this.automatic = true;
            this.wfGraph.setAutomaticLayout(true);
        }
    }

    public void setStatusBar(String info) {
        this.frame.setStatusBar(info);
    }

    public Color getGraphBackground() {
        return this.wfGraph.getBackground();
    }

    public void setGraphBackground(Color color) {
        this.wfGraph.setBackground(color);
    }

    public void zoom(int value) {
        this.wfGraph.setZoom(value);
    }

    public void zoomIn() {
        this.wfGraph.zoomIn();
    }

    public void zoomOut() {
        this.wfGraph.zoomOut();
    }

    public void fitWindow() {
        this.wfGraph.fitWindow(this.frame.getScrollPane());
    }

    public BufferedImage getGraphImage() {
        return WFGraph.toImage(this.wfGraph);
    }

    public String getGraphVRML() {
        return WFGraph.vrmlView(this.wfGraph);
    }

    public WFGraph getGraph() {
        return this.wfGraph;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setTitle(String title) {
        this.frame.setTitle(resource.getString("wfmanager.title") + title + resource.getString("wfmanager.user") + this.activeUser);
    }

    public WFPersistence getPersistence() {
        return this.wfPersistence;
    }

    public void changeRole(String nodeName) {
        this.windowManager.changeRoleWindow(nodeName);
    }

    public void newUser() {
        this.windowManager.newUser();
    }

    public void newRole() {
        this.windowManager.newRole();
    }

    public void addUserToRole() {
        this.windowManager.addUserToRole();
    }

    public void addMapperToRole() {
        this.windowManager.addMapperToRole();
    }

    public void usersInProject() {
        this.windowManager.usersInProject();
    }

    public void updateStatus() {
        try {
            String s = " ";
            if (this.wfGraph.getSelectionNodes().length == 1 && this.wfGraph.getRoots().length > 0) {
                Object[] cell = this.wfGraph.getSelectionNodes();
                StrutsNodeValue nl = this.wfPersistence.getProjectNode((String)cell[0]);
                String name = (String)cell[0];
                s = this.wfPersistence.isActive(name) ? name + resource.getString("wfmanager.is") + nl.getState() + resource.getString("wfmanager.byuser") + nl.getRole() : name + " is " + nl.getState();
            } else {
                s = this.wfGraph.getVertices(this.wfGraph.getRoots()).length + resource.getString("wfmanager.cell");
            }
            this.frame.setStatusBar(s);
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, resource.getString("wfmanager.updateerror"));
        }
    }

    public class Listener
    implements MessageListener {
        public void subscription(String subs) throws Exception {
            WFManager.this.jms.createSubscription(this, subs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message message) {
            Color value = Color.lightGray;
            Listener listener = this;
            synchronized (listener) {
                try {
                    Hashtable evt = JMSServicesClient.getEvt(message);
                    if (((String)evt.get("projectName")).equals(WFManager.this.activeProject)) {
                        String edge;
                        String user;
                        String node;
                        String event = (String)evt.get("event");
                        if (event.equals("setNodeState")) {
                            Object nodeState = null;
                            String node2 = (String)evt.get("nodeName");
                            int state = new Integer((String)evt.get("nodeState"));
                            WFManager.this.wfGraph.changeNodeState(node2, state);
                            WFManager.this.wfPersistence.setProjectNodeState(node2, state);
                        }
                        if (event.equals("addNode")) {
                            node = (String)evt.get("nodeName");
                            user = (String)evt.get("userName");
                            String state = (String)evt.get("nodeState");
                            int type = new Integer((String)evt.get("nodeType"));
                            WFManager.this.wfGraph.addNewNode(node, new Integer(state), type);
                            WFManager.this.wfPersistence.setProjectNodes();
                        }
                        if (event.equals("addEdge")) {
                            edge = (String)evt.get("edgeName");
                            user = (String)evt.get("userName");
                            String nodeIn = (String)evt.get("nodeIn");
                            String nodeOut = (String)evt.get("nodeOut");
                            WFManager.this.wfGraph.restoreEdge(edge, nodeIn, nodeOut);
                        }
                        if (event.equals("deleteNode")) {
                            node = (String)evt.get("nodeName");
                            user = (String)evt.get("userName");
                            WFManager.this.wfGraph.deleteNode(node);
                            WFManager.this.wfPersistence.setProjectNodes();
                        }
                        if (event.equals("deleteEdge")) {
                            edge = (String)evt.get("edgeName");
                            user = (String)evt.get("userName");
                            WFManager.this.wfGraph.deleteEdge(edge);
                        }
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    class Edge {
        public int source;
        public int target;
    }
}

