/*
 * Decompiled with CFR 0.152.
 */
package hero.client.manager;

import hero.client.manager.BrowserControl;
import hero.client.manager.ListItem;
import hero.client.manager.MListener;
import hero.client.manager.ManagerCellRenderer;
import hero.interfaces.Constants;
import hero.util.BonitaClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class JActivityList
extends JPanel
implements PropertyChangeListener,
MouseListener,
Constants.Nd {
    static ResourceBundle resource = ResourceBundle.getBundle("resources.Traduction");
    private BonitaClient soapclient;
    private JList activityList = null;
    private DefaultListModel model;
    String project = null;
    public static final String imageBase = "images/";
    public static final ImageIcon icon = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/icon.png"));

    public JActivityList(BonitaClient soapclient, MListener ml) {
        try {
            this.soapclient = soapclient;
            ml.addEventActivityListener(this);
            this.model = new DefaultListModel();
            this.activityList = new JList(this.model);
            this.activityList.setCellRenderer(new ManagerCellRenderer());
            JScrollPane jspact = new JScrollPane(this.activityList);
            jspact.setBackground(new Color(177, 177, 251));
            this.setBackground(new Color(177, 177, 251));
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel(resource.getString("jactivitylist.activity")), "North");
            this.add((Component)jspact, "Center");
            this.activityList.addMouseListener(this);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, resource.getString("jactivitylist.error"), resource.getString("jactivitylist.interror"), 1, icon);
        }
    }

    public void mouseReleased(MouseEvent e) {
        try {
            if ((e.getModifiers() & 4) != 0) {
                if (this.activityList.getSelectedValue() != null) {
                    JPopupMenu menu = new JPopupMenu();
                    this.PopupMenu(menu);
                    Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                    Dimension size = menu.getPreferredSize();
                    int x = e.getX();
                    int y = e.getY();
                    menu.show(this, x, y);
                }
            } else if (e.getClickCount() == 2) {
                BrowserControl.displayURL(System.getProperty("bonita.host") + "/bonita/protected/Action.jsp?projectname=" + this.project + "&nodename=" + ((ListItem)this.activityList.getSelectedValue()).getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void PopupMenu(JPopupMenu menu) {
        ClassLoader cl = this.getClass().getClassLoader();
        JMenuItem mi = menu.add(new JMenuItem(resource.getString("jactivitylist.terminate")));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JActivityList.this.terminate();
            }
        });
        mi = menu.add(new JMenuItem(resource.getString("jactivitylist.cancel")));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JActivityList.this.cancel();
            }
        });
        mi = menu.add(new JMenuItem(resource.getString("jactivitylist.details")));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserControl.displayURL(System.getProperty("bonita.host") + "/bonita/protected/Action.jsp?projectname=" + JActivityList.this.project + "&nodename=" + ((ListItem)JActivityList.this.activityList.getSelectedValue()).getValue());
            }
        });
    }

    void terminate() {
        try {
            if (this.project != null) {
                this.soapclient.terminateActivity(this.project, ((ListItem)this.activityList.getSelectedValue()).getValue());
            }
        }
        catch (Exception term) {
            if (term.getMessage().matches("(?i).*You have to terminate subProcess.*")) {
                JOptionPane.showMessageDialog(null, resource.getString("jactivitylist.subnofinish"), resource.getString("jactivitylist.terminate"), 1, icon);
            }
            JOptionPane.showMessageDialog(null, resource.getString("jactivitylist.terminateerror") + term.getMessage(), resource.getString("jactivitylist.terminate"), 1, icon);
        }
    }

    void cancel() {
        try {
            if (this.project != null) {
                this.soapclient.cancelActivity(this.project, ((ListItem)this.activityList.getSelectedValue()).getValue());
            }
        }
        catch (Exception cancel) {
            JOptionPane.showMessageDialog(null, resource.getString("jactivitylist.acterror") + cancel.getMessage(), "Cancel Activity", 1, icon);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        try {
            if (e.getPropertyName().equals("selected")) {
                this.model.clear();
                this.project = (String)e.getNewValue();
                Collection activity = this.soapclient.getActivityList(this.project);
                for (String node : activity) {
                    ListItem li = new ListItem(this.getColor(node), node);
                    this.model.addElement(li);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Color getColor(String name) throws Exception {
        this.soapclient.openProject(this.project);
        int state = this.soapclient.getNodeState(name);
        switch (state) {
            case 6: {
                return Color.red;
            }
            case 5: {
                return Color.magenta;
            }
        }
        return Color.white;
    }

    public void changeEvent(Object[] e, String projectName) {
        try {
            if (projectName.equals(this.project)) {
                this.model.clear();
                int i = 0;
                for (i = 0; i < e.length; ++i) {
                    ListItem li = new ListItem(this.getColor(e[i].toString()), e[i].toString());
                    this.model.add(i, li);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

