/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import javax.security.auth.login.LoginContext;

public class Sample1CreateProcessModel {
    public static void main(String[] args) throws Exception {
        char[] password = new char[]{'t', 'o', 't', 'o'};
        SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        ProjectSessionHome prjHome = ProjectSessionUtil.getHome();
        ProjectSession prjSession = prjHome.create();
        prjSession.initModel("Order Processing");
        prjSession.addNode("Receive Order", 1);
        prjSession.setNodeTraditional("Receive Order");
        prjSession.setNodeProperty("Receive Order", "once_more", "OK", true);
        prjSession.setNodeProperty("Receive Order", "customer_name", "", true);
        prjSession.setNodeProperty("Receive Order", "product_name", "", true);
        prjSession.setNodeProperty("Receive Order", "items", "", true);
        prjSession.addNode("Check Stock", 3);
        prjSession.setNodeTraditional("Check Stock");
        prjSession.addEdge("Receive Order", "Check Stock");
        String scriptHook = "import hero.interfaces.*;\nimport hero.interfaces.BnNodeLocal;\nbeforeTerminate (Object b,Object n) {\nhero.interfaces.ProjectSessionLocalHome pHome = (hero.interfaces.ProjectSessionLocalHome) hero.interfaces.ProjectSessionUtil.getLocalHome(); \nhero.interfaces.ProjectSessionLocal subProcess = pHome.create(); \nsubProcess.initModel(n.getBnProject().getName()); \nif (customer_name != null && product_name != null && items != null) \n{ System.out.println(\"(Order Processing : Check Stock) Stock Status = OK\"); \n subProcess.setNodeProperty(n.getName(), \"stock_status\",\"ok\",true);\n \t}\n else \n{ System.out.println(\"(Order Processing : Check Stock) Stock Status = NOK\");\n subProcess.setNodeProperty(n.getName(), \"stock_status\",\"nok\",true); \n }\n}";
        prjSession.addNodeInterHook("Check Stock", "Check Stock Hook", "beforeTerminate", 6, scriptHook);
        prjSession.addNodeSubProcess("Accept Order", "Customer Service");
        String edgeStockOrder = prjSession.addEdge("Check Stock", "Accept Order");
        String condition = "stock_status.equals(\"ok\")";
        prjSession.setEdgeCondition(edgeStockOrder, condition);
        prjSession.addNode("Ship & Report", 3);
        prjSession.setNodeTraditional("Ship & Report");
        String scriptHookSR = "import hero.interfaces.*;\nimport hero.interfaces.BnNodeLocal;\nbeforeTerminate (Object b,Object n) {\nhero.interfaces.ProjectSessionLocalHome pHome = (hero.interfaces.ProjectSessionLocalHome) hero.interfaces.ProjectSessionUtil.getLocalHome(); \nhero.interfaces.ProjectSessionLocal subProcess = pHome.create(); \nsubProcess.initModel(n.getBnProject().getName()); \nSystem.out.println(\"(Order Processing : Ship & Report) That's OK\"); \n}";
        prjSession.addNodeInterHook("Ship & Report", "Ship Report Hook", "beforeTerminate", 6, scriptHookSR);
        String edgeOrderReport = prjSession.addEdge("Accept Order", "Ship & Report");
        String condition1 = "partial_sales_status.equals(\"ok\")";
        prjSession.setEdgeCondition(edgeOrderReport, condition1);
        prjSession.addNode("Cancel Order", 3);
        prjSession.setNodeTraditional("Cancel Order");
        String scriptHookCO = "import hero.interfaces.*;\nimport hero.interfaces.BnNodeLocal;\nbeforeTerminate (Object b,Object n) {\nhero.interfaces.ProjectSessionLocalHome pHome = (hero.interfaces.ProjectSessionLocalHome) hero.interfaces.ProjectSessionUtil.getLocalHome(); \nhero.interfaces.ProjectSessionLocal subProcess = pHome.create(); \nsubProcess.initModel(n.getBnProject().getName()); \nSystem.out.println(\"(Order Processing : Cancel Order) That's NOT OK\"); \n}";
        prjSession.addNodeInterHook("Cancel Order", "Cancel Order Hook", "beforeTerminate", 6, scriptHookCO);
        String edgeOrderCancel = prjSession.addEdge("Accept Order", "Cancel Order");
        String condition2 = "partial_sales_status.equals(\"nok\")";
        prjSession.setEdgeCondition(edgeOrderCancel, condition2);
        prjSession.addRole("agent", "Customer Service agent");
        prjSession.addRole("customer", "Sales order customer");
        prjSession.setNodeRole("Accept Order", "agent");
        prjSession.setNodeRole("Check Stock", "agent");
        prjSession.setNodeRole("Ship & Report", "agent");
        prjSession.setNodeRole("Cancel Order", "agent");
        prjSession.setNodeRole("Receive Order", "customer");
        String iterCondition = "once_more.equals(\"OK\")";
        prjSession.addIteration("Ship & Report", "Receive Order", iterCondition);
    }
}

