/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples.iterations.src;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import javax.security.auth.login.LoginContext;

public class AbortSchema {
    public static void main(String[] args) throws Exception {
        try {
            char[] password = new char[]{'t', 'o', 't', 'o'};
            SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
            ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
            ProjectSession ps = projectSessionh.create();
            System.out.print("\n   Creating AbortSchema model");
            ps.initModel("AbortSchema");
            ps.setProperty("abort", "false");
            ps.addNode("Start", 1);
            ps.addNode("A1", 1);
            ps.addNode("A2", 1);
            ps.addNode("B1", 1);
            ps.addNode("B2", 1);
            ps.addNode("Abort", 2);
            ps.setNodeTraditional("Start");
            ps.setNodeTraditional("A1");
            ps.setNodeTraditional("A2");
            ps.setNodeTraditional("B1");
            ps.setNodeTraditional("B2");
            ps.setNodeTraditional("Abort");
            ps.addEdge("Start", "A1");
            ps.addEdge("Start", "B1");
            String fromA1toA2 = ps.addEdge("A1", "A2");
            String fromB1toB2 = ps.addEdge("B1", "B2");
            String fromA1toAbort = ps.addEdge("A1", "Abort");
            String fromA2toAbort = ps.addEdge("A2", "Abort");
            String fromB1toAbort = ps.addEdge("B1", "Abort");
            String fromB2toAbort = ps.addEdge("B2", "Abort");
            ps.setEdgeCondition(fromA1toA2, "abort.equals(\"false\")");
            ps.setEdgeCondition(fromB1toB2, "abort.equals(\"false\")");
            ps.setEdgeCondition(fromA1toAbort, "abort.equals(\"true\")");
            ps.setEdgeCondition(fromA2toAbort, "abort.equals(\"true\")");
            ps.setEdgeCondition(fromB1toAbort, "abort.equals(\"true\")");
            ps.setEdgeCondition(fromB2toAbort, "abort.equals(\"true\")");
            ps.addIteration("Abort", "Start", "abort.equals(\"true\")");
            ps.addRole("Administrator", "The system administator role");
            ps.setNodeRole("Start", "Administrator");
            ps.setNodeRole("A1", "Administrator");
            ps.setNodeRole("A2", "Administrator");
            ps.setNodeRole("B1", "Administrator");
            ps.setNodeRole("B2", "Administrator");
            ps.setNodeRole("Abort", "Administrator");
            ps.addRoleMapper("Administrator", "AdministratorMapper", 1);
            ps.checkModelDefinition();
            System.out.println("   [ OK ]");
        }
        catch (Exception e) {
            System.out.println("\n\n   [ ERROR ] : " + e);
            e.printStackTrace();
        }
    }
}

