/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples.iterations.src;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import javax.security.auth.login.LoginContext;

public class MultiIterationsNode {
    public static void main(String[] args) throws Exception {
        System.out.println(" ****   MultiIterationsNode    **** ");
        System.out.println(" *                                * ");
        System.out.println(" *          path=A                * ");
        System.out.println(" *     - - - - - - - -            * ");
        System.out.println(" *     |       path=B |           * ");
        System.out.println(" *     |      - - - - |           * ");
        System.out.println(" *     |      |      ||path=D     * ");
        System.out.println(" *     A----->B----->C----->D     * ");
        System.out.println(" *                  |_|           * ");
        System.out.println(" *                 path=C         * ");
        System.out.println(" *                                * ");
        System.out.println(" ********************************** ");
        char[] password = new char[]{'t', 'o', 't', 'o'};
        SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        ProjectSessionHome prjHome = ProjectSessionUtil.getHome();
        ProjectSession prjSession = prjHome.create();
        System.out.println("\nMultiIterationsNode model creation");
        prjSession.initModel("MultiIterationsNode");
        System.out.println("\nActivities creation");
        try {
            prjSession.addNode("A", 1);
            prjSession.addNode("B", 1);
            prjSession.addNode("C", 1);
            prjSession.addNode("D", 1);
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("Setting Activities types");
        try {
            prjSession.setNodeTraditional("A");
            prjSession.setNodeTraditional("B");
            prjSession.setNodeTraditional("C");
            prjSession.setNodeTraditional("D");
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("Adding project properties");
        try {
            prjSession.setProperty("path", "A");
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.println("Adding edges between activities");
        String fromCtoD = "";
        try {
            prjSession.addEdge("A", "B");
            prjSession.addEdge("B", "C");
            fromCtoD = prjSession.addEdge("C", "D");
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("Adding 'C' edge condition");
        try {
            prjSession.setEdgeCondition(fromCtoD, "path.equals(\"D\") || path.equals(\"d\")");
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("Adding iterations: between C--->A & C--->B & C--->C");
        try {
            prjSession.addIteration("C", "A", "path.equals(\"A\") || path.equals(\"a\")");
            prjSession.addIteration("C", "B", "path.equals(\"B\") || path.equals(\"b\")");
            prjSession.addIteration("C", "C", "path.equals(\"C\") || path.equals(\"c\")");
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("Settind activity roles and the role mapper");
        try {
            prjSession.addRole("Administrator", "The system administator role");
            prjSession.setNodeRole("A", "Administrator");
            prjSession.setNodeRole("B", "Administrator");
            prjSession.setNodeRole("C", "Administrator");
            prjSession.setNodeRole("D", "Administrator");
            prjSession.addRoleMapper("Administrator", "AdministratorMapper", 1);
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("Checking model definition");
        try {
            prjSession.checkModelDefinition();
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println(" --- FINISHED! ---");
    }
}

