/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples.patterns.src;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import javax.security.auth.login.LoginContext;

public class Pattern04ExclusiveChoice {
    public static void main(String[] args) {
        try {
            char[] password = new char[]{'t', 'o', 't', 'o'};
            SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
            ProjectSessionHome prjHome = ProjectSessionUtil.getHome();
            ProjectSession prjSession = prjHome.create();
            System.out.print("\n   Pattern 04 - Exclusive Choice");
            prjSession.initModel("Pattern 04 - Exclusive Choice");
            prjSession.addNode("evaluate_claim", 1);
            prjSession.addNode("pay_damage", 1);
            prjSession.addNode("contact_customer", 1);
            prjSession.setNodeTraditional("evaluate_claim");
            prjSession.setNodeTraditional("pay_damage");
            prjSession.setNodeTraditional("contact_customer");
            String fromEvaluateToPay = prjSession.addEdge("evaluate_claim", "pay_damage");
            String fromEvaluateToContact = prjSession.addEdge("evaluate_claim", "contact_customer");
            prjSession.setNodeProperty("evaluate_claim", "pay", "true", false);
            prjSession.setEdgeCondition(fromEvaluateToPay, "pay.equals(\"true\")");
            prjSession.setEdgeCondition(fromEvaluateToContact, "pay.equals(\"false\")");
            prjSession.addRole("Executor", "Rol that enables to execute the activities");
            prjSession.setUserRole("admin", "Executor");
            prjSession.setNodeRole("evaluate_claim", "Executor");
            prjSession.setNodeRole("pay_damage", "Executor");
            prjSession.setNodeRole("contact_customer", "Executor");
            prjSession.checkModelDefinition();
            System.out.println("   [ OK ]");
        }
        catch (Exception e) {
            System.out.println("\n\n   [ ERROR ] : " + e);
            e.printStackTrace();
        }
    }
}

