/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples.patterns.src;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import javax.security.auth.login.LoginContext;

public class Pattern07SynchronizingMerge {
    public static void main(String[] args) {
        try {
            char[] password = new char[]{'t', 'o', 't', 'o'};
            SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
            ProjectSessionHome prjHome = ProjectSessionUtil.getHome();
            ProjectSession prjSession = prjHome.create();
            System.out.print("\n   Pattern 07 - Synchronizing Merge");
            prjSession.initModel("Pattern 07 - Synchronizing Merge");
            prjSession.addNode("evaluate_damage", 1);
            prjSession.addNode("contact_fire_department", 1);
            prjSession.addNode("contact_insurance", 1);
            prjSession.addNode("contact_both", 1);
            prjSession.addNode("submit_report", 2);
            prjSession.setNodeTraditional("evaluate_damage");
            prjSession.setNodeTraditional("contact_fire_department");
            prjSession.setNodeTraditional("contact_insurance");
            prjSession.setNodeTraditional("contact_both");
            prjSession.setNodeTraditional("submit_report");
            String toFireDep = prjSession.addEdge("evaluate_damage", "contact_fire_department");
            String toInsurance = prjSession.addEdge("evaluate_damage", "contact_insurance");
            String toBoth = prjSession.addEdge("evaluate_damage", "contact_both");
            prjSession.addEdge("contact_fire_department", "submit_report");
            prjSession.addEdge("contact_insurance", "submit_report");
            prjSession.addEdge("contact_both", "submit_report");
            prjSession.setProperty("call_fire_department", "true");
            prjSession.setProperty("call_insurance", "true");
            prjSession.setEdgeCondition(toFireDep, "(call_fire_department.equals(\"true\") && call_insurance.equals(\"false\"))");
            prjSession.setEdgeCondition(toInsurance, "(call_insurance.equals(\"true\") && call_fire_department.equals(\"false\"))");
            prjSession.setEdgeCondition(toBoth, "(call_insurance.equals(\"true\") && call_fire_department.equals(\"true\"))");
            prjSession.addRole("Executor", "Rol that enables to execute the activities");
            prjSession.setUserRole("admin", "Executor");
            prjSession.setNodeRole("evaluate_damage", "Executor");
            prjSession.setNodeRole("contact_fire_department", "Executor");
            prjSession.setNodeRole("contact_insurance", "Executor");
            prjSession.setNodeRole("contact_both", "Executor");
            prjSession.setNodeRole("submit_report", "Executor");
            prjSession.checkModelDefinition();
            System.out.println("   [ OK ]");
        }
        catch (Exception e) {
            System.out.println("\n\n   [ ERROR ] : " + e);
            e.printStackTrace();
        }
    }
}

