/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples.patterns.src;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import javax.security.auth.login.LoginContext;

public class Pattern10ArbitraryCycles2ExtraEntryPoint {
    public static void main(String[] args) {
        try {
            char[] password = new char[]{'t', 'o', 't', 'o'};
            SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
            ProjectSessionHome prjHome = ProjectSessionUtil.getHome();
            ProjectSession prjSession = prjHome.create();
            System.out.print("\n   Pattern 10 - Arbitrary Cycles (Extra Entry Point)");
            prjSession.initModel("Pattern 10 - Arbitrary Cycles (Extra Entry Point)");
            prjSession.addNode("request_demand", 1);
            prjSession.addNode("send_possible_options", 1);
            prjSession.addNode("approve_demand", 1);
            prjSession.addNode("process_demand", 1);
            prjSession.setNodeTraditional("request_demand");
            prjSession.setNodeTraditional("send_possible_options");
            prjSession.setNodeTraditional("approve_demand");
            prjSession.setNodeTraditional("process_demand");
            prjSession.addEdge("request_demand", "approve_demand");
            prjSession.addEdge("send_possible_options", "approve_demand");
            String fromApproveToProcess = prjSession.addEdge("approve_demand", "process_demand");
            prjSession.setProperty("approved", "false");
            prjSession.setProperty("iterations", "1");
            prjSession.setEdgeCondition(fromApproveToProcess, "approved.equals(\"true\")");
            prjSession.addIteration("approve_demand", "request_demand", "approved.equals(\"false\")");
            String approveHookScript = "import hero.interfaces.*;\nbeforeTerminate(Object engine, Object currentNode) {\n\n\n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(currentNode.getBnProject().getName()); \n  BnProjectPropertyValue propIterations = prjSession.getProperty(\"iterations\"); \n  int it= Integer.parseInt(propIterations.getTheValue()); \n  if ( it > 0 ) { \n    it--; \n    prjSession.setProperty(\"iterations\", Integer.toString(it)); \n  } else { \n     prjSession.setProperty(\"approved\", \"true\"); \n  } \n}";
            prjSession.addNodeInterHook("approve_demand", "Approve Hook", "beforeTerminate", 6, approveHookScript);
            prjSession.addRole("Executor", "Rol that enables to execute the activities");
            prjSession.setUserRole("admin", "Executor");
            prjSession.setNodeRole("request_demand", "Executor");
            prjSession.setNodeRole("send_possible_options", "Executor");
            prjSession.setNodeRole("approve_demand", "Executor");
            prjSession.setNodeRole("process_demand", "Executor");
            prjSession.checkModelDefinition();
            System.out.println("   [ OK ]");
        }
        catch (Exception e) {
            System.out.println("\n\n   [ ERROR ] : " + e);
            e.printStackTrace();
        }
    }
}

