/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples.patterns.src;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import javax.security.auth.login.LoginContext;

public class Pattern14MultipleInstancesWithRuntimeKnowledge {
    public static void main(String[] args) {
        try {
            char[] password = new char[]{'t', 'o', 't', 'o'};
            SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
            ProjectSessionHome prjHome = ProjectSessionUtil.getHome();
            ProjectSession prjSession = prjHome.create();
            System.out.print("\n   Pattern 14 - Multiple Instances With a Priori Runtime Knowledge");
            prjSession.initModel("Pattern 14 - Multiple Instances With a Priori Runtime Knowledge");
            prjSession.addNode("order_books", 1);
            prjSession.addNode("shipping_process", 1);
            prjSession.addNode("send_bill", 1);
            prjSession.setNodeTraditional("order_books");
            prjSession.setNodeTraditional("shipping_process");
            prjSession.setNodeTraditional("send_bill");
            prjSession.addEdge("shipping_process", "send_bill");
            prjSession.setProperty("number_of_sub_processes", "2");
            ProjectSession prjSession2 = prjHome.create();
            prjSession2.initModel("Check book avaliability (SubProcess)");
            prjSession2.addNode("check_avaliability", 1);
            prjSession2.setNodeTraditional("check_avaliability");
            String update_stockHookScript = "import hero.interfaces.*;\nbeforeStart(Object engine, Object currentNode) {\n\n\n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(currentNode.getBnProject().getName()); \n  BnProjectPropertyValue bookNameProp = prjSession.getProperty(\"book_name\"); \n  System.out.println(\"   ---> check_avaliability for : \" + bookNameProp.getTheValue()); \n}";
            prjSession2.addNodeInterHook("check_avaliability", "check_avaliability Hook", "beforeStart", 6, update_stockHookScript);
            prjSession2.addRole("Executor", "Rol that enables to execute the activities inside the SubProcess");
            prjSession2.setUserRole("admin", "Executor");
            prjSession2.setNodeRole("check_avaliability", "Executor");
            prjSession2.remove();
            prjSession.addNodeSubProcess("check_book0", "Check book avaliability (SubProcess)");
            prjSession.setNodeProperty("check_book0", "book_name", "check_book0", true);
            prjSession.addEdge("order_books", "check_book0");
            prjSession.addEdge("check_book0", "shipping_process");
            String createSubProcessesScript = "import hero.interfaces.*;\nbeforeStart(Object engine, Object currentNode) {\n\n\n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(currentNode.getBnProject().getName()); \n  BnProjectPropertyValue numberOfSubProcessesProp = prjSession.getProperty(\"number_of_sub_processes\"); \n  int numberOfSubProcesses = Integer.parseInt(numberOfSubProcessesProp.getTheValue()); \n  for (int i = 1; i <= numberOfSubProcesses; i++) { \n    String nodeName = \"check_book\" + Integer.toString(i); \n    prjSession.addNodeSubProcess(nodeName, \"Check book avaliability (SubProcess)\"); \n    prjSession.setNodeProperty(nodeName, \"book_name\", nodeName, true); \n    prjSession.addEdge(nodeName, \"shipping_process\"); \n    prjSession.setNodeRole(nodeName, \"Executor\"); \n  } \n}";
            prjSession.addNodeInterHook("check_book0", "check_book0 Hook", "beforeStart", 6, createSubProcessesScript);
            prjSession.addRole("Executor", "Rol that enables to execute the activities");
            prjSession.setUserRole("admin", "Executor");
            prjSession.setNodeRole("order_books", "Executor");
            prjSession.setNodeRole("check_book0", "Executor");
            prjSession.setNodeRole("shipping_process", "Executor");
            prjSession.setNodeRole("send_bill", "Executor");
            prjSession.checkModelDefinition();
            System.out.println("   [ OK ]");
        }
        catch (Exception e) {
            System.out.println("\n\n   [ ERROR ] : " + e);
            e.printStackTrace();
        }
    }
}

