/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples.patterns.src;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import javax.security.auth.login.LoginContext;

public class Pattern16DeferredChoice {
    public static void main(String[] args) {
        try {
            char[] password = new char[]{'t', 'o', 't', 'o'};
            SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
            ProjectSessionHome prjHome = ProjectSessionUtil.getHome();
            ProjectSession prjSession = prjHome.create();
            System.out.print("\n   Pattern 16 - Deferred Choice");
            prjSession.initModel("Pattern 16 - Deferred Choice");
            prjSession.addNode("select_avaliable_resource", 1);
            prjSession.addNode("load_truck1", 1);
            prjSession.addNode("load_truck2", 1);
            prjSession.setNodeTraditional("select_avaliable_resource");
            prjSession.setNodeTraditional("load_truck1");
            prjSession.setNodeTraditional("load_truck2");
            String toTruck1 = prjSession.addEdge("select_avaliable_resource", "load_truck1");
            String toTruck2 = prjSession.addEdge("select_avaliable_resource", "load_truck2");
            prjSession.setProperty("truck_number", "0");
            prjSession.setEdgeCondition(toTruck1, "truck_number.equals(\"1\")");
            prjSession.setEdgeCondition(toTruck2, "truck_number.equals(\"2\")");
            String simulateAvalibilityHookScript = "import hero.interfaces.*;\nimport java.util.Random; \nbeforeTerminate(Object engine, Object currentNode) {\n\n\n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(currentNode.getBnProject().getName()); \n  Random generator = new Random(System.currentTimeMillis()); \n  int truck = generator.nextInt(2) + 1; \n  prjSession.setProperty(\"truck_number\", Integer.toString(truck)); \n  System.out.println(\"    --> Truck avaliable : \" + truck); \n} \n";
            prjSession.addNodeInterHook("select_avaliable_resource", "select_avaliable_resource hook", "beforeTerminate", 6, simulateAvalibilityHookScript);
            prjSession.addRole("Executor", "Rol that enables to execute the activities");
            prjSession.setUserRole("admin", "Executor");
            prjSession.setNodeRole("select_avaliable_resource", "Executor");
            prjSession.setNodeRole("load_truck1", "Executor");
            prjSession.setNodeRole("load_truck2", "Executor");
            prjSession.checkModelDefinition();
            System.out.println("   [ OK ]");
        }
        catch (Exception e) {
            System.out.println("\n\n   [ ERROR ] : " + e);
            e.printStackTrace();
        }
    }
}

