/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples.patterns.src;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import javax.security.auth.login.LoginContext;

public class Pattern18MilestoneAsDeadline {
    static final long DEADLINE = 1000L;

    public static void main(String[] args) {
        try {
            char[] password = new char[]{'t', 'o', 't', 'o'};
            SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
            ProjectSessionHome prjHome = ProjectSessionUtil.getHome();
            ProjectSession prjSession = prjHome.create();
            System.out.print("\n   Pattern 18 - Milestone as Deadline");
            prjSession.initModel("Pattern 18 - Milestone as Deadline");
            prjSession.addNode("order_book", 1);
            prjSession.addNode("withdraw_order", 1);
            prjSession.addNode("ship_order", 1);
            prjSession.setNodeTraditional("order_book");
            prjSession.setNodeTraditional("withdraw_order");
            prjSession.setNodeTraditional("ship_order");
            prjSession.addEdge("order_book", "ship_order");
            prjSession.addEdge("order_book", "withdraw_order");
            String setDeadlineScript = "import hero.interfaces.*; \nbeforeTerminate(Object engine, Object currentNode) { \n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(currentNode.getBnProject().getName()); \n  ArrayList deadlines = new ArrayList(); \n  long date1 = System.currentTimeMillis() + (long)10000; \n  deadlines.add(new Long(date1)); \n  prjSession.setNodeDeadlines(\"withdraw_order\", deadlines); \n}";
            prjSession.addNodeInterHook("order_book", "order_book Hook", "beforeTerminate", 6, setDeadlineScript);
            String onDeadlineScript = "import hero.interfaces.*; \nonDeadline(Object engine, Object currentNode) { \n  System.out.println(\"\n\n   --> Deadline hook <--\"); \n  UserSessionHome userHome = UserSessionUtil.getHome(); \n  UserSession userSession = userHome.create(); \n  userSession.cancelActivity(currentNode.getBnProject().getName(), \"withdraw_order\"); \n }";
            prjSession.addNodeHook("withdraw_order", "hero.hook.CancelActivity", "onDeadline", 0);
            String cancelScript = "import hero.interfaces.*; \nbeforeStart(Object engine, Object currentNode) { \n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(currentNode.getBnProject().getName()); \n  if (prjSession.getNodeState(\"withdraw_order\") == hero.interfaces.Constants.Nd.READY) { \n    UserSessionHome userHome = UserSessionUtil.getHome(); \n    UserSession userSession = userHome.create(); \n    userSession.cancelActivity(currentNode.getBnProject().getName(), \"withdraw_order\"); \n   } \n}";
            prjSession.addNodeInterHook("ship_order", "ship_order Hook", "beforeStart", 6, cancelScript);
            prjSession.addRole("Executor", "Rol that enables to execute the activities");
            prjSession.setUserRole("admin", "Executor");
            prjSession.setNodeRole("order_book", "Executor");
            prjSession.setNodeRole("withdraw_order", "Executor");
            prjSession.setNodeRole("ship_order", "Executor");
            prjSession.checkModelDefinition();
            System.out.println("   [ OK ]");
        }
        catch (Exception e) {
            System.out.println("\n\n   [ ERROR ] : " + e);
            e.printStackTrace();
        }
    }
}

