/*
 * Decompiled with CFR 0.152.
 */
package hero.client.test;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.AdminSession;
import hero.interfaces.AdminSessionHome;
import hero.interfaces.AdminSessionUtil;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import hero.interfaces.UserRegistration;
import hero.interfaces.UserRegistrationHome;
import hero.interfaces.UserRegistrationUtil;
import java.util.Collection;
import javax.security.auth.login.LoginContext;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class AdminSessionTests
extends TestCase {
    private ProjectSessionHome projectsesh;

    public AdminSessionTests(String testname) {
        super(testname);
    }

    public static TestSuite suite() {
        return new TestSuite(AdminSessionTests.class);
    }

    public void setUp() throws Exception {
    }

    public void testGetModels() throws Exception {
        UserRegistrationHome urHome = UserRegistrationUtil.getHome();
        UserRegistration userReg = urHome.create();
        userReg.userCreate("userAdmin1", "userAdmin1", "miguel.valdes-faura@ext.bull.net");
        userReg.userCreate("userAdmin2", "userAdmin2", "miguel.valdes-faura@ext.bull.net");
        SimpleCallbackHandler handler = new SimpleCallbackHandler("userAdmin1", "userAdmin1".toCharArray());
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        this.projectsesh = ProjectSessionUtil.getHome();
        ProjectSession p = this.projectsesh.create();
        p.initProject("project1");
        p.initModel("project2");
        handler = new SimpleCallbackHandler("userAdmin2", "userAdmin2".toCharArray());
        lc = new LoginContext("TestClient", handler);
        lc.login();
        ProjectSession p2 = this.projectsesh.create();
        p2.initModel("project3");
        p2.initModel("project4");
        AdminSessionHome aHome = AdminSessionUtil.getHome();
        AdminSession adminsession = aHome.create();
        Collection models = adminsession.getModels();
        AdminSessionTests.assertTrue((String)("Error in getModels, " + models.size()), (models.size() == 2 ? 1 : 0) != 0);
        handler = new SimpleCallbackHandler("userAdmin1", "userAdmin1".toCharArray());
        lc = new LoginContext("TestClient", handler);
        lc.login();
    }

    public void testInstances() throws Exception {
        this.projectsesh = ProjectSessionUtil.getHome();
        ProjectSession p = this.projectsesh.create();
        p.initProject("project5");
        p.initModel("project6");
        p.instantiateProject("project6");
        p.instantiateProject("project6");
        SimpleCallbackHandler handler = new SimpleCallbackHandler("userAdmin2", "userAdmin2".toCharArray());
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        ProjectSession p2 = this.projectsesh.create();
        p2.initModel("project7");
        p2.initModel("project8");
        p2.instantiateProject("project7");
        p2.instantiateProject("project7");
        p2.instantiateProject("project7");
        handler = new SimpleCallbackHandler("userAdmin1", "userAdmin1".toCharArray());
        lc = new LoginContext("TestClient", handler);
        lc.login();
        ProjectSession p3 = this.projectsesh.create();
        p3.instantiateProject("project8");
        p3.instantiateProject("project8");
        handler = new SimpleCallbackHandler("userAdmin2", "userAdmin2".toCharArray());
        lc = new LoginContext("TestClient", handler);
        lc.login();
        ProjectSession p4 = this.projectsesh.create();
        p4.instantiateProject("project8");
        AdminSessionHome aHome = AdminSessionUtil.getHome();
        AdminSession adminsession = aHome.create();
        Collection instances = adminsession.getInstances();
        AdminSessionTests.assertTrue((String)("Error in getInstances, " + instances.size()), (instances.size() == 6 ? 1 : 0) != 0);
        handler = new SimpleCallbackHandler("userAdmin1", "userAdmin1".toCharArray());
        lc = new LoginContext("TestClient", handler);
        lc.login();
    }

    public void testActivities() throws Exception {
        this.projectsesh = ProjectSessionUtil.getHome();
        ProjectSession p = this.projectsesh.create();
        p.initProject("project9");
        p.addNode("node1", 1);
        p.initModel("project10");
        p.addNode("node1", 1);
        p.instantiateProject("project10");
        p.addUser("userAdmin2");
        p.instantiateProject("project10");
        SimpleCallbackHandler handler = new SimpleCallbackHandler("userAdmin2", "userAdmin2".toCharArray());
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        ProjectSession p2 = this.projectsesh.create();
        p2.initModel("project11");
        p2.addNode("node1", 1);
        p2.addNode("node2", 1);
        p2.initModel("project12");
        p2.addNode("node1", 1);
        p2.instantiateProject("project11");
        p2.instantiateProject("project11");
        p2.instantiateProject("project11");
        handler = new SimpleCallbackHandler("userAdmin1", "userAdmin1".toCharArray());
        lc = new LoginContext("TestClient", handler);
        lc.login();
        ProjectSession p3 = this.projectsesh.create();
        p3.instantiateProject("project12");
        p3.instantiateProject("project12");
        handler = new SimpleCallbackHandler("userAdmin2", "userAdmin2".toCharArray());
        lc = new LoginContext("TestClient", handler);
        lc.login();
        ProjectSession p4 = this.projectsesh.create();
        p4.instantiateProject("project12");
        AdminSessionHome aHome = AdminSessionUtil.getHome();
        AdminSession adminsession = aHome.create();
        ProjectSession p5 = this.projectsesh.create();
        p5.initProject("project13");
        p5.addNode("node1", 1);
        Collection activities = adminsession.getActivities();
        AdminSessionTests.assertTrue((String)("Error in getInstances, " + activities.size()), (activities.size() == 10 ? 1 : 0) != 0);
        handler = new SimpleCallbackHandler("admin", "toto".toCharArray());
        lc = new LoginContext("TestClient", handler);
        lc.login();
    }
}

