/*
 * Decompiled with CFR 0.152.
 */
package hero.client.test;

import hero.interfaces.Engine;
import hero.interfaces.EngineHome;
import hero.interfaces.EngineUtil;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import hero.util.EngineException;
import hero.util.HeroException;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class EngineTests
extends TestCase {
    private ProjectSessionHome psh;
    private ProjectSession ps;
    private EngineHome eh;
    private Engine eng;

    public EngineTests(String testname) {
        super(testname);
    }

    public static TestSuite suite() {
        return new TestSuite(EngineTests.class);
    }

    public void setUp() throws Exception {
        this.psh = ProjectSessionUtil.getHome();
        this.eh = EngineUtil.getHome();
    }

    public void testEngineAND() throws Exception {
        ProjectSession proj = this.psh.create();
        proj.initProject("work");
        proj.addNode("init", 1);
        proj.addNode("sp1", 3);
        proj.addNode("ac1", 1);
        proj.addNode("ac2", 1);
        proj.addNode("jn1", 3);
        proj.addNode("ac3", 1);
        String e1 = proj.addEdge("init", "sp1");
        String e2 = proj.addEdge("sp1", "ac1");
        String e3 = proj.addEdge("sp1", "ac2");
        String e4 = proj.addEdge("ac1", "jn1");
        String e5 = proj.addEdge("ac2", "jn1");
        String e6 = proj.addEdge("jn1", "ac3");
        proj.addRole("test", "testeur");
        proj.setUserRole("admin", "test");
        proj.checkModelDefinition();
        this.eng = this.eh.create();
        try {
            this.eng.startActivity("work", "ac1");
            EngineTests.assertTrue((String)"start ac1 should have failed", (boolean)false);
        }
        catch (EngineException e) {
            // empty catch block
        }
        try {
            this.eng.terminateActivity("work", "init");
            EngineTests.assertTrue((String)"terminate init should have failed", (boolean)false);
        }
        catch (EngineException e) {
            // empty catch block
        }
        this.eng.startActivity("work", "init");
        proj = this.psh.create();
        proj.initProject("work");
        EngineTests.assertTrue((String)"BnNode State Error init", (proj.getNodeValue("init").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e1", (proj.getEdgeValue(e1).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error sp1", (proj.getNodeValue("sp1").getState() == 5 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e2", (proj.getEdgeValue(e2).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error ac1", (proj.getNodeValue("ac1").getState() == 3 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e3", (proj.getEdgeValue(e3).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error ac2", (proj.getNodeValue("ac2").getState() == 3 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e4", (proj.getEdgeValue(e4).getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e5", (proj.getEdgeValue(e5).getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error jn1", (proj.getNodeValue("jn1").getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e6", (proj.getEdgeValue(e6).getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error ac3", (proj.getNodeValue("ac3").getState() == 0 ? 1 : 0) != 0);
        try {
            this.eng.terminateActivity("work", "sp1");
            EngineTests.assertTrue((String)"terminate sp1 should have failed", (boolean)false);
        }
        catch (EngineException e) {
            // empty catch block
        }
        this.eng.terminateActivity("work", "init");
        EngineTests.assertTrue((String)"BnNode State Error Term init", (proj.getNodeValue("init").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error Term e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error Term sp1", (proj.getNodeValue("sp1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e2", (proj.getEdgeValue(e2).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error ac1", (proj.getNodeValue("ac1").getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e3", (proj.getEdgeValue(e3).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error ac2", (proj.getNodeValue("ac2").getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e4", (proj.getEdgeValue(e4).getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e5", (proj.getEdgeValue(e5).getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error jn1", (proj.getNodeValue("jn1").getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e6", (proj.getEdgeValue(e6).getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error ac3", (proj.getNodeValue("ac3").getState() == 0 ? 1 : 0) != 0);
        this.eng.startActivity("work", "ac1");
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : init", (proj.getNodeValue("init").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : sp1", (proj.getNodeValue("sp1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e2", (proj.getEdgeValue(e2).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac1", (proj.getNodeValue("ac1").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e3", (proj.getEdgeValue(e3).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac2", (proj.getNodeValue("ac2").getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e4", (proj.getEdgeValue(e4).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e5", (proj.getEdgeValue(e5).getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : jn1", (proj.getNodeValue("jn1").getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e6", (proj.getEdgeValue(e6).getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac3", (proj.getNodeValue("ac3").getState() == 0 ? 1 : 0) != 0);
        this.eng.startActivity("work", "ac2");
        EngineTests.assertTrue((String)"BnNode State Error start ac2 : init", (proj.getNodeValue("init").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac2 : e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac2 : sp1", (proj.getNodeValue("sp1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac2 : e2", (proj.getEdgeValue(e2).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac2 : ac1", (proj.getNodeValue("ac1").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac2 : e3", (proj.getEdgeValue(e3).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac2 : ac2", (proj.getNodeValue("ac2").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac2 : e4", (proj.getEdgeValue(e4).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac2 : e5", (proj.getEdgeValue(e5).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac2 : jn1", (proj.getNodeValue("jn1").getState() == 5 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac2 : e6", (proj.getEdgeValue(e6).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac2 : ac3", (proj.getNodeValue("ac3").getState() == 3 ? 1 : 0) != 0);
        this.eng.startActivity("work", "ac3");
        try {
            this.eng.terminate("work");
            EngineTests.assertTrue((String)"should have failed", (boolean)false);
        }
        catch (HeroException h) {
            // empty catch block
        }
        EngineTests.assertTrue((String)"BnNode State Error start ac3 : init", (proj.getNodeValue("init").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac3 : e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac3 : sp1", (proj.getNodeValue("sp1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac3 : e2", (proj.getEdgeValue(e2).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error start ac3 : ac1", (proj.getNodeValue("ac1").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error start ac3 : e3", (proj.getEdgeValue(e3).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error start ac3 : ac2", (proj.getNodeValue("ac2").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error start ac3 : e4", (proj.getEdgeValue(e4).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error start ac3 : e5", (proj.getEdgeValue(e5).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error start ac3 : jn1", (proj.getNodeValue("jn1").getState() == 5 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error start ac3 : e6", (proj.getEdgeValue(e6).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error start ac3 : ac3", (proj.getNodeValue("ac3").getState() == 5 ? 1 : 0) != 0);
        try {
            this.eng.terminateActivity("work", "ac3");
            EngineTests.assertTrue((String)"terminate ac3 should have failed", (boolean)false);
        }
        catch (EngineException e) {
            // empty catch block
        }
        this.eng.terminateActivity("work", "ac1");
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac1 : init", (proj.getNodeValue("init").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac1 : e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac1 : sp1", (proj.getNodeValue("sp1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac1 : e2", (proj.getEdgeValue(e2).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac1 : ac1", (proj.getNodeValue("ac1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac1 : e3", (proj.getEdgeValue(e3).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac1 : ac2", (proj.getNodeValue("ac2").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac1 : e4", (proj.getEdgeValue(e4).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac1 : e5", (proj.getEdgeValue(e5).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac1 : jn1", (proj.getNodeValue("jn1").getState() == 5 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac1 : e6", (proj.getEdgeValue(e6).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac1 : ac3", (proj.getNodeValue("ac3").getState() == 5 ? 1 : 0) != 0);
        this.eng.terminateActivity("work", "ac2");
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac2 : init", (proj.getNodeValue("init").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac2 : e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac2 : sp1", (proj.getNodeValue("sp1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac2 : e2", (proj.getEdgeValue(e2).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac2 : ac1", (proj.getNodeValue("ac1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac2 : e3", (proj.getEdgeValue(e3).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac2 : ac2", (proj.getNodeValue("ac2").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac2 : e4", (proj.getEdgeValue(e4).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac2 : e5", (proj.getEdgeValue(e5).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac2 : jn1", (proj.getNodeValue("jn1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac2 : e6", (proj.getEdgeValue(e6).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac2 : ac3", (proj.getNodeValue("ac3").getState() == 6 ? 1 : 0) != 0);
        this.eng.terminateActivity("work", "ac3");
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac2 : init", (proj.getNodeValue("init").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac2 : e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac2 : sp1", (proj.getNodeValue("sp1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac2 : e2", (proj.getEdgeValue(e2).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac2 : ac1", (proj.getNodeValue("ac1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac2 : e3", (proj.getEdgeValue(e3).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac2 : ac2", (proj.getNodeValue("ac2").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac2 : e4", (proj.getEdgeValue(e4).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac2 : e5", (proj.getEdgeValue(e5).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac2 : jn1", (proj.getNodeValue("jn1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge Value Error terminate ac2 : e6", (proj.getEdgeValue(e6).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode Value Error terminate ac2 : ac3", (proj.getNodeValue("ac3").getState() == 10 ? 1 : 0) != 0);
        try {
            this.eng.startActivity("work", "ac2");
            EngineTests.assertTrue((String)"start ac2 should have failed", (boolean)false);
        }
        catch (EngineException e) {
            // empty catch block
        }
        this.eng.terminate("work");
        EngineTests.assertTrue((String)"Wrong project state", (proj.getDetails().getState() == 2 ? 1 : 0) != 0);
    }

    public void testEngineOR() throws Exception {
        ProjectSession proj = this.psh.create();
        proj.initProject("workOR");
        proj.addNode("init", 1);
        proj.addNode("sp1", 1);
        proj.addNode("ac1", 1);
        proj.addNode("ac2", 1);
        proj.addNode("jn1", 2);
        proj.addNode("ac3", 1);
        String e1 = proj.addEdge("init", "sp1");
        String e2 = proj.addEdge("sp1", "ac1");
        String e3 = proj.addEdge("sp1", "ac2");
        String e4 = proj.addEdge("ac1", "jn1");
        String e5 = proj.addEdge("ac2", "jn1");
        String e6 = proj.addEdge("jn1", "ac3");
        proj.addRole("test", "testeur");
        proj.setUserRole("admin", "test");
        proj.checkModelDefinition();
        this.eng = this.eh.create();
        this.eng.startActivity("workOR", "init");
        this.eng.startActivity("workOR", "sp1");
        proj = this.psh.create();
        proj.initProject("workOR");
        this.eng.terminateActivity("workOR", "init");
        EngineTests.assertTrue((String)"BnNode State Error init", (proj.getNodeValue("init").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error sp1", (proj.getNodeValue("sp1").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e2", (proj.getEdgeValue(e2).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error ac1", (proj.getNodeValue("ac1").getState() == 3 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e3", (proj.getEdgeValue(e3).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error ac2", (proj.getNodeValue("ac2").getState() == 3 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e4", (proj.getEdgeValue(e4).getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e5", (proj.getEdgeValue(e5).getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error jn1", (proj.getNodeValue("jn1").getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e6", (proj.getEdgeValue(e6).getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error ac3", (proj.getNodeValue("ac3").getState() == 0 ? 1 : 0) != 0);
        this.eng.startActivity("workOR", "ac1");
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : init", (proj.getNodeValue("init").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : sp1", (proj.getNodeValue("sp1").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e2", (proj.getEdgeValue(e2).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac1", (proj.getNodeValue("ac1").getState() == 5 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e3", (proj.getEdgeValue(e3).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac2", (proj.getNodeValue("ac2").getState() == 3 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e4", (proj.getEdgeValue(e4).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e5", (proj.getEdgeValue(e5).getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : jn1", (proj.getNodeValue("jn1").getState() == 3 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e6", (proj.getEdgeValue(e6).getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac3", (proj.getNodeValue("ac3").getState() == 0 ? 1 : 0) != 0);
        this.eng.startActivity("workOR", "ac2");
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : init", (proj.getNodeValue("init").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : sp1", (proj.getNodeValue("sp1").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e2", (proj.getEdgeValue(e2).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac1", (proj.getNodeValue("ac1").getState() == 5 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e3", (proj.getEdgeValue(e3).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac2", (proj.getNodeValue("ac2").getState() == 5 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e4", (proj.getEdgeValue(e4).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e5", (proj.getEdgeValue(e5).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : jn1", (proj.getNodeValue("jn1").getState() == 3 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e6", (proj.getEdgeValue(e6).getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac3", (proj.getNodeValue("ac3").getState() == 0 ? 1 : 0) != 0);
        this.eng.terminateActivity("workOR", "sp1");
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : init", (proj.getNodeValue("init").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : sp1", (proj.getNodeValue("sp1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e2", (proj.getEdgeValue(e2).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac1", (proj.getNodeValue("ac1").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e3", (proj.getEdgeValue(e3).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac2", (proj.getNodeValue("ac2").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e4", (proj.getEdgeValue(e4).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e5", (proj.getEdgeValue(e5).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : jn1", (proj.getNodeValue("jn1").getState() == 3 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e6", (proj.getEdgeValue(e6).getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac3", (proj.getNodeValue("ac3").getState() == 0 ? 1 : 0) != 0);
        this.eng.terminateActivity("workOR", "ac1");
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : init", (proj.getNodeValue("init").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : sp1", (proj.getNodeValue("sp1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e2", (proj.getEdgeValue(e2).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac1", (proj.getNodeValue("ac1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e3", (proj.getEdgeValue(e3).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac2", (proj.getNodeValue("ac2").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e4", (proj.getEdgeValue(e4).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e5", (proj.getEdgeValue(e5).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : jn1", (proj.getNodeValue("jn1").getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e6", (proj.getEdgeValue(e6).getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac3", (proj.getNodeValue("ac3").getState() == 0 ? 1 : 0) != 0);
        this.eng.terminateActivity("workOR", "ac2");
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : init", (proj.getNodeValue("init").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : sp1", (proj.getNodeValue("sp1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e2", (proj.getEdgeValue(e2).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac1", (proj.getNodeValue("ac1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e3", (proj.getEdgeValue(e3).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac2", (proj.getNodeValue("ac2").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e4", (proj.getEdgeValue(e4).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e5", (proj.getEdgeValue(e5).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : jn1", (proj.getNodeValue("jn1").getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e6", (proj.getEdgeValue(e6).getState() == 0 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac3", (proj.getNodeValue("ac3").getState() == 0 ? 1 : 0) != 0);
        this.eng.startActivity("workOR", "jn1");
        this.eng.startActivity("workOR", "ac3");
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : init", (proj.getNodeValue("init").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : sp1", (proj.getNodeValue("sp1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e2", (proj.getEdgeValue(e2).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac1", (proj.getNodeValue("ac1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e3", (proj.getEdgeValue(e3).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac2", (proj.getNodeValue("ac2").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e4", (proj.getEdgeValue(e4).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e5", (proj.getEdgeValue(e5).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : jn1", (proj.getNodeValue("jn1").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error start ac1 : e6", (proj.getEdgeValue(e6).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error start ac1 : ac3", (proj.getNodeValue("ac3").getState() == 5 ? 1 : 0) != 0);
        try {
            this.eng.terminateActivity("workOR", "ac3");
            EngineTests.assertTrue((String)"should have failed", (boolean)false);
        }
        catch (HeroException h) {
            // empty catch block
        }
        this.eng.terminateActivity("workOR", "jn1");
        this.eng.terminateActivity("workOR", "ac3");
        this.eng.terminate("workOR");
        EngineTests.assertTrue((String)"Wrong project state", (proj.getDetails().getState() == 2 ? 1 : 0) != 0);
    }

    public void testCancelANDActivity() throws Exception {
        ProjectSession proj = this.psh.create();
        proj.initProject("workCancel");
        proj.addNode("init", 1);
        proj.addNode("sp1", 1);
        proj.addNode("ac1", 1);
        proj.addNode("ac2", 1);
        String e1 = proj.addEdge("init", "sp1");
        String e2 = proj.addEdge("sp1", "ac1");
        String e3 = proj.addEdge("sp1", "ac2");
        proj.addRole("test", "testeur");
        proj.setUserRole("admin", "test");
        proj.checkModelDefinition();
        this.eng = this.eh.create();
        this.eng.startActivity("workCancel", "init");
        this.eng.startActivity("workCancel", "sp1");
        proj = this.psh.create();
        proj.initProject("workCancel");
        this.eng.terminateActivity("workCancel", "init");
        this.eng.cancelActivity("workCancel", "sp1");
        EngineTests.assertTrue((String)"BnNode State Error init", (proj.getNodeValue("init").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error sp1", (proj.getNodeValue("sp1").getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e2", (proj.getEdgeValue(e2).getState() == 3 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error ac1", (proj.getNodeValue("ac1").getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e3", (proj.getEdgeValue(e3).getState() == 3 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error ac2", (proj.getNodeValue("ac2").getState() == 2 ? 1 : 0) != 0);
        this.eng.terminate("workCancel");
        EngineTests.assertTrue((String)"Wrong project state", (proj.getDetails().getState() == 2 ? 1 : 0) != 0);
    }

    public void testCancelORActivity() throws Exception {
        ProjectSession proj = this.psh.create();
        proj.initProject("workCancelOR");
        proj.addNode("init", 1);
        proj.addNode("sp1", 1);
        proj.addNode("ac1", 1);
        proj.addNode("ac2", 1);
        proj.addNode("ac3", 2);
        String e1 = proj.addEdge("init", "sp1");
        String e2 = proj.addEdge("sp1", "ac1");
        String e3 = proj.addEdge("sp1", "ac2");
        String e4 = proj.addEdge("ac1", "ac3");
        String e5 = proj.addEdge("ac2", "ac3");
        proj.addRole("test", "testeur");
        proj.setUserRole("admin", "test");
        proj.checkModelDefinition();
        this.eng = this.eh.create();
        this.eng.startActivity("workCancelOR", "init");
        this.eng.startActivity("workCancelOR", "sp1");
        this.eng.terminateActivity("workCancelOR", "init");
        this.eng.terminateActivity("workCancelOR", "sp1");
        this.eng.startActivity("workCancelOR", "ac2");
        this.eng.cancelActivity("workCancelOR", "ac1");
        EngineTests.assertTrue((String)"BnNode State Error init", (proj.getNodeValue("init").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error sp1", (proj.getNodeValue("sp1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e2", (proj.getEdgeValue(e2).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error ac1", (proj.getNodeValue("ac1").getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e3", (proj.getEdgeValue(e3).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error ac2", (proj.getNodeValue("ac2").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e4", (proj.getEdgeValue(e4).getState() == 3 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e5", (proj.getEdgeValue(e5).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error ac3", (proj.getNodeValue("ac3").getState() == 3 ? 1 : 0) != 0);
    }

    public void testAutomaticNode() throws Exception {
        ProjectSession proj = this.psh.create();
        proj.initProject("testoto");
        proj.addNode("nonode", 1);
        proj.addNode("supernonode", 3);
        proj.addEdge("nonode", "supernonode");
        proj.checkModelDefinition();
        Engine eng = this.eh.create();
        eng.startActivity("testoto", "nonode");
        EngineTests.assertTrue((String)"Supernonode will be terminated", (proj.getNodeValue("supernonode").getState() == 5 ? 1 : 0) != 0);
        eng.terminateActivity("testoto", "nonode");
        EngineTests.assertTrue((String)"Supernonode will be terminated", (proj.getNodeValue("supernonode").getState() == 10 ? 1 : 0) != 0);
    }

    public void testAutomaticNodeOR() throws Exception {
        ProjectSession proj = this.psh.create();
        proj.initProject("testoto2");
        proj.addNode("nonode", 1);
        proj.addNode("nonode2", 1);
        proj.addNode("supernonode", 4);
        proj.addEdge("nonode", "supernonode");
        proj.addEdge("nonode2", "supernonode");
        proj.checkModelDefinition();
        Engine eng = this.eh.create();
        eng.startActivity("testoto2", "nonode");
        EngineTests.assertTrue((String)"Supernonode will be anticipating ", (proj.getNodeValue("supernonode").getState() == 5 ? 1 : 0) != 0);
        eng.startActivity("testoto2", "nonode2");
        eng.terminateActivity("testoto2", "nonode");
        EngineTests.assertTrue((String)"Supernonode will be anticipating", (proj.getNodeValue("supernonode").getState() == 10 ? 1 : 0) != 0);
    }

    public void testTraditionalActivityNode() throws Exception {
        ProjectSession proj = this.psh.create();
        proj.initProject("testtradacti");
        proj.addNode("nonode", 1);
        proj.addNode("supernonode", 1);
        proj.setNodeTraditional("supernonode");
        proj.addEdge("nonode", "supernonode");
        proj.checkModelDefinition();
        Engine eng = this.eh.create();
        eng.startActivity("testtradacti", "nonode");
        EngineTests.assertTrue((String)"Supernonode will be initial", (proj.getNodeValue("supernonode").getState() == 0 ? 1 : 0) != 0);
        eng.terminateActivity("testtradacti", "nonode");
        EngineTests.assertTrue((String)"Supernonode will be ready", (proj.getNodeValue("supernonode").getState() == 1 ? 1 : 0) != 0);
    }

    public void testTraditionalAutomaticNode() throws Exception {
        ProjectSession proj = this.psh.create();
        proj.initProject("testtrad");
        proj.addNode("nonode", 1);
        proj.addNode("supernonode", 3);
        proj.setNodeTraditional("supernonode");
        proj.addEdge("nonode", "supernonode");
        proj.checkModelDefinition();
        Engine eng = this.eh.create();
        eng.startActivity("testtrad", "nonode");
        EngineTests.assertTrue((String)"Supernonode will be initial", (proj.getNodeValue("supernonode").getState() == 0 ? 1 : 0) != 0);
        eng.terminateActivity("testtrad", "nonode");
        EngineTests.assertTrue((String)"Supernonode will be terminated", (proj.getNodeValue("supernonode").getState() == 10 ? 1 : 0) != 0);
    }

    public void testEdgeConditionPropagation() throws Exception {
        ProjectSession proj = this.psh.create();
        proj.initProject("edgeCondP");
        proj.addNode("nonode", 1);
        proj.addNode("supernonode", 1);
        String e1 = proj.addEdge("nonode", "supernonode");
        proj.setEdgeCondition(e1, "(node.getName()).equals(\"nonode\")");
        proj.checkModelDefinition();
        Engine eng = this.eh.create();
        eng.startActivity("edgeCondP", "nonode");
        EngineTests.assertTrue((String)"BnNode State Error nonode", (proj.getNodeValue("nonode").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error supernonode", (proj.getNodeValue("supernonode").getState() == 3 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e1", (proj.getEdgeValue(e1).getState() == 2 ? 1 : 0) != 0);
        eng.terminateActivity("edgeCondP", "nonode");
        EngineTests.assertTrue((String)"BnNode State Error nonode", (proj.getNodeValue("nonode").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error supernonode", (proj.getNodeValue("supernonode").getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
    }

    public void testEdgeConditionPropagationProperty() throws Exception {
        ProjectSession proj = this.psh.create();
        proj.initProject("edgeCondPP");
        proj.addNode("nonode", 1);
        proj.addNode("supernonode", 1);
        proj.setNodeProperty("nonode", "prop1", "value1", true);
        String e1 = proj.addEdge("nonode", "supernonode");
        proj.setEdgeCondition(e1, "prop1.equals(\"value1\")");
        proj.checkModelDefinition();
        Engine eng = this.eh.create();
        eng.startActivity("edgeCondPP", "nonode");
        EngineTests.assertTrue((String)"BnNode State Error nonode", (proj.getNodeValue("nonode").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error supernonode", (proj.getNodeValue("supernonode").getState() == 3 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e1", (proj.getEdgeValue(e1).getState() == 2 ? 1 : 0) != 0);
        eng.terminateActivity("edgeCondPP", "nonode");
        EngineTests.assertTrue((String)"BnNode State Error nonode", (proj.getNodeValue("nonode").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error supernonode", (proj.getNodeValue("supernonode").getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
    }

    public void testEdgeConditionNotPropagation() throws Exception {
        ProjectSession proj = this.psh.create();
        proj.initProject("edgeCondNP");
        proj.addNode("nonode", 1);
        proj.addNode("supernonode", 1);
        String e1 = proj.addEdge("nonode", "supernonode");
        proj.setEdgeCondition(e1, "(node.getName()).equals(\"supernonode\")");
        proj.checkModelDefinition();
        Engine eng = this.eh.create();
        eng.startActivity("edgeCondNP", "nonode");
        EngineTests.assertTrue((String)"BnNode State Error nonode", (proj.getNodeValue("nonode").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error supernonode", (proj.getNodeValue("supernonode").getState() == 3 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e1", (proj.getEdgeValue(e1).getState() == 2 ? 1 : 0) != 0);
        eng.terminateActivity("edgeCondNP", "nonode");
        EngineTests.assertTrue((String)"BnNode State Error nonode", (proj.getNodeValue("nonode").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error supernonode", (proj.getNodeValue("supernonode").getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e1", (proj.getEdgeValue(e1).getState() == 3 ? 1 : 0) != 0);
    }

    public void testEdgeConditionANDSplitPropagation() throws Exception {
        ProjectSession proj = this.psh.create();
        proj.initProject("edgeCondSP");
        proj.addNode("nonode", 1);
        proj.addNode("nonode1", 1);
        proj.addNode("nonode2", 1);
        proj.addNode("supernonode", 1);
        String e1 = proj.addEdge("nonode", "nonode1");
        String e2 = proj.addEdge("nonode1", "nonode2");
        String e3 = proj.addEdge("nonode1", "supernonode");
        proj.setEdgeCondition(e1, "(node.getName()).equals(\"nonode\")");
        proj.setEdgeCondition(e2, "(node.getName()).equals(\"nonode1\")");
        proj.setEdgeCondition(e3, "(node.getName()).equals(\"nonode1\")");
        proj.checkModelDefinition();
        Engine eng = this.eh.create();
        eng.startActivity("edgeCondSP", "nonode");
        eng.startActivity("edgeCondSP", "nonode1");
        EngineTests.assertTrue((String)"BnNode State Error nonode", (proj.getNodeValue("nonode").getState() == 6 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error nonode1", (proj.getNodeValue("nonode1").getState() == 5 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error nonode2", (proj.getNodeValue("nonode2").getState() == 3 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error supernonode", (proj.getNodeValue("supernonode").getState() == 3 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e1", (proj.getEdgeValue(e1).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e2", (proj.getEdgeValue(e2).getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e3", (proj.getEdgeValue(e3).getState() == 2 ? 1 : 0) != 0);
        eng.terminateActivity("edgeCondSP", "nonode");
        eng.terminateActivity("edgeCondSP", "nonode1");
        EngineTests.assertTrue((String)"BnNode State Error nonode", (proj.getNodeValue("nonode").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error nonode1", (proj.getNodeValue("nonode1").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error nonode2", (proj.getNodeValue("nonode2").getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error supernonode", (proj.getNodeValue("supernonode").getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e1", (proj.getEdgeValue(e1).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e2", (proj.getEdgeValue(e2).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e3", (proj.getEdgeValue(e3).getState() == 1 ? 1 : 0) != 0);
    }

    public void testEdgeConditionORSplitPropagation() throws Exception {
        ProjectSession proj = this.psh.create();
        proj.initProject("edgeCondOP");
        proj.addNode("nonode", 1);
        proj.addNode("nonode1", 1);
        proj.addNode("nonode2", 1);
        proj.addNode("supernonode", 1);
        String e1 = proj.addEdge("nonode", "nonode1");
        String e2 = proj.addEdge("nonode", "nonode2");
        String e3 = proj.addEdge("nonode", "supernonode");
        proj.setEdgeCondition(e1, "(node.getName()).equals(\"nonode1\")");
        proj.setEdgeCondition(e2, "(node.getName()).equals(\"nonode\")");
        proj.setEdgeCondition(e3, "(node.getName()).equals(\"nonode1\")");
        proj.checkModelDefinition();
        Engine eng = this.eh.create();
        eng.startActivity("edgeCondOP", "nonode");
        eng.terminateActivity("edgeCondOP", "nonode");
        EngineTests.assertTrue((String)"BnNode State Error nonode", (proj.getNodeValue("nonode").getState() == 10 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error nonode1", (proj.getNodeValue("nonode1").getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error nonode2", (proj.getNodeValue("nonode2").getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnNode State Error supernonode", (proj.getNodeValue("supernonode").getState() == 2 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e1", (proj.getEdgeValue(e1).getState() == 3 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e2", (proj.getEdgeValue(e2).getState() == 1 ? 1 : 0) != 0);
        EngineTests.assertTrue((String)"BnEdge State Error e3", (proj.getEdgeValue(e3).getState() == 3 ? 1 : 0) != 0);
    }
}

