/*
 * Decompiled with CFR 0.152.
 */
package hero.entity;

import hero.entity.EdgeState;
import hero.interfaces.BnNodeLocal;
import hero.util.BonitaProjectLocator;
import hero.util.BonitaServiceValue;
import hero.util.values.BonitaEdgeValue;
import hero.util.values.BonitaProjectValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class AndEdgeState
extends EdgeState
implements Serializable {
    private static AndEdgeState nd;

    public static AndEdgeState getInstance() {
        if (nd == null) {
            nd = new AndEdgeState();
        }
        return nd;
    }

    public int state(BnNodeLocal node) {
        Collection edgesInstance = new ArrayList();
        Collection edgesModel = new ArrayList();
        try {
            edgesInstance = BonitaServiceValue.getNode(node.getBnProject(), node.getName()).getInEdges();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String nodeName = node.getName();
        if (this.isInstance(node.getName())) {
            nodeName = this.getModel(nodeName);
        }
        try {
            String modelName = this.getModel(node.getBnProject().getName());
            String modelVersion = node.getBnProject().getVersion();
            BonitaProjectValue model = BonitaProjectLocator.getInstance().getModelValue(modelName, modelVersion);
            edgesModel = node.getBnProject().getType().equals("Cooperative") ? BonitaServiceValue.getNode(model.getName(), model.getVersion(), nodeName).getInEdges() : BonitaServiceValue.getNodeFromCache(model, nodeName).getInEdges();
        }
        catch (Exception e) {
            edgesModel = new ArrayList();
        }
        if (edgesInstance.size() > 0 || edgesModel.size() > 0) {
            edgesInstance = this.concatEdges(edgesInstance, edgesModel);
        }
        for (BonitaEdgeValue edge : edgesInstance) {
            if (edge.getState() != 3) continue;
            return 7;
        }
        Iterator it = edgesInstance.iterator();
        int result = 6;
        while (it.hasNext()) {
            BonitaEdgeValue edge = (BonitaEdgeValue)it.next();
            if (edge.getState() == 0) {
                result = 4;
                break;
            }
            if (edge.getState() != 2) continue;
            result = 5;
        }
        return result;
    }

    private String getModel(String instanceName) {
        int i = instanceName.indexOf("_instance");
        return instanceName.substring(0, i);
    }

    private boolean isInstance(String name) {
        return name.matches(".*_instance.*");
    }

    private Collection concatEdges(Collection edgesInstance, Collection edgesModel) {
        Collection<BonitaEdgeValue> result = new ArrayList();
        boolean found = false;
        result = edgesInstance;
        Iterator it = edgesModel.iterator();
        while (it.hasNext()) {
            found = false;
            BonitaEdgeValue el = (BonitaEdgeValue)it.next();
            String nodeName = el.getInNode();
            for (BonitaEdgeValue insEd : edgesInstance) {
                String node = insEd.getInNode();
                if (this.isInstance(node)) {
                    node = this.getModel(node);
                }
                if (!nodeName.equals(node)) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(el);
        }
        return result;
    }
}

