/*
 * Decompiled with CFR 0.152.
 */
package hero.initiatorMapper;

import hero.initiatorMapper.CustomInitiatorMapper;
import hero.initiatorMapper.LdapInitiatorMapper;
import hero.interfaces.BnProjectLocal;
import hero.util.HeroException;
import java.io.Serializable;
import java.util.Collection;

public abstract class InitiatorMapper
implements Serializable {
    public static final int LDAP = 0;
    public static final int CUSTOM = 1;
    private String name;
    private int type;

    public static InitiatorMapper make(String name, int type) throws HeroException {
        if (type == 0) {
            return new LdapInitiatorMapper(name, type);
        }
        if (type == 1) {
            return new CustomInitiatorMapper(name, type);
        }
        throw new HeroException("Wrong Mapper Type " + type);
    }

    protected InitiatorMapper(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String toXML() {
        String result = new String();
        result = "<initiator mapper name=\"" + this.getName() + "\" type=\"" + this.getType() + "\"/>";
        return result;
    }

    public abstract Collection execute(Object var1, int var2, BnProjectLocal var3, String var4) throws HeroException;
}

