/*
 * Decompiled with CFR 0.152.
 */
package hero.util;

import hero.util.HeroException;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

public class BonitaConfig {
    private ObjectName config;
    private MBeanServer server;
    private static BonitaConfig bc = null;

    public BonitaConfig() throws HeroException {
        try {
            this.config = new ObjectName("bonita:type=bonitaservice,name=Config");
            ArrayList<MBeanServer> list = MBeanServerFactory.findMBeanServer(null);
            this.server = (MBeanServer)list.iterator().next();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HeroException(e.getMessage());
        }
    }

    public static BonitaConfig getInstance() throws HeroException {
        if (bc == null) {
            bc = new BonitaConfig();
        }
        return bc;
    }

    public void setJms(boolean jms) throws HeroException {
        try {
            this.server.invoke(this.config, "updateJms", new Object[]{new Boolean(jms)}, new String[]{"boolean"});
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public void setHistoric(String value) throws HeroException {
        try {
            this.server.invoke(this.config, "updateHistoric", new Object[]{value}, new String[]{"".getClass().getName()});
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public void setLogLevel(String value) throws HeroException {
        try {
            this.server.invoke(this.config, "updateLogLevel", new Object[]{value}, new String[]{"".getClass().getName()});
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public void setTraceLevel(String value) throws HeroException {
        try {
            this.server.invoke(this.config, "updateTraceLevel", new Object[]{value}, new String[]{"".getClass().getName()});
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public void setProperty(String key, String value) throws HeroException {
        try {
            this.server.invoke(this.config, "updateProperty", new Object[]{key, value}, new String[]{"".getClass().getName(), "".getClass().getName()});
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public boolean getJms() throws HeroException {
        try {
            return (Boolean)this.server.getAttribute(this.config, "Jms");
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public String getHistoric() throws HeroException {
        try {
            return (String)this.server.getAttribute(this.config, "Historic");
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public String getLogLevel() throws HeroException {
        try {
            return (String)this.server.getAttribute(this.config, "LogLevel");
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public String getTraceLevel() throws HeroException {
        try {
            return (String)this.server.getAttribute(this.config, "TraceLevel");
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public String getProperty(String key) throws HeroException {
        try {
            return (String)this.server.invoke(this.config, "getProperty", new Object[]{key}, new String[]{"".getClass().getName()});
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }
}

