/*
 * Decompiled with CFR 0.152.
 */
package hero.util;

import hero.util.HeroException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.objectweb.carol.util.configuration.ConfigurationRepository;
import org.objectweb.carol.util.configuration.ProtocolConfiguration;

public class BonitaConfigClient {
    private ObjectName config;
    private MBeanServerConnection server;
    private static BonitaConfigClient bc = null;

    public BonitaConfigClient() throws HeroException {
        try {
            ProtocolConfiguration protocolConfiguration = ConfigurationRepository.getCurrentConfiguration();
            String sCarolURL = protocolConfiguration.getProviderURL();
            URI carolURL = new URI(sCarolURL);
            String host = carolURL.getHost();
            int portNb = carolURL.getPort();
            String port = String.valueOf(portNb);
            String url = null;
            url = "service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/jrmpconnector_jonas";
            JMXServiceURL connURL = null;
            try {
                connURL = new JMXServiceURL(url);
            }
            catch (MalformedURLException e) {
                throw new HeroException("Can't create JMXServiceURL with string: " + url);
            }
            JMXConnector connector = null;
            try {
                connector = JMXConnectorFactory.newJMXConnector(connURL, null);
            }
            catch (MalformedURLException e1) {
                throw new HeroException("there is no provider for the protocol in " + url);
            }
            catch (IOException e) {
                throw new HeroException("Connector client cannot be made because of a communication problem (used URL: " + url + ")");
            }
            try {
                connector.connect(null);
                this.server = connector.getMBeanServerConnection();
            }
            catch (IOException ioe) {
                throw new HeroException("connection could not be made because of a communication problem");
            }
            this.config = new ObjectName("bonita:type=bonitaservice,name=Config");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HeroException(e.getMessage());
        }
    }

    public static BonitaConfigClient getInstance() throws HeroException {
        if (bc == null) {
            bc = new BonitaConfigClient();
        }
        return bc;
    }

    public void setJms(boolean jms) throws HeroException {
        try {
            this.server.invoke(this.config, "updateJms", new Object[]{new Boolean(jms)}, new String[]{"boolean"});
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public void setHistoric(String value) throws HeroException {
        try {
            this.server.invoke(this.config, "updateHistoric", new Object[]{value}, new String[]{"".getClass().getName()});
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public void setLogLevel(String value) throws HeroException {
        try {
            this.server.invoke(this.config, "updateLogLevel", new Object[]{value}, new String[]{"".getClass().getName()});
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public void setTraceLevel(String value) throws HeroException {
        try {
            this.server.invoke(this.config, "updateTraceLevel", new Object[]{value}, new String[]{"".getClass().getName()});
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public boolean getJms() throws HeroException {
        try {
            return (Boolean)this.server.getAttribute(this.config, "Jms");
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public String getHistoric() throws HeroException {
        try {
            return (String)this.server.getAttribute(this.config, "Historic");
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public String getLogLevel() throws HeroException {
        try {
            return (String)this.server.getAttribute(this.config, "LogLevel");
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public String getTraceLevel() throws HeroException {
        try {
            return (String)this.server.getAttribute(this.config, "TraceLevel");
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }
}

