/*
 * Decompiled with CFR 0.152.
 */
package hero.util;

import hero.interfaces.BnEdgeLocal;
import hero.interfaces.BnNodeHookLocal;
import hero.interfaces.BnNodeInterHookLocal;
import hero.interfaces.BnNodeLocal;
import hero.interfaces.BnProjectHookLocal;
import hero.interfaces.BnProjectInterHookLocal;
import hero.interfaces.BnProjectLocal;
import hero.interfaces.BnProjectLocalHome;
import hero.interfaces.BnProjectUtil;
import hero.util.HeroException;
import hero.util.values.BonitaEdgeValue;
import hero.util.values.BonitaHookValue;
import hero.util.values.BonitaInterHookValue;
import hero.util.values.BonitaNodeValue;
import hero.util.values.BonitaProjectValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public final class BonitaServiceValue
implements Serializable {
    public static BonitaNodeValue getNodeFromCache(BonitaProjectValue pv, String nodeName) {
        Collection nodes = pv.getNodes();
        for (BonitaNodeValue nValue : nodes) {
            if (!nValue.getName().equals(nodeName)) continue;
            return nValue;
        }
        return null;
    }

    public static BonitaNodeValue getNode(BnProjectLocal pl, String nodeName) throws HeroException {
        try {
            BnNodeLocal nd = pl.getBnNode(nodeName);
            return BonitaServiceValue.generateNode(nd, pl);
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public static BonitaNodeValue getNode(String projectName, String projectVersion, String nodeName) throws HeroException {
        try {
            BnProjectLocalHome ph = BnProjectUtil.getLocalHome();
            BnProjectLocal pl = ph.findByNameVersion(projectName, projectVersion);
            BnNodeLocal nd = pl.getBnNode(nodeName);
            return BonitaServiceValue.generateNode(nd, pl);
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }

    public static Collection getProjectHooks(BnProjectLocal pl) throws HeroException {
        ArrayList<BonitaHookValue> projectHooks = new ArrayList<BonitaHookValue>();
        Collection hooks = pl.getBnHooks();
        for (BnProjectHookLocal ph : hooks) {
            BonitaHookValue hook = new BonitaHookValue();
            hook.setName(ph.getName());
            hook.setEvent(ph.getEvent());
            hook.setType(ph.getType());
            projectHooks.add(hook);
        }
        return projectHooks;
    }

    public static Collection getProjectInterHooks(BnProjectLocal pl) throws HeroException {
        ArrayList<BonitaInterHookValue> projectHooks = new ArrayList<BonitaInterHookValue>();
        Collection hooks = pl.getBnInterHooks();
        for (BnProjectInterHookLocal ph : hooks) {
            BonitaInterHookValue hook = new BonitaInterHookValue();
            hook.setName(ph.getName());
            hook.setEvent(ph.getEvent());
            hook.setType(ph.getType());
            hook.setScript(ph.getScript());
            projectHooks.add(hook);
        }
        return projectHooks;
    }

    public static BonitaNodeValue generateNode(BnNodeLocal nd, BnProjectLocal pl) throws HeroException {
        try {
            BonitaNodeValue nv = new BonitaNodeValue();
            BonitaNodeValue node = new BonitaNodeValue();
            node.setProjectName(pl.getName());
            node.setName(nd.getName());
            node.setType(nd.getType());
            if (nd.getType() == 5) {
                node.setReference(nd.getReference());
            }
            Collection inEdges = nd.getInBnEdges();
            Iterator inEdgesI = inEdges.iterator();
            ArrayList<BonitaEdgeValue> nodeInEdges = new ArrayList<BonitaEdgeValue>();
            while (inEdgesI.hasNext()) {
                BnEdgeLocal el = (BnEdgeLocal)inEdgesI.next();
                BonitaEdgeValue inEdge = new BonitaEdgeValue();
                inEdge.setName(el.getName());
                inEdge.setCondition(el.getCondition());
                inEdge.setState(el.getState());
                inEdge.setInNode(el.getInBnNode().getName());
                inEdge.setOutNode(el.getOutBnNode().getName());
                nodeInEdges.add(inEdge);
            }
            node.setInEdges(nodeInEdges);
            Collection outEdges = nd.getOutBnEdges();
            Iterator outEdgesI = outEdges.iterator();
            ArrayList<BonitaEdgeValue> nodeOutEdges = new ArrayList<BonitaEdgeValue>();
            while (outEdgesI.hasNext()) {
                BnEdgeLocal el = (BnEdgeLocal)outEdgesI.next();
                BonitaEdgeValue outEdge = new BonitaEdgeValue();
                outEdge.setName(el.getName());
                outEdge.setCondition(el.getCondition());
                outEdge.setState(el.getState());
                outEdge.setInNode(el.getInBnNode().getName());
                outEdge.setOutNode(el.getOutBnNode().getName());
                nodeOutEdges.add(outEdge);
            }
            node.setOutEdges(nodeOutEdges);
            Collection nodeHooks = pl.getBnNode(nd.getName()).getBnHooks();
            Iterator nodeHooksI = nodeHooks.iterator();
            ArrayList<BonitaHookValue> nodeHks = new ArrayList<BonitaHookValue>();
            while (nodeHooksI.hasNext()) {
                BnNodeHookLocal ph = (BnNodeHookLocal)nodeHooksI.next();
                BonitaHookValue hook = new BonitaHookValue();
                hook.setName(ph.getName());
                hook.setEvent(ph.getEvent());
                hook.setType(ph.getType());
                nodeHks.add(hook);
            }
            node.setHooks(nodeHks);
            Collection nodeInterHooks = pl.getBnNode(nd.getName()).getBnInterHooks();
            Iterator nodeInterHooksI = nodeInterHooks.iterator();
            ArrayList<BonitaInterHookValue> nodeInterHks = new ArrayList<BonitaInterHookValue>();
            while (nodeInterHooksI.hasNext()) {
                BnNodeInterHookLocal pih = (BnNodeInterHookLocal)nodeInterHooksI.next();
                BonitaInterHookValue interHook = new BonitaInterHookValue();
                interHook.setName(pih.getName());
                interHook.setEvent(pih.getEvent());
                interHook.setType(pih.getType());
                interHook.setScript(pih.getScript());
                nodeInterHks.add(interHook);
            }
            node.setInterHooks(nodeInterHks);
            return node;
        }
        catch (Exception e) {
            throw new HeroException(e.getMessage());
        }
    }
}

