/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public abstract class Header
extends HttpCondition
implements Parameterized {
    private final ParameterizedPatternParser name;
    private final ParameterizedPatternParser value;

    private Header(String name, String value) {
        Assert.notNull((Object)name, (String)"Header name pattern cannot be null.");
        Assert.notNull((Object)value, (String)"Header value pattern cannot be null.");
        this.name = new RegexParameterizedPatternParser(name);
        this.value = new RegexParameterizedPatternParser(value);
    }

    public static Header matches(final String name, final String value) {
        return new Header(name, value){

            public String toString() {
                return "Header.matches(\"" + name + "\", \"" + value + "\")";
            }
        };
    }

    public static Header exists(final String name) {
        return new Header(name, "{" + Header.class.getName() + "_value}"){

            public String toString() {
                return "Header.exists(\"" + name + "\")";
            }
        };
    }

    public static Header valueExists(final String value) {
        return new Header("{" + Header.class.getName() + "_name}", value){

            public String toString() {
                return "Header.valueExists(\"" + value + "\")";
            }
        };
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        HttpServletRequest request = (HttpServletRequest)event.getRequest();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            for (String header : Collections.list(headerNames)) {
                if (!this.name.parse(header).submit((Rewrite)event, context) || !this.matchesValue((Rewrite)event, context, request, header)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesValue(Rewrite event, EvaluationContext context, HttpServletRequest request, String header) {
        Enumeration headers = request.getHeaders(header);
        if (headers != null) {
            for (String contents : Collections.list(headers)) {
                if (!this.value.parse(contents).submit(event, context)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> getRequiredParameterNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(this.name.getRequiredParameterNames());
        result.addAll(this.value.getRequiredParameterNames());
        return result;
    }

    public void setParameterStore(ParameterStore store) {
        this.name.setParameterStore(store);
        this.value.setParameterStore(store);
    }
}

