/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternBuilder;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternBuilder;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.Resource;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.util.Transpositions;

public abstract class ServletMapping
extends HttpCondition
implements Parameterized {
    private static final Logger log = Logger.getLogger(Resource.class);
    private final RegexParameterizedPatternBuilder resource;

    private ServletMapping(String resource) {
        this.resource = new RegexParameterizedPatternBuilder(resource);
    }

    public static ServletMapping includes(final String resource) {
        return new ServletMapping(resource){

            public String toString() {
                return "ServletMapping.includes(\"" + resource + "\")";
            }
        };
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        if (this.resource != null && this.resource.isParameterComplete(event, context)) {
            String path = this.resource.build(event, context, Transpositions.encodePath());
            try {
                for (ServletRegistration registration : this.getServletRegistration(event.getServletContext())) {
                    Collection mappings = registration.getMappings();
                    for (Object mapping : mappings) {
                        if (path.startsWith("/") && !((String)mapping).startsWith("/")) {
                            mapping = "/" + (String)mapping;
                        }
                        if (((String)mapping).contains("*")) {
                            mapping = ((String)mapping).replaceAll("\\*", ".*");
                        }
                        if (!path.matches((String)mapping)) continue;
                        return true;
                    }
                }
                return event.getServletContext().getResource(path) != null;
            }
            catch (MalformedURLException e) {
                log.debug("Invalid file format [{}]", path);
            }
        }
        return false;
    }

    private Collection<ServletRegistration> getServletRegistration(ServletContext context) {
        Map servletRegistrations = context.getServletRegistrations();
        return new ArrayList<ServletRegistration>(servletRegistrations.values());
    }

    public ParameterizedPatternBuilder getResourceExpression() {
        return this.resource;
    }

    @Override
    public Set<String> getRequiredParameterNames() {
        return this.resource.getRequiredParameterNames();
    }

    @Override
    public void setParameterStore(ParameterStore store) {
        this.resource.setParameterStore(store);
    }
}

