/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.impl;

import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ocpsoft.common.services.NonEnriching;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationLoader;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.RewriteState;
import org.ocpsoft.rewrite.event.InboundRewrite;
import org.ocpsoft.rewrite.event.OutboundRewrite;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.param.DefaultParameterValueStore;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.http.HttpRewriteProvider;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.impl.EvaluationContextImpl;
import org.ocpsoft.rewrite.spi.RuleCacheProvider;
import org.ocpsoft.rewrite.util.ParameterUtils;
import org.ocpsoft.rewrite.util.ServiceLogger;

public class DefaultHttpRewriteProvider
extends HttpRewriteProvider
implements NonEnriching {
    private static Logger log = Logger.getLogger(DefaultHttpRewriteProvider.class);
    private volatile ConfigurationLoader loader;
    private volatile List<RuleCacheProvider> ruleCacheProviders;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ServletContext context) {
        DefaultHttpRewriteProvider defaultHttpRewriteProvider;
        if (this.loader == null) {
            defaultHttpRewriteProvider = this;
            synchronized (defaultHttpRewriteProvider) {
                if (this.loader == null) {
                    this.loader = ConfigurationLoader.create(context);
                }
            }
        }
        if (this.ruleCacheProviders == null) {
            defaultHttpRewriteProvider = this;
            synchronized (defaultHttpRewriteProvider) {
                this.ruleCacheProviders = Iterators.asList(ServiceLoader.load(RuleCacheProvider.class));
                ServiceLogger.logLoadedServices(log, RuleCacheProvider.class, this.ruleCacheProviders);
            }
        }
        this.loader.loadConfiguration(context);
    }

    @Override
    public void rewriteHttp(HttpServletRewrite event) {
        if (event instanceof InboundRewrite) {
            this.rewriteInbound(event);
        } else if (event instanceof OutboundRewrite) {
            this.rewriteOutbound(event);
        } else {
            throw new RewriteException("Unknown Rewrite event type [" + event.getClass().getName() + "] - was neither an inbound nor outbound Rewrite.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteInbound(HttpServletRewrite event) {
        int i;
        ServletContext servletContext = event.getServletContext();
        if (this.loader == null) {
            ServletContext servletContext2 = servletContext;
            synchronized (servletContext2) {
                if (this.loader == null) {
                    this.loader = ConfigurationLoader.create(servletContext);
                }
            }
        }
        Configuration compiledConfiguration = this.loader.loadConfiguration(servletContext);
        List<Rule> rules = compiledConfiguration.getRules();
        EvaluationContextImpl context = new EvaluationContextImpl();
        Object cacheKey = null;
        block7: for (int i2 = 0; i2 < this.ruleCacheProviders.size(); ++i2) {
            RuleCacheProvider provider = this.ruleCacheProviders.get(i2);
            List<Rule> list = provider.get(cacheKey = provider.createKey(event, context));
            if (list == null || list.isEmpty()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Using cached ruleset for event [" + event + "] from provider [" + provider + "].");
            }
            for (int j = 0; j < list.size(); ++j) {
                Rule rule = list.get(j);
                try {
                    event.getEvaluatedRules().add(rule);
                    context.clear();
                    DefaultParameterValueStore values = new DefaultParameterValueStore();
                    context.put(ParameterValueStore.class, values);
                    context.setState(RewriteState.EVALUATING);
                    if (rule.evaluate(event, context)) {
                        if (!this.handleBindings(event, context, values)) continue;
                        context.setState(RewriteState.PERFORMING);
                        if (log.isDebugEnabled()) {
                            log.debug("Rule [" + rule + "] matched and will be performed.");
                        }
                        List<Operation> preOperations = context.getPreOperations();
                        for (int k = 0; k < preOperations.size(); ++k) {
                            preOperations.get(k).perform(event, context);
                        }
                        if (event.getFlow().is(BaseRewrite.ServletRewriteFlow.HANDLED)) {
                            return;
                        }
                        rule.perform(event, context);
                        if (event.getFlow().is(BaseRewrite.ServletRewriteFlow.HANDLED)) {
                            return;
                        }
                        List<Operation> postOperations = context.getPostOperations();
                        for (int k = 0; k < postOperations.size(); ++k) {
                            postOperations.get(k).perform(event, context);
                        }
                        if (!event.getFlow().is(BaseRewrite.ServletRewriteFlow.HANDLED)) continue;
                        return;
                    }
                    event.getEvaluatedRules().remove(rule);
                    continue block7;
                }
                catch (Exception e) {
                    throw new RewriteException("Error during [" + event + "] while executing rule [" + rule + "]", e);
                }
            }
        }
        ArrayList<Rule> cacheable = new ArrayList<Rule>();
        for (i = 0; i < rules.size(); ++i) {
            Rule rule = rules.get(i);
            try {
                event.getEvaluatedRules().add(rule);
                context.clear();
                DefaultParameterValueStore values = new DefaultParameterValueStore();
                context.put(ParameterValueStore.class, values);
                context.setState(RewriteState.EVALUATING);
                if (rule.evaluate(event, context)) {
                    if (!this.handleBindings(event, context, values)) continue;
                    context.setState(RewriteState.PERFORMING);
                    if (log.isDebugEnabled()) {
                        log.debug("Rule [" + rule + "] matched and will be performed.");
                    }
                    cacheable.add(rule);
                    List<Operation> preOperations = context.getPreOperations();
                    for (int k = 0; k < preOperations.size(); ++k) {
                        preOperations.get(k).perform(event, context);
                    }
                    if (event.getFlow().is(BaseRewrite.ServletRewriteFlow.HANDLED)) break;
                    rule.perform(event, context);
                    if (event.getFlow().is(BaseRewrite.ServletRewriteFlow.HANDLED)) break;
                    List<Operation> postOperations = context.getPostOperations();
                    for (int k = 0; k < postOperations.size(); ++k) {
                        postOperations.get(k).perform(event, context);
                    }
                    if (!event.getFlow().is(BaseRewrite.ServletRewriteFlow.HANDLED)) continue;
                    break;
                }
                event.getEvaluatedRules().remove(rule);
                continue;
            }
            catch (Exception e) {
                throw new RewriteException("Error during [" + event + "] while executing rule [" + rule + "]", e);
            }
        }
        if (!cacheable.isEmpty()) {
            for (i = 0; i < this.ruleCacheProviders.size(); ++i) {
                this.ruleCacheProviders.get(i).put(cacheKey, cacheable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteOutbound(HttpServletRewrite event) {
        int i;
        ServletContext servletContext = event.getServletContext();
        if (this.loader == null) {
            ServletContext servletContext2 = servletContext;
            synchronized (servletContext2) {
                if (this.loader == null) {
                    this.loader = ConfigurationLoader.create(servletContext);
                }
            }
        }
        Configuration compiledConfiguration = this.loader.loadConfiguration(servletContext);
        List<Rule> rules = compiledConfiguration.getRules();
        EvaluationContextImpl context = new EvaluationContextImpl();
        Object cacheKey = null;
        block7: for (int i2 = this.ruleCacheProviders.size() - 1; i2 >= 0; --i2) {
            RuleCacheProvider provider = this.ruleCacheProviders.get(i2);
            List<Rule> list = provider.get(cacheKey = provider.createKey(event, context));
            if (list == null || list.isEmpty()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Using cached ruleset for event [" + event + "] from provider [" + provider + "].");
            }
            for (int j = list.size() - 1; j >= 0; --j) {
                Rule rule = list.get(j);
                try {
                    event.getEvaluatedRules().add(rule);
                    context.clear();
                    DefaultParameterValueStore values = new DefaultParameterValueStore();
                    context.put(ParameterValueStore.class, values);
                    context.setState(RewriteState.EVALUATING);
                    if (rule.evaluate(event, context)) {
                        if (!this.handleBindings(event, context, values)) continue;
                        context.setState(RewriteState.PERFORMING);
                        if (log.isDebugEnabled()) {
                            log.debug("Rule [" + rule + "] matched and will be performed.");
                        }
                        List<Operation> preOperations = context.getPreOperations();
                        for (int k = 0; k < preOperations.size(); ++k) {
                            preOperations.get(k).perform(event, context);
                        }
                        if (event.getFlow().is(BaseRewrite.ServletRewriteFlow.HANDLED)) {
                            return;
                        }
                        rule.perform(event, context);
                        if (event.getFlow().is(BaseRewrite.ServletRewriteFlow.HANDLED)) {
                            return;
                        }
                        List<Operation> postOperations = context.getPostOperations();
                        for (int k = 0; k < postOperations.size(); ++k) {
                            postOperations.get(k).perform(event, context);
                        }
                        if (!event.getFlow().is(BaseRewrite.ServletRewriteFlow.HANDLED)) continue;
                        return;
                    }
                    event.getEvaluatedRules().remove(rule);
                    continue block7;
                }
                catch (Exception e) {
                    throw new RewriteException("Error during [" + event + "] while executing rule [" + rule + "]", e);
                }
            }
        }
        ArrayList<Rule> cacheable = new ArrayList<Rule>();
        for (i = rules.size() - 1; i >= 0; --i) {
            Rule rule = rules.get(i);
            try {
                event.getEvaluatedRules().add(rule);
                context.clear();
                DefaultParameterValueStore values = new DefaultParameterValueStore();
                context.put(ParameterValueStore.class, values);
                context.setState(RewriteState.EVALUATING);
                if (rule.evaluate(event, context)) {
                    if (!this.handleBindings(event, context, values)) continue;
                    context.setState(RewriteState.PERFORMING);
                    if (log.isDebugEnabled()) {
                        log.debug("Rule [" + rule + "] matched and will be performed.");
                    }
                    cacheable.add(rule);
                    List<Operation> preOperations = context.getPreOperations();
                    for (int k = 0; k < preOperations.size(); ++k) {
                        preOperations.get(k).perform(event, context);
                    }
                    if (event.getFlow().is(BaseRewrite.ServletRewriteFlow.HANDLED)) break;
                    rule.perform(event, context);
                    if (event.getFlow().is(BaseRewrite.ServletRewriteFlow.HANDLED)) break;
                    List<Operation> postOperations = context.getPostOperations();
                    for (int k = 0; k < postOperations.size(); ++k) {
                        postOperations.get(k).perform(event, context);
                    }
                    if (!event.getFlow().is(BaseRewrite.ServletRewriteFlow.HANDLED)) continue;
                    break;
                }
                event.getEvaluatedRules().remove(rule);
                continue;
            }
            catch (Exception e) {
                throw new RewriteException("Error during [" + event + "] while executing rule [" + rule + "]", e);
            }
        }
        if (!cacheable.isEmpty()) {
            for (i = this.ruleCacheProviders.size() - 1; i >= 0; --i) {
                this.ruleCacheProviders.get(i).put(cacheKey, cacheable);
            }
        }
    }

    private boolean handleBindings(HttpServletRewrite event, EvaluationContextImpl context, DefaultParameterValueStore values) {
        boolean result = true;
        ParameterStore store = (ParameterStore)context.get(ParameterStore.class);
        for (Map.Entry entry : store) {
            String value;
            Parameter parameter = (Parameter)entry.getValue();
            if (ParameterUtils.enqueueSubmission(event, context, parameter, value = values.retrieve(parameter))) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public void shutdown(ServletContext context) {
    }

    @Override
    public int priority() {
        return 0;
    }
}

