/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.presentation;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.attribute.script.ScriptEventNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationActionAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationEffectAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationDirectionAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationSpeedAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationStartScaleAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkHrefAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkShowAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkActuateAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationVerbAttribute;


/**
 * DOM implementation of OpenDocument element  {@odf.element presentation:event-listener}.
 *
 */
public class PresentationEventListenerElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.PRESENTATION, "event-listener" );

	/**
	 * The value set of {@odf.attribute xlink:show}.
	 */
	 public enum XlinkShowAttributeValue {
	 
	 EMBED( XlinkShowAttribute.Value.EMBED.toString() );
              
		private String mValue;
	 	
		XlinkShowAttributeValue( String value )
		{
			mValue = value;
		}
		
		@Override
		public String toString()
		{
			return mValue;
		}
		
		public static XlinkShowAttributeValue enumValueOf( String value )
	    {
	        for( XlinkShowAttributeValue aIter : values() )
	        {
	            if( value.equals( aIter.toString() ) )
	            {
	                return aIter;
	            }
	        }
	        return null;
	    }
	}
	/**
	 * The value set of {@odf.attribute xlink:actuate}.
	 */
	 public enum XlinkActuateAttributeValue {
	 
	 ONREQUEST( XlinkActuateAttribute.Value.ONREQUEST.toString() );
              
		private String mValue;
	 	
		XlinkActuateAttributeValue( String value )
		{
			mValue = value;
		}
		
		@Override
		public String toString()
		{
			return mValue;
		}
		
		public static XlinkActuateAttributeValue enumValueOf( String value )
	    {
	        for( XlinkActuateAttributeValue aIter : values() )
	        {
	            if( value.equals( aIter.toString() ) )
	            {
	                return aIter;
	            }
	        }
	        return null;
	    }
	}
	public static final String  DEFAULT_VALUE_XLINK_SHOW_ATTRIBUTE = XlinkShowAttribute.Value.EMBED.toString();
	public static final String  DEFAULT_VALUE_XLINK_ACTUATE_ATTRIBUTE = XlinkActuateAttribute.Value.ONREQUEST.toString();

	/**
	 * Create the instance of <code>PresentationEventListenerElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public PresentationEventListenerElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element presentation:event-listener}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}

	/**
	 * Initialization of the mandatory attributes of {@link  PresentationEventListenerElement}
	 *
     * @param scriptEventNameAttributeValue  The mandatory attribute {@odf.attribute  script:event-name}"
     * @param presentationActionAttributeValue  The mandatory attribute {@odf.attribute  presentation:action}"
     *
	 */
	public void init(String scriptEventNameAttributeValue, String presentationActionAttributeValue)
	{
		setScriptEventNameAttribute( scriptEventNameAttributeValue );
		setPresentationActionAttribute( presentationActionAttributeValue );
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ScriptEventNameAttribute</code> , See {@odf.attribute script:event-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getScriptEventNameAttribute()
	{
		ScriptEventNameAttribute attr = (ScriptEventNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.SCRIPT), "event-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>ScriptEventNameAttribute</code> , See {@odf.attribute script:event-name}
	 *
	 * @param scriptEventNameValue   The type is <code>String</code>
	 */
	public void setScriptEventNameAttribute( String scriptEventNameValue )
	{
		ScriptEventNameAttribute attr =  new ScriptEventNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( scriptEventNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationActionAttribute</code> , See {@odf.attribute presentation:action}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getPresentationActionAttribute()
	{
		PresentationActionAttribute attr = (PresentationActionAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "action" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationActionAttribute</code> , See {@odf.attribute presentation:action}
	 *
	 * @param presentationActionValue   The type is <code>String</code>
	 */
	public void setPresentationActionAttribute( String presentationActionValue )
	{
		PresentationActionAttribute attr =  new PresentationActionAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( presentationActionValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationEffectAttribute</code> , See {@odf.attribute presentation:effect}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getPresentationEffectAttribute()
	{
		PresentationEffectAttribute attr = (PresentationEffectAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "effect" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return PresentationEffectAttribute.DEFAULT_VALUE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationEffectAttribute</code> , See {@odf.attribute presentation:effect}
	 *
	 * @param presentationEffectValue   The type is <code>String</code>
	 */
	public void setPresentationEffectAttribute( String presentationEffectValue )
	{
		PresentationEffectAttribute attr =  new PresentationEffectAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( presentationEffectValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationDirectionAttribute</code> , See {@odf.attribute presentation:direction}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getPresentationDirectionAttribute()
	{
		PresentationDirectionAttribute attr = (PresentationDirectionAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "direction" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return PresentationDirectionAttribute.DEFAULT_VALUE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationDirectionAttribute</code> , See {@odf.attribute presentation:direction}
	 *
	 * @param presentationDirectionValue   The type is <code>String</code>
	 */
	public void setPresentationDirectionAttribute( String presentationDirectionValue )
	{
		PresentationDirectionAttribute attr =  new PresentationDirectionAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( presentationDirectionValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationSpeedAttribute</code> , See {@odf.attribute presentation:speed}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getPresentationSpeedAttribute()
	{
		PresentationSpeedAttribute attr = (PresentationSpeedAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "speed" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return PresentationSpeedAttribute.DEFAULT_VALUE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationSpeedAttribute</code> , See {@odf.attribute presentation:speed}
	 *
	 * @param presentationSpeedValue   The type is <code>String</code>
	 */
	public void setPresentationSpeedAttribute( String presentationSpeedValue )
	{
		PresentationSpeedAttribute attr =  new PresentationSpeedAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( presentationSpeedValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationStartScaleAttribute</code> , See {@odf.attribute presentation:start-scale}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getPresentationStartScaleAttribute()
	{
		PresentationStartScaleAttribute attr = (PresentationStartScaleAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "start-scale" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return PresentationStartScaleAttribute.DEFAULT_VALUE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationStartScaleAttribute</code> , See {@odf.attribute presentation:start-scale}
	 *
	 * @param presentationStartScaleValue   The type is <code>String</code>
	 */
	public void setPresentationStartScaleAttribute( String presentationStartScaleValue )
	{
		PresentationStartScaleAttribute attr =  new PresentationStartScaleAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( presentationStartScaleValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>XlinkTypeAttribute</code> , See {@odf.attribute xlink:type}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getXlinkTypeAttribute()
	{
		XlinkTypeAttribute attr = (XlinkTypeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.XLINK), "type" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return XlinkTypeAttribute.DEFAULT_VALUE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>XlinkTypeAttribute</code> , See {@odf.attribute xlink:type}
	 *
	 * @param xlinkTypeValue   The type is <code>String</code>
	 */
	public void setXlinkTypeAttribute( String xlinkTypeValue )
	{
		XlinkTypeAttribute attr =  new XlinkTypeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( xlinkTypeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>XlinkHrefAttribute</code> , See {@odf.attribute xlink:href}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getXlinkHrefAttribute()
	{
		XlinkHrefAttribute attr = (XlinkHrefAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.XLINK), "href" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>XlinkHrefAttribute</code> , See {@odf.attribute xlink:href}
	 *
	 * @param xlinkHrefValue   The type is <code>String</code>
	 */
	public void setXlinkHrefAttribute( String xlinkHrefValue )
	{
		XlinkHrefAttribute attr =  new XlinkHrefAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( xlinkHrefValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>XlinkShowAttribute</code> , See {@odf.attribute xlink:show}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getXlinkShowAttribute()
	{
		XlinkShowAttribute attr = (XlinkShowAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.XLINK), "show" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return DEFAULT_VALUE_XLINK_SHOW_ATTRIBUTE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>XlinkShowAttribute</code> , See {@odf.attribute xlink:show}
	 *
	 * @param xlinkShowValue   The type is <code>String</code>
	 */
	public void setXlinkShowAttribute( String xlinkShowValue )
	{
		XlinkShowAttribute attr =  new XlinkShowAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( xlinkShowValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>XlinkActuateAttribute</code> , See {@odf.attribute xlink:actuate}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getXlinkActuateAttribute()
	{
		XlinkActuateAttribute attr = (XlinkActuateAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.XLINK), "actuate" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return DEFAULT_VALUE_XLINK_ACTUATE_ATTRIBUTE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>XlinkActuateAttribute</code> , See {@odf.attribute xlink:actuate}
	 *
	 * @param xlinkActuateValue   The type is <code>String</code>
	 */
	public void setXlinkActuateAttribute( String xlinkActuateValue )
	{
		XlinkActuateAttribute attr =  new XlinkActuateAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( xlinkActuateValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationVerbAttribute</code> , See {@odf.attribute presentation:verb}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getPresentationVerbAttribute()
	{
		PresentationVerbAttribute attr = (PresentationVerbAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "verb" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationVerbAttribute</code> , See {@odf.attribute presentation:verb}
	 *
	 * @param presentationVerbValue   The type is <code>Integer</code>
	 */
	public void setPresentationVerbAttribute( Integer presentationVerbValue )
	{
		PresentationVerbAttribute attr =  new PresentationVerbAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( presentationVerbValue.intValue() );
	}

	/**
	 * Create child element {@odf.element presentation:sound}.
	 *
     * @param xlinkHrefAttributeValue  the <code>String</code> value of <code>XlinkHrefAttribute</code>, see {@odf.attribute  xlink:href} at specification
	 * @param xlinkTypeAttributeValue  the <code>String</code> value of <code>XlinkTypeAttribute</code>, see {@odf.attribute  xlink:type} at specification
	 * @return   return  the element {@odf.element presentation:sound}
	 * DifferentQName 
	 */
    
	public PresentationSoundElement newPresentationSoundElement(String xlinkHrefAttributeValue, String xlinkTypeAttributeValue)
	{
		PresentationSoundElement  presentationSound = ((OdfFileDom)this.ownerDocument).newOdfElement(PresentationSoundElement.class);
		presentationSound.setXlinkHrefAttribute( xlinkHrefAttributeValue );
		presentationSound.setXlinkTypeAttribute( xlinkTypeAttributeValue );
		this.appendChild( presentationSound);
		return  presentationSound;      
	}
    
}
