/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPhpCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhpSlimServerCodegen
extends AbstractPhpCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhpSlimServerCodegen.class);
    protected String groupId = "org.openapitools";
    protected String artifactId = "openapi-server";

    public PhpSlimServerCodegen() {
        this.importMapping.clear();
        this.variableNamingConvention = "camelCase";
        this.artifactVersion = "1.0.0";
        this.packagePath = "";
        this.setInvokerPackage("OpenAPIServer");
        this.apiPackage = this.invokerPackage + "\\" + this.apiDirName;
        this.modelPackage = this.invokerPackage + "\\" + this.modelDirName;
        this.outputFolder = "generated-code" + File.separator + "slim";
        this.modelTestTemplateFiles.put("model_test.mustache", ".php");
        this.modelDocTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.templateDir = "php-slim-server";
        this.embeddedTemplateDir = "php-slim-server";
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        for (CliOption co : this.cliOptions) {
            if (!co.getOpt().equals("variableNamingConvention")) continue;
            co.setDescription("naming convention of variable name, e.g. camelCase.");
            co.setDefault("camelCase");
            break;
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "php-slim";
    }

    @Override
    public String getHelp() {
        return "Generates a PHP Slim Framework server library.";
    }

    @Override
    public String apiFileFolder() {
        if (this.apiPackage.matches("^" + this.invokerPackage + "\\\\*(.+)")) {
            return this.outputFolder + File.separator + this.toPackagePath(this.apiPackage.replaceFirst("^" + this.invokerPackage + "\\\\*(.+)", "$1"), this.srcBasePath);
        }
        return this.outputFolder + File.separator + this.toPackagePath(this.apiPackage, this.srcBasePath);
    }

    @Override
    public String modelFileFolder() {
        if (this.modelPackage.matches("^" + this.invokerPackage + "\\\\*(.+)")) {
            return this.outputFolder + File.separator + this.toPackagePath(this.modelPackage.replaceFirst("^" + this.invokerPackage + "\\\\*(.+)", "$1"), this.srcBasePath);
        }
        return this.outputFolder + File.separator + this.toPackagePath(this.modelPackage, this.srcBasePath);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("README.mustache", this.getPackagePath(), "README.md"));
        this.supportingFiles.add(new SupportingFile("composer.mustache", this.getPackagePath(), "composer.json"));
        this.supportingFiles.add(new SupportingFile("index.mustache", this.getPackagePath(), "index.php"));
        this.supportingFiles.add(new SupportingFile(".htaccess", this.getPackagePath(), ".htaccess"));
        this.supportingFiles.add(new SupportingFile(".gitignore", this.getPackagePath(), ".gitignore"));
        this.supportingFiles.add(new SupportingFile("AbstractApiController.mustache", this.toSrcPath(this.invokerPackage, this.srcBasePath), "AbstractApiController.php"));
        this.supportingFiles.add(new SupportingFile("SlimRouter.mustache", this.toSrcPath(this.invokerPackage, this.srcBasePath), "SlimRouter.php"));
        this.supportingFiles.add(new SupportingFile("phpunit.xml.mustache", this.getPackagePath(), "phpunit.xml.dist"));
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            if (!op.hasProduces) continue;
            List<Map<String, String>> c = op.produces;
            for (Map<String, String> mediaType : c) {
                if (!"*/*".equals(mediaType.get("mediaType"))) continue;
                mediaType.put("mediaType", "*_/_*");
            }
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        Map apiInfo = (Map)objs.get("apiInfo");
        List apiList = (List)apiInfo.get("apis");
        for (HashMap api : apiList) {
            HashMap operations = (HashMap)api.get("operations");
            List operationList = (List)operations.get("operation");
            Collections.sort(operationList, new Comparator<CodegenOperation>(){

                @Override
                public int compare(CodegenOperation one, CodegenOperation another) {
                    if (one.getHasPathParams() && !another.getHasPathParams()) {
                        return 1;
                    }
                    if (!one.getHasPathParams() && another.getHasPathParams()) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        return objs;
    }
}

