/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractCSharpCodegen;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspNetCoreServerCodegen
extends AbstractCSharpCodegen {
    public static final String USE_SWASHBUCKLE = "useSwashbuckle";
    public static final String ASPNET_CORE_VERSION = "aspnetCoreVersion";
    public static final String CLASS_MODIFIER = "classModifier";
    public static final String OPERATION_MODIFIER = "operationModifier";
    public static final String OPERATION_IS_ASYNC = "operationIsAsync";
    public static final String OPERATION_RESULT_TASK = "operationResultTask";
    public static final String GENERATE_BODY = "generateBody";
    public static final String BUILD_TARGET = "buildTarget";
    public static final String MODEL_CLASS_MODIFIER = "modelClassModifier";
    public static final String PROJECT_SDK = "projectSdk";
    public static final String SDK_WEB = "Microsoft.NET.Sdk.Web";
    public static final String SDK_LIB = "Microsoft.NET.Sdk";
    public static final String COMPATIBILITY_VERSION = "compatibilityVersion";
    public static final String IS_LIBRARY = "isLibrary";
    private String packageGuid = "{" + UUID.randomUUID().toString().toUpperCase(Locale.ROOT) + "}";
    protected Logger LOGGER = LoggerFactory.getLogger(AspNetCoreServerCodegen.class);
    private boolean useSwashbuckle = true;
    protected int serverPort = 8080;
    protected String serverHost = "0.0.0.0";
    protected CliOption aspnetCoreVersion = new CliOption("aspnetCoreVersion", "ASP.NET Core version: 2.2 (default), 2.1, 2.0 (deprecated)");
    private CliOption classModifier = new CliOption("classModifier", "Class Modifier can be empty, abstract");
    private CliOption operationModifier = new CliOption("operationModifier", "Operation Modifier can be virtual, abstract or partial");
    private CliOption modelClassModifier = new CliOption("modelClassModifier", "Model Class Modifier can be nothing or partial");
    private boolean generateBody = true;
    private CliOption buildTarget = new CliOption("buildTarget", "Target to build an application or library");
    private String projectSdk = "Microsoft.NET.Sdk.Web";
    private String compatibilityVersion = "Version_2_1";
    private boolean operationIsAsync = false;
    private boolean operationResultTask = false;
    private boolean isLibrary = false;

    public AspNetCoreServerCodegen() {
        this.outputFolder = "generated-code" + File.separator + this.getName();
        this.modelTemplateFiles.put("model.mustache", ".cs");
        this.apiTemplateFiles.put("controller.mustache", ".cs");
        this.templateDir = "aspnetcore/2.1";
        this.embeddedTemplateDir = "aspnetcore/2.1";
        this.reservedWords.addAll(Arrays.asList("var", "async", "await", "dynamic", "yield"));
        this.cliOptions.clear();
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("long", "long");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("number", "decimal");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("date", "DateTime");
        this.typeMapping.put("UUID", "Guid");
        this.typeMapping.put("URI", "string");
        this.setSupportNullable(Boolean.TRUE);
        this.addOption("licenseUrl", "The URL of the license", this.licenseUrl);
        this.addOption("licenseName", "The name of the license", this.licenseName);
        this.addOption("packageCopyright", "Specifies an AssemblyCopyright for the .NET Framework global assembly attributes stored in the AssemblyInfo file.", this.packageCopyright);
        this.addOption("packageAuthors", "Specifies Authors property in the .NET Core project file.", this.packageAuthors);
        this.addOption("packageTitle", "Specifies an AssemblyTitle for the .NET Framework global assembly attributes stored in the AssemblyInfo file.", this.packageTitle);
        this.addOption("packageName", "C# package name (convention: Title.Case).", this.packageName);
        this.addOption("packageVersion", "C# package version.", this.packageVersion);
        this.addOption("packageGuid", "The GUID that will be associated with the C# project", null);
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addOption(COMPATIBILITY_VERSION, "ASP.Net Core CompatibilityVersion", this.compatibilityVersion);
        this.aspnetCoreVersion.addEnum("2.0", "ASP.NET COre 2.0");
        this.aspnetCoreVersion.addEnum("2.1", "ASP.NET Core 2.1");
        this.aspnetCoreVersion.addEnum("2.2", "ASP.NET Core 2.2");
        this.aspnetCoreVersion.setDefault("2.2");
        this.aspnetCoreVersion.setOptValue(this.aspnetCoreVersion.getDefault());
        this.addOption(this.aspnetCoreVersion.getOpt(), this.aspnetCoreVersion.getDescription(), this.aspnetCoreVersion.getOptValue());
        this.addSwitch("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.", this.sortParamsByRequiredFlag);
        this.addSwitch("useDateTimeOffset", "Use DateTimeOffset to model date-time properties", this.useDateTimeOffsetFlag);
        this.addSwitch("useCollection", "Deserialize array types to Collection<T> instead of List<T>.", this.useCollection);
        this.addSwitch("returnICollection", "Return ICollection<T> instead of the concrete type.", this.returnICollection);
        this.addSwitch(USE_SWASHBUCKLE, "Uses the Swashbuckle.AspNetCore NuGet package for documentation.", this.useSwashbuckle);
        this.addSwitch(IS_LIBRARY, "Is the build a library", this.isLibrary);
        this.classModifier.addEnum("", "Keep class default with no modifier");
        this.classModifier.addEnum("abstract", "Make class abstract");
        this.classModifier.setDefault("");
        this.classModifier.setOptValue(this.classModifier.getDefault());
        this.addOption(this.classModifier.getOpt(), this.classModifier.getDescription(), this.classModifier.getOptValue());
        this.operationModifier.addEnum("virtual", "Keep method virtual");
        this.operationModifier.addEnum("abstract", "Make method abstract");
        this.operationModifier.setDefault("virtual");
        this.operationModifier.setOptValue(this.operationModifier.getDefault());
        this.addOption(this.operationModifier.getOpt(), this.operationModifier.getDescription(), this.operationModifier.getOptValue());
        this.buildTarget.addEnum("program", "Generate code for a standalone server");
        this.buildTarget.addEnum("library", "Generate code for a server abstract class lbrary");
        this.buildTarget.setDefault("program");
        this.buildTarget.setOptValue(this.buildTarget.getDefault());
        this.addOption(this.buildTarget.getOpt(), this.buildTarget.getDescription(), this.buildTarget.getOptValue());
        this.addSwitch(GENERATE_BODY, "Generates method body.", this.generateBody);
        this.addSwitch(OPERATION_IS_ASYNC, "Set methods to async or sync (default).", this.operationIsAsync);
        this.addSwitch(OPERATION_RESULT_TASK, "Set methods result to Task<>.", this.operationResultTask);
        this.modelClassModifier.setType("String");
        this.modelClassModifier.addEnum("", "Keep model class default with no modifier");
        this.modelClassModifier.addEnum("partial", "Make model class partial");
        this.modelClassModifier.setDefault("partial");
        this.modelClassModifier.setOptValue(this.modelClassModifier.getDefault());
        this.addOption(this.modelClassModifier.getOpt(), this.modelClassModifier.getDescription(), this.modelClassModifier.getOptValue());
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "aspnetcore";
    }

    @Override
    public String getHelp() {
        return "Generates an ASP.NET Core Web API server.";
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        URL url = URLPathUtils.getServerURL(openAPI);
        this.additionalProperties.put("serverHost", url.getHost());
        this.additionalProperties.put("serverPort", URLPathUtils.getPort(url, 8080));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageGuid")) {
            this.setPackageGuid((String)this.additionalProperties.get("packageGuid"));
        }
        this.additionalProperties.put("packageGuid", this.packageGuid);
        this.setBuildTarget();
        this.setClassModifier();
        this.setOperationModifier();
        this.setModelClassModifier();
        this.setUseSwashbuckle();
        this.setOperationIsAsync();
        this.additionalProperties.put(PROJECT_SDK, this.projectSdk);
        this.additionalProperties.put("dockerTag", this.packageName.toLowerCase(Locale.ROOT));
        if (!this.additionalProperties.containsKey("apiPackage")) {
            this.apiPackage = this.packageName + ".Controllers";
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        if (!this.additionalProperties.containsKey("modelPackage")) {
            this.modelPackage = this.packageName + ".Models";
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        String packageFolder = this.sourceFolder + File.separator + this.packageName;
        this.setAspnetCoreVersion(packageFolder);
        this.supportingFiles.add(new SupportingFile("build.sh.mustache", "", "build.sh"));
        this.supportingFiles.add(new SupportingFile("build.bat.mustache", "", "build.bat"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("Solution.mustache", "", this.packageName + ".sln"));
        this.supportingFiles.add(new SupportingFile("gitignore", packageFolder, ".gitignore"));
        this.supportingFiles.add(new SupportingFile("validateModel.mustache", packageFolder + File.separator + "Attributes", "ValidateModelStateAttribute.cs"));
        this.supportingFiles.add(new SupportingFile("Project.csproj.mustache", packageFolder, this.packageName + ".csproj"));
        if (!this.isLibrary) {
            this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", packageFolder, "Dockerfile"));
            this.supportingFiles.add(new SupportingFile("appsettings.json", packageFolder, "appsettings.json"));
            this.supportingFiles.add(new SupportingFile("Startup.mustache", packageFolder, "Startup.cs"));
            this.supportingFiles.add(new SupportingFile("Program.mustache", packageFolder, "Program.cs"));
            this.supportingFiles.add(new SupportingFile("Properties" + File.separator + "launchSettings.json", packageFolder + File.separator + "Properties", "launchSettings.json"));
            this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "README.md", packageFolder + File.separator + "wwwroot", "README.md"));
            this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "index.html", packageFolder + File.separator + "wwwroot", "index.html"));
            this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "web.config", packageFolder + File.separator + "wwwroot", "web.config"));
            this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "openapi-original.mustache", packageFolder + File.separator + "wwwroot", "openapi-original.json"));
        } else {
            this.supportingFiles.add(new SupportingFile("Project.nuspec.mustache", packageFolder, this.packageName + ".nuspec"));
        }
        if (this.useSwashbuckle) {
            this.supportingFiles.add(new SupportingFile("Filters" + File.separator + "BasePathFilter.mustache", packageFolder + File.separator + "Filters", "BasePathFilter.cs"));
            this.supportingFiles.add(new SupportingFile("Filters" + File.separator + "GeneratePathParamsValidationFilter.mustache", packageFolder + File.separator + "Filters", "GeneratePathParamsValidationFilter.cs"));
        }
    }

    public void setPackageGuid(String packageGuid) {
        this.packageGuid = packageGuid;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + "Controllers";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + "Models";
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateJSONSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    protected void processOperation(CodegenOperation operation) {
        super.processOperation(operation);
        if (operation.path != null) {
            String original = operation.path;
            operation.path = operation.path.replace("?", "/");
            if (!original.equals(operation.path)) {
                this.LOGGER.warn("Normalized " + original + " to " + operation.path + ". Please verify generated source.");
            }
        }
        operation.httpMethod = "Http" + operation.httpMethod.substring(0, 1) + operation.httpMethod.substring(1).toLowerCase(Locale.ROOT);
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return super.processCompiler(compiler).emptyStringIsFalse(true);
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.escapeText(pattern);
    }

    @Override
    public String getNullableType(Schema p, String type) {
        boolean isNullableExpected;
        boolean bl = isNullableExpected = p.getNullable() == null || p.getNullable() != null && p.getNullable() != false;
        if (isNullableExpected && this.languageSpecificPrimitives.contains(type + "?")) {
            return type + "?";
        }
        if (this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return null;
    }

    private void setCliOption(CliOption cliOption) throws IllegalArgumentException {
        if (this.additionalProperties.containsKey(cliOption.getOpt())) {
            Object obj = this.additionalProperties.get(cliOption.getOpt());
            if (!"boolean".equals(cliOption.getType()) && obj instanceof Boolean) {
                obj = "";
                this.additionalProperties.put(cliOption.getOpt(), obj);
            }
            cliOption.setOptValue(obj.toString());
        } else {
            this.additionalProperties.put(cliOption.getOpt(), cliOption.getOptValue());
        }
        if (cliOption.getOptValue() == null) {
            cliOption.setOptValue(cliOption.getDefault());
            throw new IllegalArgumentException(cliOption.getOpt() + ": Invalid value '" + this.additionalProperties.get(cliOption.getOpt()).toString() + "'. " + cliOption.getDescription());
        }
    }

    private void setClassModifier() {
        this.setCliOption(this.classModifier);
        if ("abstract".equals(this.classModifier.getOptValue())) {
            this.operationModifier.setOptValue(this.classModifier.getOptValue());
            this.additionalProperties.put(OPERATION_MODIFIER, this.operationModifier.getOptValue());
            this.LOGGER.warn("classModifier is " + this.classModifier.getOptValue() + " so forcing operatonModifier to " + this.operationModifier.getOptValue());
        }
    }

    private void setOperationModifier() {
        this.setCliOption(this.operationModifier);
        if ("abstract".equals(this.operationModifier.getOptValue())) {
            this.generateBody = false;
            this.additionalProperties.put(GENERATE_BODY, this.generateBody);
            this.LOGGER.warn("operationModifier is " + this.operationModifier.getOptValue() + " so forcing generateBody to " + this.generateBody);
        } else if (this.additionalProperties.containsKey(GENERATE_BODY)) {
            this.generateBody = this.convertPropertyToBooleanAndWriteBack(GENERATE_BODY);
        } else {
            this.additionalProperties.put(GENERATE_BODY, this.generateBody);
        }
    }

    private void setModelClassModifier() {
        this.setCliOption(this.modelClassModifier);
        if (this.isLibrary) {
            this.modelClassModifier.setOptValue("");
            this.additionalProperties.put(MODEL_CLASS_MODIFIER, this.modelClassModifier.getOptValue());
            this.LOGGER.warn("buildTarget is " + this.buildTarget.getOptValue() + " so removing any modelClassModifier ");
        }
    }

    private void setBuildTarget() {
        this.setCliOption(this.buildTarget);
        if ("library".equals(this.buildTarget.getOptValue())) {
            this.isLibrary = true;
            this.projectSdk = SDK_LIB;
            this.additionalProperties.put(CLASS_MODIFIER, "abstract");
        } else {
            this.isLibrary = false;
            this.projectSdk = SDK_WEB;
        }
        this.additionalProperties.put(IS_LIBRARY, this.isLibrary);
    }

    private void setAspnetCoreVersion(String packageFolder) {
        this.setCliOption(this.aspnetCoreVersion);
        if ("2.0".equals(this.aspnetCoreVersion.getOptValue())) {
            this.templateDir = "aspnetcore/2.0";
            this.embeddedTemplateDir = "aspnetcore/2.0";
            this.supportingFiles.add(new SupportingFile("web.config", packageFolder, "web.config"));
            this.LOGGER.info("ASP.NET core version: 2.0");
            this.compatibilityVersion = null;
        } else {
            this.LOGGER.info("ASP.NET core version: " + this.aspnetCoreVersion.getOptValue());
            this.compatibilityVersion = "Version_" + this.aspnetCoreVersion.getOptValue().replace(".", "_");
        }
        this.additionalProperties.put(COMPATIBILITY_VERSION, this.compatibilityVersion);
    }

    private void setUseSwashbuckle() {
        if (this.isLibrary) {
            this.LOGGER.warn("buildTarget is " + this.buildTarget.getOptValue() + " so changing default isLibrary to false ");
            this.useSwashbuckle = false;
        } else {
            this.useSwashbuckle = true;
        }
        if (this.additionalProperties.containsKey(USE_SWASHBUCKLE)) {
            this.useSwashbuckle = this.convertPropertyToBooleanAndWriteBack(USE_SWASHBUCKLE);
        } else {
            this.additionalProperties.put(USE_SWASHBUCKLE, this.useSwashbuckle);
        }
    }

    private void setOperationIsAsync() {
        if (this.isLibrary) {
            this.operationIsAsync = false;
            this.additionalProperties.put(OPERATION_IS_ASYNC, this.operationIsAsync);
        } else if (this.additionalProperties.containsKey(OPERATION_IS_ASYNC)) {
            this.operationIsAsync = this.convertPropertyToBooleanAndWriteBack(OPERATION_IS_ASYNC);
        } else {
            this.additionalProperties.put(OPERATION_IS_ASYNC, this.operationIsAsync);
        }
    }
}

