/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractTypeScriptClientCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeScriptNodeClientCodegen
extends AbstractTypeScriptClientCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeScriptNodeClientCodegen.class);
    public static final String NPM_REPOSITORY = "npmRepository";
    protected String npmRepository = null;
    protected String apiSuffix = "Api";

    public TypeScriptNodeClientCodegen() {
        this.typeMapping.put("file", "Buffer");
        this.languageSpecificPrimitives.add("Buffer");
        this.importMapping.clear();
        this.outputFolder = "generated-code/typescript-node";
        this.templateDir = "typescript-node";
        this.embeddedTemplateDir = "typescript-node";
        this.modelTemplateFiles.put("model.mustache", ".ts");
        this.apiTemplateFiles.put("api-single.mustache", ".ts");
        this.modelPackage = "model";
        this.apiPackage = "api";
        this.cliOptions.add(new CliOption(NPM_REPOSITORY, "Use this property to set an url your private npmRepo in the package.json"));
    }

    @Override
    public String getName() {
        return "typescript-node";
    }

    @Override
    public String getHelp() {
        return "Generates a TypeScript NodeJS client library.";
    }

    @Override
    public boolean isDataTypeFile(String dataType) {
        return "Buffer".equals(dataType);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isFileSchema(p)) {
            return "Buffer";
        }
        if (ModelUtils.isBinarySchema(p)) {
            return "Buffer";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "Default" + this.apiSuffix;
        }
        return StringUtils.camelize(name) + this.apiSuffix;
    }

    @Override
    public String toApiFilename(String name) {
        if (name.length() == 0) {
            return "default" + this.apiSuffix;
        }
        return StringUtils.camelize(name, true) + this.apiSuffix;
    }

    @Override
    public String toApiImport(String name) {
        return this.apiPackage() + "/" + this.toApiFilename(name);
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.camelize(this.toModelName(name), true);
    }

    @Override
    public String toModelImport(String name) {
        return this.modelPackage() + "/" + this.toModelFilename(name);
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map<String, Object> result = super.postProcessAllModels(objs);
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                mo.put("tsImports", this.toTsImports(cm, cm.imports));
            }
        }
        return result;
    }

    private List<Map<String, String>> toTsImports(CodegenModel cm, Set<String> imports) {
        ArrayList<Map<String, String>> tsImports = new ArrayList<Map<String, String>>();
        for (String im : imports) {
            if (im.equals(cm.classname)) continue;
            HashMap<String, String> tsImport = new HashMap<String, String>();
            tsImport.put("classname", im);
            tsImport.put("filename", this.toModelFilename(im));
            tsImports.add(tsImport);
        }
        return tsImports;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> operations, List<Object> allModels) {
        Map objs = (Map)operations.get("operations");
        HashMap<String, CodegenSecurity> authMethodsMap = new HashMap<String, CodegenSecurity>();
        for (CodegenOperation op : (List)objs.get("operation")) {
            if (!op.hasAuthMethods) continue;
            for (CodegenSecurity sec : op.authMethods) {
                authMethodsMap.put(sec.name, sec);
            }
        }
        if (!authMethodsMap.isEmpty()) {
            operations.put("authMethods", authMethodsMap.values());
            operations.put("hasAuthMethods", true);
        }
        objs.put("apiFilename", this.getApiFilenameFromClassname(objs.get("classname").toString()));
        List imports = (List)operations.get("imports");
        for (Map im : imports) {
            im.put("filename", im.get("import"));
            im.put("classname", this.getModelnameFromModelFilename(im.get("filename").toString()));
        }
        return operations;
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("models.mustache", this.modelPackage().replace('.', File.separatorChar), "models.ts"));
        this.supportingFiles.add(new SupportingFile("api-all.mustache", this.apiPackage().replace('.', File.separatorChar), "apis.ts"));
        this.supportingFiles.add(new SupportingFile("api.mustache", this.getIndexDirectory(), "api.ts"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
        if (this.additionalProperties.containsKey("npmName")) {
            this.addNpmPackageGeneration();
        }
    }

    private void addNpmPackageGeneration() {
        if (this.additionalProperties.containsKey(NPM_REPOSITORY)) {
            this.setNpmRepository(this.additionalProperties.get(NPM_REPOSITORY).toString());
        }
        this.supportingFiles.add(new SupportingFile("package.mustache", this.getPackageRootDirectory(), "package.json"));
        this.supportingFiles.add(new SupportingFile("tsconfig.mustache", this.getPackageRootDirectory(), "tsconfig.json"));
    }

    private String getIndexDirectory() {
        String indexPackage = this.modelPackage.substring(0, Math.max(0, this.modelPackage.lastIndexOf(46)));
        return indexPackage.replace('.', File.separatorChar);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        if (this.isLanguagePrimitive(openAPIType) || this.isLanguageGenericType(openAPIType)) {
            return openAPIType;
        }
        this.applyLocalTypeMapping(openAPIType);
        return openAPIType;
    }

    private String applyLocalTypeMapping(String type) {
        if (this.typeMapping.containsKey(type)) {
            type = (String)this.typeMapping.get(type);
        }
        return type;
    }

    private boolean isLanguagePrimitive(String type) {
        return this.languageSpecificPrimitives.contains(type);
    }

    private boolean isLanguageGenericType(String type) {
        for (String genericType : this.languageGenericTypes) {
            if (!type.startsWith(genericType + "<")) continue;
            return true;
        }
        return false;
    }

    private String getPackageRootDirectory() {
        String indexPackage = this.modelPackage.substring(0, Math.max(0, this.modelPackage.lastIndexOf(46)));
        return indexPackage.replace('.', File.separatorChar);
    }

    private String getApiFilenameFromClassname(String classname) {
        String name = classname.substring(0, classname.length() - this.apiSuffix.length());
        return this.toApiFilename(name);
    }

    private String getModelnameFromModelFilename(String filename) {
        String name = filename.substring((this.modelPackage() + File.separator).length());
        return StringUtils.camelize(name);
    }
}

