/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.templating.mustache.PrefixWithHashLambda;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrystalClientCodegen
extends DefaultCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(CrystalClientCodegen.class);
    private static final String NUMERIC_ENUM_PREFIX = "N";
    protected static int emptyMethodNameCounter = 0;
    protected String shardName;
    protected String moduleName;
    protected String shardVersion = "1.0.0";
    protected String specFolder = "spec";
    protected String srcFolder = "src";
    protected String shardLicense = "unlicense";
    protected String shardHomepage = "https://openapitools.org";
    protected String shardSummary = "A Crystal SDK for the REST API";
    protected String shardDescription = "This shard maps to a REST API";
    protected String shardAuthor = "";
    protected String shardAuthorEmail = "";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    public static final String SHARD_NAME = "shardName";
    public static final String SHARD_VERSION = "shardVersion";
    public static final String SHARD_LICENSE = "shardLicense";
    public static final String SHARD_HOMEPAGE = "shardHomepage";
    public static final String SHARD_SUMMARY = "shardSummary";
    public static final String SHARD_DESCRIPTION = "shardDescription";
    public static final String SHARD_AUTHOR = "shardAuthor";
    public static final String SHARD_AUTHOR_EMAIL = "shardAuthorEmail";

    public CrystalClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.BearerToken, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling, GlobalFeature.ParameterizedServer, GlobalFeature.MultiServer}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath, ClientModificationFeature.UserAgent}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.supportsInheritance = true;
        this.importMapping.clear();
        this.templateDir = "crystal";
        this.embeddedTemplateDir = "crystal";
        this.outputFolder = "generated-code" + File.separator + "crystal";
        this.modelPackage = "models";
        this.apiPackage = "api";
        this.modelTemplateFiles.put("model.mustache", ".cr");
        this.apiTemplateFiles.put("api.mustache", ".cr");
        this.modelTestTemplateFiles.put("model_test.mustache", ".cr");
        this.apiTestTemplateFiles.put("api_test.mustache", ".cr");
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.reservedWords = new HashSet<String>(Arrays.asList("abstract", "do", "if", "nil?", "select", "union", "alias", "else", "in", "of", "self", "unless", "as", "elsif", "include", "out", "sizeof", "until", "as?", "end", "instance", "sizeof", "pointerof", "struct", "verbatim", "asm", "ensure", "is_a?", "private", "super", "when", "begin", "enum", "lib", "protected", "then", "while", "break", "extend", "macro", "require", "true", "with", "case", "false", "module", "rescue", "type", "yield", "class", "for", "next", "responds_to?", "typeof", "def", "fun", "nil", "return", "uninitialized"));
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("String");
        this.languageSpecificPrimitives.add("Boolean");
        this.languageSpecificPrimitives.add("Integer");
        this.languageSpecificPrimitives.add("Float");
        this.languageSpecificPrimitives.add("Date");
        this.languageSpecificPrimitives.add("Time");
        this.languageSpecificPrimitives.add("Array");
        this.languageSpecificPrimitives.add("Hash");
        this.languageSpecificPrimitives.add("File");
        this.languageSpecificPrimitives.add("Object");
        this.typeMapping.clear();
        this.typeMapping.put("string", "String");
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("char", "Char");
        this.typeMapping.put("int", "Int32");
        this.typeMapping.put("integer", "Int32");
        this.typeMapping.put("long", "Int64");
        this.typeMapping.put("short", "Int32");
        this.typeMapping.put("float", "Float32");
        this.typeMapping.put("double", "Float64");
        this.typeMapping.put("number", "Float64");
        this.typeMapping.put("date", "Time");
        this.typeMapping.put("DateTime", "Time");
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("map", "Hash");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("binary", "String");
        this.typeMapping.put("ByteArray", "String");
        this.typeMapping.put("UUID", "String");
        this.typeMapping.put("URI", "String");
        this.instantiationTypes.put("map", "Hash");
        this.instantiationTypes.put("array", "Array");
        this.instantiationTypes.put("set", "Set");
        this.cliOptions.removeIf(opt -> "modelPackage".equals(opt.getOpt()) || "apiPackage".equals(opt.getOpt()));
        this.cliOptions.add(new CliOption(SHARD_NAME, "shard name (e.g. twitter_client").defaultValue("openapi_client"));
        this.cliOptions.add(new CliOption(SHARD_VERSION, "shard version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption(SHARD_LICENSE, "shard license.").defaultValue("unlicense"));
        this.cliOptions.add(new CliOption(SHARD_HOMEPAGE, "shard homepage.").defaultValue("http://org.openapitools"));
        this.cliOptions.add(new CliOption(SHARD_DESCRIPTION, "shard description.").defaultValue("This shard maps to a REST API"));
        this.cliOptions.add(new CliOption(SHARD_AUTHOR, "shard author (only one is supported)."));
        this.cliOptions.add(new CliOption(SHARD_AUTHOR_EMAIL, "shard author email (only one is supported)."));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("CRYSTAL_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Hint: Environment variable 'CRYSTAL_POST_PROCESS_FILE' (optional) not defined. E.g. to format the source code, please try 'export CRYSTAL_POST_PROCESS_FILE=\"/usr/local/bin/crystal tool format\"' (Linux/Mac)");
        }
        if (this.additionalProperties.containsKey(SHARD_NAME)) {
            this.setShardName((String)this.additionalProperties.get(SHARD_NAME));
        }
        this.additionalProperties.put(SHARD_NAME, this.shardName);
        if (this.additionalProperties.containsKey(SHARD_VERSION)) {
            this.setShardVersion((String)this.additionalProperties.get(SHARD_VERSION));
        } else {
            this.additionalProperties.put(SHARD_VERSION, this.shardVersion);
        }
        if (this.additionalProperties.containsKey(SHARD_LICENSE)) {
            this.setShardLicense((String)this.additionalProperties.get(SHARD_LICENSE));
        }
        if (this.additionalProperties.containsKey(SHARD_HOMEPAGE)) {
            this.setShardHomepage((String)this.additionalProperties.get(SHARD_HOMEPAGE));
        }
        if (this.additionalProperties.containsKey(SHARD_SUMMARY)) {
            this.setShardSummary((String)this.additionalProperties.get(SHARD_SUMMARY));
        }
        if (this.additionalProperties.containsKey(SHARD_DESCRIPTION)) {
            this.setShardDescription((String)this.additionalProperties.get(SHARD_DESCRIPTION));
        }
        if (this.additionalProperties.containsKey(SHARD_AUTHOR)) {
            this.setShardAuthor((String)this.additionalProperties.get(SHARD_AUTHOR));
        }
        if (this.additionalProperties.containsKey(SHARD_AUTHOR_EMAIL)) {
            this.setShardAuthorEmail((String)this.additionalProperties.get(SHARD_AUTHOR_EMAIL));
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.setModelPackage("models");
        this.setApiPackage("api");
        this.supportingFiles.add(new SupportingFile("shard_name.mustache", this.srcFolder, this.shardName + ".cr"));
        String shardFolder = this.srcFolder + File.separator + this.shardName;
        this.supportingFiles.add(new SupportingFile("api_error.mustache", shardFolder, "api_error.cr"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", shardFolder, "configuration.cr"));
        this.supportingFiles.add(new SupportingFile("api_client.mustache", shardFolder, "api_client.cr"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("travis.mustache", "", ".travis.yml"));
        this.supportingFiles.add(new SupportingFile("shard.mustache", "", "shard.yml"));
        this.supportingFiles.add(new SupportingFile("spec_helper.mustache", this.specFolder, "spec_helper.cr").doNotOverwrite());
        this.additionalProperties.put("lambdaPrefixWithHash", new PrefixWithHashLambda());
    }

    @Override
    public String getHelp() {
        return "Generates a Crystal client library (beta).";
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "crystal";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.srcFolder + File.separator + this.shardName + File.separator + this.apiPackage.replace("/", File.separator);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.srcFolder + File.separator + this.shardName + File.separator + this.modelPackage.replace("/", File.separator);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.specFolder + File.separator + this.apiPackage.replace("/", File.separator);
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.specFolder + File.separator + this.modelPackage.replace("/", File.separator);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String getSchemaType(Schema schema) {
        String openAPIType = super.getSchemaType(schema);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        if (type == null) {
            return null;
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelName(String name) {
        String modelName = this.sanitizeName(name);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            modelName = this.modelNamePrefix + "_" + modelName;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            modelName = modelName + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(modelName)) {
            modelName = StringUtils.camelize("Model" + modelName);
            this.LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (modelName.matches("^\\d.*")) {
            this.LOGGER.warn(modelName + " (model name starts with number) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + modelName));
            modelName = "model_" + modelName;
        }
        return StringUtils.camelize(modelName);
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.underscore(this.toModelName(name));
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiFilename(String name) {
        String filename = name;
        if (this.apiNameSuffix != null && this.apiNameSuffix.length() > 0) {
            filename = filename + "_" + this.apiNameSuffix;
        }
        filename = filename.replaceAll("-", "_");
        return StringUtils.underscore(filename);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiFilename(name) + "_spec";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelFilename(name) + "_spec";
    }

    @Override
    public String toApiName(String name) {
        return super.toApiName(name);
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("Integer".equals(datatype) || "Float".equals(datatype)) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "EMPTY";
        }
        if ("Integer".equals(datatype) || "Float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return NUMERIC_ENUM_PREFIX + varName;
        }
        String enumName = this.sanitizeName(StringUtils.underscore(name).toUpperCase(Locale.ROOT));
        enumName = enumName.replaceFirst("^_", "");
        if ((enumName = enumName.replaceFirst("_$", "")).matches("\\d.*")) {
            return NUMERIC_ENUM_PREFIX + enumName;
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = StringUtils.underscore(this.toModelName(property.name)).toUpperCase(Locale.ROOT);
        enumName = enumName.replaceFirst("^_", "");
        if ((enumName = enumName.replaceFirst("_$", "")).matches("\\d.*")) {
            return NUMERIC_ENUM_PREFIX + enumName;
        }
        return enumName;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            operationId = StringUtils.underscore("empty_method_name_" + emptyMethodNameCounter++);
            this.LOGGER.warn("Empty method name (operationId) found. Renamed to " + operationId);
            return operationId;
        }
        if (this.isReservedWord(operationId)) {
            String newOperationId = StringUtils.underscore("call_" + operationId);
            this.LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            this.LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + StringUtils.underscore(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return StringUtils.underscore(this.sanitizeName(operationId));
    }

    @Override
    public String toApiImport(String name) {
        return this.shardName + "/" + this.apiPackage() + "/" + this.toApiFilename(name);
    }

    public void setShardName(String shardName) {
        this.shardName = shardName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setShardVersion(String shardVersion) {
        this.shardVersion = shardVersion;
    }

    public void setShardDescription(String shardDescription) {
        this.shardDescription = shardDescription;
    }

    public void setShardSummary(String shardSummary) {
        this.shardSummary = shardSummary;
    }

    public void setShardLicense(String shardLicense) {
        this.shardLicense = shardLicense;
    }

    public void setShardHomepage(String shardHomepage) {
        this.shardHomepage = shardHomepage;
    }

    public void setShardAuthor(String shardAuthor) {
        this.shardAuthor = shardAuthor;
    }

    public void setShardAuthorEmail(String shardAuthorEmail) {
        this.shardAuthorEmail = shardAuthorEmail;
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        Schema additionalProperties = this.getAdditionalProperties(schema);
        if (additionalProperties != null) {
            codegenModel.additionalPropertiesType = this.getSchemaType(additionalProperties);
        }
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)objs.get("operations");
        HashMap<String, CodegenModel> modelMaps = new HashMap<String, CodegenModel>();
        HashMap<String, Integer> processedModelMaps = new HashMap<String, Integer>();
        for (Object o : allModels) {
            HashMap h = (HashMap)o;
            CodegenModel m = (CodegenModel)h.get("model");
            modelMaps.put(m.classname, m);
        }
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            for (CodegenParameter p : op.allParams) {
                p.vendorExtensions.put("x-crystal-example", this.constructExampleCode(p, modelMaps, processedModelMaps));
            }
            processedModelMaps.clear();
            for (CodegenParameter p : op.requiredParams) {
                p.vendorExtensions.put("x-crystal-example", this.constructExampleCode(p, modelMaps, processedModelMaps));
            }
            processedModelMaps.clear();
            for (CodegenParameter p : op.optionalParams) {
                p.vendorExtensions.put("x-crystal-example", this.constructExampleCode(p, modelMaps, processedModelMaps));
            }
            processedModelMaps.clear();
            for (CodegenParameter p : op.bodyParams) {
                p.vendorExtensions.put("x-crystal-example", this.constructExampleCode(p, modelMaps, processedModelMaps));
            }
            processedModelMaps.clear();
            for (CodegenParameter p : op.pathParams) {
                p.vendorExtensions.put("x-crystal-example", this.constructExampleCode(p, modelMaps, processedModelMaps));
            }
            processedModelMaps.clear();
        }
        return objs;
    }

    private String constructExampleCode(CodegenParameter codegenParameter, HashMap<String, CodegenModel> modelMaps, HashMap<String, Integer> processedModelMap) {
        if (codegenParameter.isArray) {
            return "[" + this.constructExampleCode(codegenParameter.items, modelMaps, processedModelMap) + "]";
        }
        if (codegenParameter.isMap) {
            return "{ key: " + this.constructExampleCode(codegenParameter.items, modelMaps, processedModelMap) + "}";
        }
        if (codegenParameter.isPrimitiveType) {
            if (codegenParameter.isEnum) {
                List values = (List)codegenParameter.allowableValues.get("values");
                codegenParameter.example = String.valueOf(values.get(0));
            }
            if (codegenParameter.isString || "String".equalsIgnoreCase(codegenParameter.baseType)) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example) && !"null".equals(codegenParameter.example)) {
                    return "'" + codegenParameter.example + "'";
                }
                return "'" + codegenParameter.paramName + "_example'";
            }
            if (codegenParameter.isBoolean) {
                if (Boolean.parseBoolean(codegenParameter.example)) {
                    return "true";
                }
                return "false";
            }
            if (codegenParameter.isUri) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example) && !"null".equals(codegenParameter.example)) {
                    return "'" + codegenParameter.example + "'";
                }
                return "'https://example.com'";
            }
            if (codegenParameter.isDateTime) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example) && !"null".equals(codegenParameter.example)) {
                    return "Time.parse('" + codegenParameter.example + "')";
                }
                return "Time.now";
            }
            if (codegenParameter.isDate) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example) && !"null".equals(codegenParameter.example)) {
                    return "Date.parse('" + codegenParameter.example + "')";
                }
                return "Date.today";
            }
            if (codegenParameter.isFile) {
                return "File.new('/path/to/some/file')";
            }
            if (codegenParameter.isInteger) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example) && !"null".equals(codegenParameter.example)) {
                    return codegenParameter.example;
                }
                return "37";
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example) && !"null".equals(codegenParameter.example)) {
                return codegenParameter.example;
            }
            return "3.56";
        }
        if (modelMaps.containsKey(codegenParameter.dataType)) {
            return this.constructExampleCode(modelMaps.get(codegenParameter.dataType), modelMaps, processedModelMap);
        }
        return "TODO";
    }

    private String constructExampleCode(CodegenProperty codegenProperty, HashMap<String, CodegenModel> modelMaps, HashMap<String, Integer> processedModelMap) {
        if (codegenProperty.isArray) {
            return "[" + this.constructExampleCode(codegenProperty.items, modelMaps, processedModelMap) + "]";
        }
        if (codegenProperty.isMap) {
            return "{ key: " + this.constructExampleCode(codegenProperty.items, modelMaps, processedModelMap) + "}";
        }
        if (codegenProperty.isPrimitiveType) {
            if (codegenProperty.isEnum) {
                List values = (List)codegenProperty.allowableValues.get("values");
                codegenProperty.example = String.valueOf(values.get(0));
            }
            if (codegenProperty.isString || "String".equalsIgnoreCase(codegenProperty.baseType)) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example) && !"null".equals(codegenProperty.example)) {
                    return "'" + codegenProperty.example + "'";
                }
                return "'" + codegenProperty.name + "_example'";
            }
            if (codegenProperty.isBoolean) {
                if (Boolean.parseBoolean(codegenProperty.example)) {
                    return "true";
                }
                return "false";
            }
            if (codegenProperty.isUri) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example) && !"null".equals(codegenProperty.example)) {
                    return "'" + codegenProperty.example + "'";
                }
                return "'https://example.com'";
            }
            if (codegenProperty.isDateTime) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example) && !"null".equals(codegenProperty.example)) {
                    return "Time.parse('" + codegenProperty.example + "')";
                }
                return "Time.now";
            }
            if (codegenProperty.isDate) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example) && !"null".equals(codegenProperty.example)) {
                    return "Date.parse('" + codegenProperty.example + "')";
                }
                return "Date.today";
            }
            if (codegenProperty.isFile) {
                return "File.new('/path/to/some/file')";
            }
            if (codegenProperty.isInteger) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example) && !"null".equals(codegenProperty.example)) {
                    return codegenProperty.example;
                }
                return "37";
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example) && !"null".equals(codegenProperty.example)) {
                return codegenProperty.example;
            }
            return "3.56";
        }
        if (modelMaps.containsKey(codegenProperty.dataType)) {
            return this.constructExampleCode(modelMaps.get(codegenProperty.dataType), modelMaps, processedModelMap);
        }
        return "TODO";
    }

    /*
     * Enabled aggressive block sorting
     */
    private String constructExampleCode(CodegenModel codegenModel, HashMap<String, CodegenModel> modelMaps, HashMap<String, Integer> processedModelMap) {
        String model;
        block6: {
            model = codegenModel.name;
            if (processedModelMap.containsKey(model)) {
                int count = processedModelMap.get(model);
                if (count == 1) {
                    processedModelMap.put(model, 2);
                    break block6;
                } else {
                    if (count != 2) throw new RuntimeException("Invalid count when constructing example: " + count);
                    return "";
                }
            }
            if (codegenModel.isEnum) {
                List enumVars = (List)codegenModel.allowableValues.get("enumVars");
                return this.moduleName + "::" + codegenModel.classname + "::" + (String)((Map)enumVars.get(0)).get("name");
            }
            if (codegenModel.oneOf != null && !codegenModel.oneOf.isEmpty()) {
                String subModel = (String)codegenModel.oneOf.toArray()[0];
                return this.constructExampleCode(modelMaps.get(subModel), modelMaps, processedModelMap);
            }
            processedModelMap.put(model, 1);
        }
        ArrayList<String> propertyExamples = new ArrayList<String>();
        for (CodegenProperty codegenProperty : codegenModel.requiredVars) {
            propertyExamples.add(codegenProperty.name + ": " + this.constructExampleCode(codegenProperty, modelMaps, processedModelMap));
        }
        String example = this.moduleName + "::" + this.toModelName(model) + ".new";
        if (propertyExamples.isEmpty()) return example;
        return example + "({" + org.apache.commons.lang3.StringUtils.join(propertyExamples, (String)", ") + "})";
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String getTypeDeclaration(Schema schema) {
        if (ModelUtils.isArraySchema(schema)) {
            Schema inner = ((ArraySchema)schema).getItems();
            return this.getSchemaType(schema) + "(" + this.getTypeDeclaration(inner) + ")";
        }
        if (ModelUtils.isMapSchema(schema)) {
            Schema inner = this.getAdditionalProperties(schema);
            return this.getSchemaType(schema) + "(String, " + this.getTypeDeclaration(inner) + ")";
        }
        return super.getTypeDeclaration(schema);
    }

    @Override
    public String toInstantiationType(Schema schema) {
        if (ModelUtils.isMapSchema(schema)) {
            return (String)this.instantiationTypes.get("map");
        }
        if (ModelUtils.isArraySchema(schema)) {
            String parentType = ModelUtils.isSet(schema) ? "set" : "array";
            return (String)this.instantiationTypes.get(parentType);
        }
        return super.toInstantiationType(schema);
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isIntegerSchema(p = ModelUtils.getReferencedSchema(this.openAPI, p)) || ModelUtils.isNumberSchema(p) || ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
        } else if (ModelUtils.isStringSchema(p) && p.getDefault() != null) {
            if (p.getDefault() instanceof Date) {
                Date date = (Date)p.getDefault();
                LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                return "Date.parse(\"" + String.format(Locale.ROOT, localDate.toString(), "") + "\")";
            }
            if (p.getDefault() instanceof OffsetDateTime) {
                return "Time.parse(\"" + String.format(Locale.ROOT, ((OffsetDateTime)p.getDefault()).atZoneSameInstant(ZoneId.systemDefault()).toString(), "") + "\")";
            }
            return "'" + this.escapeText((String)p.getDefault()) + "'";
        }
        return null;
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "::" + value;
    }

    @Override
    public String toVarName(String name) {
        String varName = this.sanitizeName(name);
        if (name.matches("^[A-Z_]*$")) {
            varName = varName.toLowerCase(Locale.ROOT);
        }
        if (this.isReservedWord(varName = StringUtils.underscore(varName)) || varName.matches("^\\d.*")) {
            varName = this.escapeReservedWord(varName);
        }
        return varName;
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.addRegularExpressionDelimiter(pattern);
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("=end", "=_end").replace("=begin", "=_begin").replace("#{", "\\#{");
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String crystalPostProcessFile = System.getenv("CRYSTAL_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)crystalPostProcessFile)) {
            return;
        }
        if ("cr".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = crystalPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream(), StandardCharsets.UTF_8));
                    StringBuilder sb = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                    this.LOGGER.error("Error running the command ({}). Exit value: {}, Error output: {}", new Object[]{command, exitValue, sb.toString()});
                } else {
                    this.LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (Exception e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }
}

