/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.ignore.rules;

import java.util.List;
import java.util.regex.Pattern;
import org.openapitools.codegen.ignore.rules.IgnoreLineParser;
import org.openapitools.codegen.ignore.rules.Part;
import org.openapitools.codegen.ignore.rules.Rule;

public class RootedFileRule
extends Rule {
    private String definedFilename = null;
    private String definedExtension = null;

    RootedFileRule(List<Part> syntax, String definition) {
        super(syntax, definition);
        int separatorIndex = definition.lastIndexOf(".");
        this.definedFilename = this.getFilenamePart(definition, separatorIndex);
        this.definedExtension = this.getExtensionPart(definition, separatorIndex);
    }

    private String getFilenamePart(String input, int stopIndex) {
        return input.substring('/' == input.charAt(0) ? 1 : 0, stopIndex > 0 ? stopIndex : input.length());
    }

    private String getExtensionPart(String input, int stopIndex) {
        return input.substring(stopIndex > 0 ? stopIndex + 1 : input.length());
    }

    @Override
    public Boolean matches(String relativePath) {
        boolean isSingleFile;
        boolean bl = isSingleFile = relativePath.lastIndexOf("/") <= 0;
        if (isSingleFile) {
            boolean extensionMatches;
            int separatorIndex = relativePath.lastIndexOf(".");
            String filename = this.getFilenamePart(relativePath, separatorIndex);
            String extension = this.getExtensionPart(relativePath, separatorIndex);
            boolean bl2 = extensionMatches = this.definedExtension.equals(extension) || this.definedExtension.equals(IgnoreLineParser.Token.MATCH_ANY.getPattern());
            if (extensionMatches && this.definedFilename.contains(IgnoreLineParser.Token.MATCH_ANY.getPattern())) {
                Pattern regex = Pattern.compile(this.definedFilename.replaceAll(Pattern.quote("."), "\\\\Q.\\\\E").replaceAll(Pattern.quote("*"), ".*?"));
                return regex.matcher(filename).matches();
            }
            return extensionMatches && this.definedFilename.equals(filename);
        }
        return false;
    }
}

