/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.text.WordUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XojoClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    public static final String CODEGEN_MODULE_NAME = "xojo-client";
    public static final String LIBRARY_HTTPSOCKET = "httpsocket";
    public static final String SERIALIZATION_LIBRARY_DESC = "What serialization library to use: 'xoson' (default).";
    public static final String PROJECT_NAME_DESC = "Project name in Xojo";
    protected String projectName = "OpenAPIClient";
    protected boolean nonPublicApi = false;
    protected boolean supportsAsync = true;
    protected SERIALIZATION_LIBRARY_TYPE serializationLibrary = SERIALIZATION_LIBRARY_TYPE.xoson;
    protected int projectObjectNumber = 100042;
    private final Logger LOGGER = LoggerFactory.getLogger(XojoClientCodegen.class);

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setNonPublicApi(boolean nonPublicApi) {
        this.nonPublicApi = nonPublicApi;
    }

    public void setSupportsAsync(Boolean supportsAsync) {
        this.supportsAsync = supportsAsync;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.projectName + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.projectName + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    public XojoClientCodegen() {
        this.useOneOfInterfaces = true;
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.STABLE).build();
        this.outputFolder = "generated-code" + File.separator + CODEGEN_MODULE_NAME;
        this.modelTemplateFiles.put("model.mustache", ".xojo_code");
        this.modelTemplateFiles.put("modelOptionalEnum.mustache", "Optional.xojo_code");
        this.apiTemplateFiles.put("api.mustache", ".xojo_code");
        this.templateDir = CODEGEN_MODULE_NAME;
        this.embeddedTemplateDir = CODEGEN_MODULE_NAME;
        this.apiPackage = "APIs";
        this.modelPackage = "Models";
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("App.mustache", "", "App.xojo_code"));
        this.supportingFiles.add(new SupportingFile("BuildAutomation.mustache", "", "Build Automation.xojo_code"));
        this.supportingFiles.add(new SupportingFile("api_mock.mustache", "", "Mock.xojo_code"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Integer", "Int8", "Int16", "Int32", "Int64", "UInteger", "UInt8", "UInt16", "UInt32", "UInt64", "Single", "Double", "Boolean", "String", "Color", "Currency"));
        this.setReservedWordsLowerCase(Arrays.asList("Models", "APIs", "#Bad", "#Else", "#Elseif", "#Endif", "#If", "#Pragma", "#Tag", "AddHandler", "AddressOf", "Aggregates", "And", "Array", "As", "Assigns", "Async", "Attributes", "Await", "Break", "ByRef", "ByVal", "Call", "Case", "Catch", "Class", "Const", "Continue", "CType", "Declare", "Delegate", "Dim", "Do", "DownTo", "Each", "Else", "ElseIf", "End", "Enum", "Event", "Exception", "Exit", "Extends", "False", "Finally", "For", "Function", "Global", "GoTo", "Handles", "If", "Implements", "In", "Inherits", "Interface", "Is", "IsA", "Lib", "Loop", "Me", "Mod", "Module", "Namespace", "New", "Next", "Nil", "Not", "Of", "Optional", "Or", "ParamArray", "Private", "Property", "Protected", "Public", "Raise", "RaiseEvent", "Redim", "Rem", "RemoveHandler", "Return", "Select", "Self", "Shared", "Soft", "Static", "Step", "Structure", "Sub", "Super", "Then", "To", "True", "Try", "Until", "Using", "Var", "WeakAddressOf", "Wend", "While", "With", "Xor", "Void", "COLUMN", "FILE", "FUNCTION", "LINE"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("set", "Array");
        this.typeMapping.put("Date", "Date");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("char", "Byte");
        this.typeMapping.put("short", "Int16");
        this.typeMapping.put("int", "Integer");
        this.typeMapping.put("long", "Int64");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("Integer", "Integer");
        this.typeMapping.put("float", "Single");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("file", "FolderItem");
        this.typeMapping.put("binary", "FolderItem");
        this.typeMapping.put("ByteArray", "MemoryBlock");
        this.typeMapping.put("UUID", "String");
        this.typeMapping.put("URI", "String");
        this.typeMapping.put("decimal", "Currency");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("AnyType", "Variant");
        this.typeMapping.put("null", "nil");
        this.supportedLibraries.put(LIBRARY_HTTPSOCKET, "[DEFAULT] HTTP client: HTTPSocket");
        CliOption libraryOption = new CliOption("library", "library template (sub-template)");
        libraryOption.setEnum(this.supportedLibraries);
        libraryOption.setDefault(LIBRARY_HTTPSOCKET);
        this.cliOptions.add(libraryOption);
        this.setLibrary(LIBRARY_HTTPSOCKET);
        CliOption serializationLibraryOpt = new CliOption("serializationLibrary", SERIALIZATION_LIBRARY_DESC);
        this.cliOptions.add(serializationLibraryOpt.defaultValue(this.serializationLibrary.name()));
        this.cliOptions.add(new CliOption("apiNamePrefix", "Prefix that will be appended to all API classes. Default: empty string."));
        this.cliOptions.add(new CliOption("projectName", PROJECT_NAME_DESC));
        this.cliOptions.add(new CliOption("nonPublicApi", "Generates code with reduced access modifiers; allows embedding elsewhere without exposing non-public API calls to consumers."));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption("supportsAsync", "Generate code that supports async operations."));
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
    }

    private static CodegenModel reconcileProperties(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        List<CodegenProperty> parentModelCodegenProperties = parentCodegenModel.vars;
        List<CodegenProperty> codegenProperties = codegenModel.vars;
        codegenModel.allVars = new ArrayList<CodegenProperty>(codegenProperties);
        codegenModel.parentVars = parentCodegenModel.allVars;
        boolean removedChildProperty = false;
        for (CodegenProperty parentModelCodegenProperty : parentModelCodegenProperties) {
            Iterator<CodegenProperty> iterator = codegenProperties.iterator();
            while (iterator.hasNext()) {
                CodegenProperty codegenProperty = iterator.next();
                if (!codegenProperty.baseName.equals(parentModelCodegenProperty.baseName)) continue;
                iterator.remove();
                removedChildProperty = true;
            }
        }
        if (removedChildProperty) {
            codegenModel.vars = codegenProperties;
        }
        return codegenModel;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return super.getTypeDeclaration(inner);
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type) || this.defaultIncludes.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String escapeReservedWord(String name) {
        this.LOGGER.warn("Escaping word '" + name + "' to 'Escaped" + name + "'. This will likely cause issues at runtime!");
        return "Escaped" + name;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return CODEGEN_MODULE_NAME;
    }

    @Override
    public String getHelp() {
        return "Generates a Xojo client module.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.setSortParamsByRequiredFlag(true);
        this.setEnsureUniqueParams(true);
        this.setAllowUnicodeIdentifiers(false);
        if (this.additionalProperties.containsKey("nonPublicApi")) {
            this.setNonPublicApi(this.convertPropertyToBooleanAndWriteBack("nonPublicApi"));
        }
        this.additionalProperties.put("nonPublicApi", this.nonPublicApi);
        if (this.additionalProperties.containsKey("serializationLibrary")) {
            this.setSerializationLibrary((String)this.additionalProperties.get("serializationLibrary"));
            this.additionalProperties.put(this.serializationLibrary.name(), true);
        } else {
            this.additionalProperties.put(this.serializationLibrary.name(), true);
        }
        this.syncBooleanProperty(this.additionalProperties, "supportsAsync", this::setSupportsAsync, this.supportsAsync);
        this.syncStringProperty(this.additionalProperties, "projectName", this::setProjectName, this.projectName);
        this.syncStringProperty(this.additionalProperties, "library", this::setLibrary, this.library);
        if (this.supportsAsync) {
            this.apiTemplateFiles.put("CallbackHandler.mustache", "CallbackHandler.xojo_code");
        }
        this.supportingFiles.add(new SupportingFile("MainModule.mustache", "", this.projectName + ".xojo_code"));
        this.supportingFiles.add(new SupportingFile("APIsModule.mustache", this.projectName, "APIs.xojo_code"));
        this.supportingFiles.add(new SupportingFile("ModelModule.mustache", this.projectName, "Models.xojo_code"));
        this.supportingFiles.add(new SupportingFile("Project.mustache", "", this.projectName + ".xojo_project"));
        this.supportingFiles.add(new SupportingFile("Exception.mustache", this.projectName, this.projectName + "Exception.xojo_code"));
        this.supportingFiles.add(new SupportingFile("Resources.mustache", "", this.projectName + ".xojo_resources"));
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
        CodegenModel codegenModel = super.fromModel(name, model);
        codegenModel.vendorExtensions.put("x-xojo-project-id", String.format(Locale.ROOT, "%014XFF", this.projectObjectNumber));
        this.projectObjectNumber += 16;
        if (allDefinitions != null) {
            String parentSchema = codegenModel.parentSchema;
            while (parentSchema != null) {
                Schema parentModel = allDefinitions.get(parentSchema);
                CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel);
                codegenModel = XojoClientCodegen.reconcileProperties(codegenModel, parentCodegenModel);
                parentSchema = parentCodegenModel.parentSchema;
            }
        }
        return codegenModel;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "\"\"");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*").replace("\\", "");
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        ModelsMap postProcessedModelsEnum = this.postProcessModelsEnum(objs);
        return postProcessedModelsEnum;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        HashMap<String, String> vendorExtensions = (HashMap<String, String>)(objs = super.postProcessOperationsWithModels(objs, allModels)).get("vendorExtensions");
        if (null == vendorExtensions) {
            vendorExtensions = new HashMap<String, String>();
            objs.put("vendorExtensions", vendorExtensions);
        }
        vendorExtensions.put("x-xojo-project-id", String.format(Locale.ROOT, "%014XFF", this.projectObjectNumber));
        this.projectObjectNumber += 16;
        return objs;
    }

    @Override
    public void postProcess() {
        System.out.println("################################################################################");
        System.out.println("# Thanks for using OpenAPI Generator.                                          #");
        System.out.println("# Please consider donation to help us maintain this project \ud83d\ude4f                 #");
        System.out.println("# https://opencollective.com/openapi_generator/donate                          #");
        System.out.println("#                                                                              #");
        System.out.println("# xojo-client contributed by Christopher Kobusch (https://github.com/Topheee). #");
        System.out.println("################################################################################");
    }

    @Override
    public List<CodegenSecurity> fromSecurity(Map<String, SecurityScheme> securitySchemeMap) {
        List<CodegenSecurity> securities = super.fromSecurity(securitySchemeMap);
        for (CodegenSecurity sec : securities) {
            if (!sec.isApiKey.booleanValue()) continue;
            sec.name = this.toVarName(sec.name);
        }
        return securities;
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.XOJO;
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(operationId = StringUtils.camelize(this.sanitizeName(operationId))))) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            String newOperationId = StringUtils.camelize("Call_" + operationId);
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            this.LOGGER.warn("{} (starting with a number) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)StringUtils.camelize(this.sanitizeName("call_" + operationId), CamelizeOption.LOWERCASE_FIRST_LETTER));
            operationId = StringUtils.camelize(this.sanitizeName("Call_" + operationId));
        }
        return operationId;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        return "\"" + value + "\"";
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "empty";
        }
        if (this.enumUnknownDefaultCase && name.equals(this.enumUnknownDefaultCaseName)) {
            return StringUtils.camelize(name);
        }
        String nameLowercase = org.apache.commons.lang3.StringUtils.lowerCase((String)name);
        if (this.isReservedWord(nameLowercase)) {
            return this.escapeReservedWord(nameLowercase);
        }
        if (name.matches("[+-]?\\d.*")) {
            this.LOGGER.warn("Escaping enum var name '" + name + "' to 'Escaped" + this.replaceSpecialCharacters(StringUtils.camelize(name)) + "'. This will likely cause issues at runtime!");
            return "Escaped" + this.replaceSpecialCharacters(StringUtils.camelize(name));
        }
        if (this.getSymbolName(name) != null) {
            return StringUtils.camelize(WordUtils.capitalizeFully((String)this.getSymbolName(name).toUpperCase(Locale.ROOT)));
        }
        boolean camelized = false;
        if (name.matches("[A-Z][a-z0-9]+[a-zA-Z0-9]*")) {
            name = StringUtils.camelize(name);
            camelized = true;
        }
        if ("Int".equals(datatype) || "Int32".equals(datatype) || "Int64".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype)) {
            String varName = "number" + StringUtils.camelize(name);
            return this.replaceSpecialCharacters(varName);
        }
        if (camelized) {
            return this.replaceSpecialCharacters(name);
        }
        char[] separators = new char[]{'-', '_', ' ', ':', '(', ')'};
        return StringUtils.camelize(this.replaceSpecialCharacters(WordUtils.capitalizeFully((String)org.apache.commons.lang3.StringUtils.lowerCase((String)name), (char[])separators).replaceAll("[-_ :\\(\\)]", "")));
    }

    private String replaceSpecialCharacters(String name) {
        for (Map.Entry specialCharacters : this.specialCharReplacements.entrySet()) {
            String specialChar = (String)specialCharacters.getKey();
            String replacement = (String)specialCharacters.getValue();
            if (specialChar.equals("_") || !name.contains(specialChar)) continue;
            name = this.replaceCharacters(name, specialChar, replacement);
        }
        name = name.replaceAll("\\W+", "_");
        return name;
    }

    private String replaceCharacters(String word, String oldValue, String newValue) {
        if (!word.contains(oldValue)) {
            return word;
        }
        if (word.equals(oldValue)) {
            return newValue;
        }
        int i = word.indexOf(oldValue);
        String start = word.substring(0, i);
        String end = this.recurseOnEndOfWord(word, oldValue, newValue, i);
        return start + newValue + end;
    }

    private String recurseOnEndOfWord(String word, String oldValue, String newValue, int lastReplacedValue) {
        String end = word.substring(lastReplacedValue + 1);
        if (!end.isEmpty()) {
            end = this.titleCase(end);
            end = this.replaceCharacters(end, oldValue, newValue);
        }
        return end;
    }

    private String titleCase(String input) {
        return input.substring(0, 1).toUpperCase(Locale.ROOT) + input.substring(1);
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, CamelizeOption.LOWERCASE_FIRST_LETTER))) {
            name = this.escapeReservedWord(name);
        }
        if (name.matches("^\\d.*")) {
            name = "_" + name;
        }
        return name;
    }

    @Override
    public String toModelFilename(String name) {
        name = super.toModelFilename(name);
        name = this.sanitizeName(name);
        if (this.isReservedWord(name = name.replaceAll("-", "_"))) {
            name = this.escapeReservedWord(name);
        }
        if (name.matches("^\\d.*")) {
            name = "A" + name;
        }
        if (!name.equals(this.toModelName(name))) {
            this.LOGGER.error("Model file name '" + name + "' differs from model name '" + this.toModelName(name) + "'. This will result in compilation errors.");
        }
        return name;
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix) && !this.isLanguageSpecificType(name).booleanValue()) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix) && !this.isLanguageSpecificType(name).booleanValue()) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name))) {
            String modelName = "Model" + name;
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", (Object)name, (Object)modelName);
            return modelName;
        }
        if (name.matches("^\\d.*")) {
            String modelName = "Model" + name;
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", (Object)name, (Object)modelName);
            return modelName;
        }
        return name;
    }

    @Override
    public String toExampleValue(Schema schema) {
        if (schema.getExample() != null) {
            return schema.getExample().toString();
        }
        return this.getPropertyDefaultValue(schema);
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (schema.getDefault() != null) {
            return schema.getDefault().toString();
        }
        return this.getPropertyDefaultValue(schema);
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter) {
        super.setParameterExampleValue(codegenParameter);
        if (Boolean.TRUE.equals(codegenParameter.isBinary)) {
            codegenParameter.example = "GetTemporaryFolderItem";
        } else if (Boolean.TRUE.equals(codegenParameter.isByteArray)) {
            codegenParameter.example = "New MemoryBlock(8)";
        } else if (Boolean.TRUE.equals(codegenParameter.isFile)) {
            codegenParameter.example = "GetTemporaryFolderItem";
        } else if (Boolean.TRUE.equals(codegenParameter.isDate)) {
            codegenParameter.example = "New Date";
        } else if (Boolean.TRUE.equals(codegenParameter.isDateTime)) {
            codegenParameter.example = "New Date";
        } else if (Boolean.TRUE.equals(codegenParameter.isString)) {
            codegenParameter.example = codegenParameter.paramName + "_example";
        } else if (Boolean.TRUE.equals(codegenParameter.isFreeFormObject)) {
            codegenParameter.example = "New Dictionary";
        }
    }

    public SERIALIZATION_LIBRARY_TYPE getSerializationLibrary() {
        return this.serializationLibrary;
    }

    public void setSerializationLibrary(String enumSerializationLibrary) {
        try {
            this.serializationLibrary = SERIALIZATION_LIBRARY_TYPE.valueOf(enumSerializationLibrary);
        }
        catch (IllegalArgumentException ex) {
            StringBuilder sb = new StringBuilder(enumSerializationLibrary + " is an invalid enum property naming option. Please choose from:");
            for (SERIALIZATION_LIBRARY_TYPE t : SERIALIZATION_LIBRARY_TYPE.values()) {
                sb.append("\n  ").append(t.name());
            }
            throw new RuntimeException(sb.toString());
        }
    }

    private String getPropertyDefaultValue(Schema schema) {
        if (ModelUtils.isBooleanSchema(schema)) {
            return "False";
        }
        if (ModelUtils.isDateSchema(schema)) {
            return "Nil";
        }
        if (ModelUtils.isDateTimeSchema(schema)) {
            return "Nil";
        }
        if (ModelUtils.isNumberSchema(schema)) {
            return "0";
        }
        if (ModelUtils.isIntegerSchema(schema)) {
            return "0";
        }
        if (ModelUtils.isStringSchema(schema)) {
            return "Sample";
        }
        if (ModelUtils.isObjectSchema(schema)) {
            return "Nil";
        }
        return "Nil";
    }

    private void syncBooleanProperty(Map<String, Object> additionalProperties, String key, Consumer<Boolean> setter, Boolean defaultValue) {
        if (additionalProperties.containsKey(key)) {
            setter.accept(this.convertPropertyToBooleanAndWriteBack(key));
        } else {
            additionalProperties.put(key, defaultValue);
            setter.accept(defaultValue);
        }
    }

    private void syncStringProperty(Map<String, Object> additionalProperties, String key, Consumer<String> setter, String defaultValue) {
        if (additionalProperties.containsKey(key)) {
            setter.accept((String)additionalProperties.get(key));
        } else {
            additionalProperties.put(key, defaultValue);
            setter.accept(defaultValue);
        }
    }

    private Boolean isLanguageSpecificType(String name) {
        return this.languageSpecificPrimitives.contains(name);
    }

    public static enum SERIALIZATION_LIBRARY_TYPE {
        xoson;

    }
}

