/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.exceptions.ProtoBufIndexComputationException;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufSchemaCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final String IMPORT = "import";
    private static final String IMPORTS = "imports";
    public static final String NUMBERED_FIELD_NUMBER_LIST = "numberedFieldNumberList";
    public static final String START_ENUMS_WITH_UNKNOWN = "startEnumsWithUnknown";
    private final Logger LOGGER = LoggerFactory.getLogger(ProtobufSchemaCodegen.class);
    protected String packageName = "openapitools";
    private boolean numberedFieldNumberList = false;
    private boolean startEnumsWithUnknown = false;

    @Override
    public CodegenType getTag() {
        return CodegenType.SCHEMA;
    }

    @Override
    public String getName() {
        return "protobuf-schema";
    }

    @Override
    public String getHelp() {
        return "Generates gRPC and protocol buffer schema files (beta)";
    }

    public ProtobufSchemaCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).includeWireFormatFeatures(new WireFormatFeature[]{WireFormatFeature.PROTOBUF}).wireFormatFeatures(EnumSet.of(WireFormatFeature.PROTOBUF)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)));
        this.outputFolder = "generated-code/protobuf-schema";
        this.modelTemplateFiles.put("model.mustache", ".proto");
        this.apiTemplateFiles.put("api.mustache", ".proto");
        this.templateDir = "protobuf-schema";
        this.embeddedTemplateDir = "protobuf-schema";
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.modelPackage = "models";
        this.apiPackage = "services";
        this.defaultIncludes = new HashSet<String>(Arrays.asList("map", "set", "array"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("map", "set", "array", "bool", "bytes", "string", "int32", "int64", "uint32", "uint64", "sint32", "sint64", "fixed32", "fixed64", "sfixed32", "sfixed64", "float", "double"));
        this.instantiationTypes.clear();
        this.instantiationTypes.put("array", "repeat");
        this.instantiationTypes.put("set", "repeat");
        this.typeMapping.clear();
        this.typeMapping.put("set", "array");
        this.typeMapping.put("array", "array");
        this.typeMapping.put("map", "map");
        this.typeMapping.put("integer", "int32");
        this.typeMapping.put("long", "int64");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("URI", "string");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("DateTime", "string");
        this.typeMapping.put("password", "string");
        this.typeMapping.put("file", "string");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("ByteArray", "bytes");
        this.typeMapping.put("object", "TODO_OBJECT_MAPPING");
        this.importMapping.clear();
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.cliOptions.clear();
        this.addSwitch(NUMBERED_FIELD_NUMBER_LIST, "Field numbers in order.", this.numberedFieldNumberList);
        this.addSwitch(START_ENUMS_WITH_UNKNOWN, "Introduces \"UNKNOWN\" as the first element of enumerations.", this.startEnumsWithUnknown);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.apiDocTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (!this.additionalProperties.containsKey("apiPackage")) {
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        if (!this.additionalProperties.containsKey("modelPackage")) {
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        if (this.additionalProperties.containsKey(NUMBERED_FIELD_NUMBER_LIST)) {
            this.numberedFieldNumberList = this.convertPropertyToBooleanAndWriteBack(NUMBERED_FIELD_NUMBER_LIST);
        }
        if (this.additionalProperties.containsKey(START_ENUMS_WITH_UNKNOWN)) {
            this.startEnumsWithUnknown = this.convertPropertyToBooleanAndWriteBack(START_ENUMS_WITH_UNKNOWN);
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord((String)operationId)) {
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", operationId, (Object)StringUtils.camelize(this.sanitizeName("call_" + (String)operationId)));
            operationId = "call_" + (String)operationId;
        }
        return StringUtils.camelize(this.sanitizeName((String)operationId));
    }

    public void addEnumValuesPrefix(Map<String, Object> allowableValues, String prefix) {
        if (allowableValues.containsKey("enumVars")) {
            List enumVars = (List)allowableValues.get("enumVars");
            for (Object value : enumVars) {
                String name = (String)value.get("name");
                value.put("name", prefix + "_" + name);
                value.put("value", "\"" + prefix + "_" + name + "\"");
            }
        }
        if (allowableValues.containsKey("values")) {
            List values = (List)allowableValues.get("values");
            for (Object value : values) {
                value = prefix + "_" + String.valueOf(value);
            }
        }
    }

    public void addUnknownToAllowableValues(Map<String, Object> allowableValues) {
        if (this.startEnumsWithUnknown) {
            if (allowableValues.containsKey("enumVars")) {
                List enumVars = (List)allowableValues.get("enumVars");
                HashMap<String, String> unknown = new HashMap<String, String>();
                unknown.put("name", "UNKNOWN");
                unknown.put("isString", "false");
                unknown.put("value", "\"UNKNOWN\"");
                enumVars.add(0, unknown);
            }
            if (allowableValues.containsKey("values")) {
                List values = (List)allowableValues.get("values");
                values.add(0, "UNKNOWN");
            }
        }
    }

    public void addEnumIndexes(List<Map<String, Object>> enumVars) {
        int enumIndex = 0;
        for (Map<String, Object> enumVar : enumVars) {
            enumVar.put("protobuf-enum-index", enumIndex);
            ++enumIndex;
        }
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        objs = this.postProcessModelsEnum(objs);
        for (ModelMap mo : objs.getModels()) {
            CodegenModel cm = mo.getModel();
            if (cm.isEnum) {
                Map<String, Object> allowableValues = cm.getAllowableValues();
                this.addUnknownToAllowableValues(allowableValues);
                this.addEnumValuesPrefix(allowableValues, cm.getClassname());
                if (allowableValues.containsKey("enumVars")) {
                    List enumVars = (List)allowableValues.get("enumVars");
                    this.addEnumIndexes(enumVars);
                }
            }
            int index = 1;
            for (CodegenProperty var : cm.vars) {
                if (Boolean.TRUE.equals(var.isArray)) {
                    var.vendorExtensions.put("x-protobuf-type", "repeated");
                } else if (Boolean.TRUE.equals(var.isNullable && var.isPrimitiveType)) {
                    var.vendorExtensions.put("x-protobuf-type", "optional");
                }
                if (!var.vendorExtensions.containsKey("x-protobuf-data-type")) {
                    if (var.isArray) {
                        var.vendorExtensions.put("x-protobuf-data-type", var.items.dataType);
                    } else {
                        var.vendorExtensions.put("x-protobuf-data-type", var.dataType);
                    }
                }
                if (var.isEnum) {
                    this.addUnknownToAllowableValues(var.allowableValues);
                    this.addEnumValuesPrefix(var.allowableValues, var.getEnumName());
                    if (var.allowableValues.containsKey("enumVars")) {
                        List enumVars = (List)var.allowableValues.get("enumVars");
                        this.addEnumIndexes(enumVars);
                    }
                }
                if (this.numberedFieldNumberList) {
                    var.vendorExtensions.putIfAbsent("x-protobuf-index", index);
                    ++index;
                    continue;
                }
                try {
                    var.vendorExtensions.putIfAbsent("x-protobuf-index", this.generateFieldNumberFromString(var.getName()));
                }
                catch (ProtoBufIndexComputationException e) {
                    this.LOGGER.error("Exception when assigning a index to a protobuf field", (Throwable)e);
                    var.vendorExtensions.putIfAbsent("x-protobuf-index", "Generated field number is in reserved range (19000, 19999)");
                }
            }
        }
        return objs;
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        super.postProcessAllModels(objs);
        Map<String, CodegenModel> allModels = this.getAllModels(objs);
        for (CodegenModel cm : allModels.values()) {
            if (cm.allOf.isEmpty() || cm.getParentModel() == null) continue;
            CodegenModel parentCM = cm.getParentModel();
            for (CodegenProperty var : cm.getVars()) {
                if (this.parentVarsContainsVar(parentCM.vars, var)) continue;
                parentCM.vars.add(var);
            }
            cm.getImports().stream().filter(importFromList -> !parentCM.getClassname().equalsIgnoreCase((String)importFromList) && !cm.getClassname().equalsIgnoreCase((String)importFromList)).forEach(importFromList -> this.addImport(objs, parentCM, (String)importFromList));
        }
        return objs;
    }

    public void addImport(Map<String, ModelsMap> objs, CodegenModel cm, String importValue) {
        String modelFileName = this.toModelFilename(importValue);
        boolean skipImport = this.isImportAlreadyPresentInModel(objs, cm, modelFileName);
        if (!skipImport) {
            this.addImport(cm, importValue);
            HashMap<String, String> importItem = new HashMap<String, String>();
            importItem.put(IMPORT, modelFileName);
            objs.get(cm.getName()).getImports().add(importItem);
        }
    }

    private boolean isImportAlreadyPresentInModel(Map<String, ModelsMap> objs, CodegenModel cm, String importValue) {
        boolean skipImport = false;
        List<Map<String, String>> cmImports = objs.get(cm.getName()).getImports();
        block0: for (Map<String, String> cmImportItem : cmImports) {
            for (Map.Entry<String, String> cmImportItemEntry : cmImportItem.entrySet()) {
                if (!importValue.equals(cmImportItemEntry.getValue())) continue;
                skipImport = true;
                continue block0;
            }
        }
        return skipImport;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                if (!Boolean.valueOf(p.getDefault().toString()).booleanValue()) {
                    return "false";
                }
                return "true";
            }
        } else if (!ModelUtils.isDateSchema(p) && !ModelUtils.isDateTimeSchema(p)) {
            if (ModelUtils.isNumberSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isIntegerSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isStringSchema(p)) {
                if (p.getDefault() != null) {
                    if (Pattern.compile("\r\n|\r|\n").matcher(String.valueOf(p.getDefault())).find()) {
                        return "'''" + p.getDefault() + "'''";
                    }
                    return "'" + p.getDefault() + "'";
                }
            } else if (ModelUtils.isArraySchema(p) && p.getDefault() != null) {
                return p.getDefault().toString();
            }
        }
        return null;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separatorChar + this.apiPackage;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separatorChar + this.modelPackage;
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return StringUtils.underscore(name) + "_service";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultService";
        }
        return StringUtils.camelize(name) + "Service";
    }

    @Override
    public String toApiVarName(String name) {
        if (name.length() == 0) {
            return "default_service";
        }
        return StringUtils.underscore(name) + "_service";
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.underscore(this.toModelName(name));
    }

    @Override
    public String toVarName(String name) {
        return name;
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName((String)name);
        if (this.isReservedWord((String)(name = ((String)name).replace("$", "")))) {
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", name, (Object)StringUtils.camelize("model_" + (String)name));
            name = "model_" + (String)name;
        }
        if (((String)name).matches("^\\d.*")) {
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", name, (Object)StringUtils.camelize("model_" + (String)name));
            name = "model_" + (String)name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + (String)name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = (String)name + "_" + this.modelNameSuffix;
        }
        return StringUtils.camelize((String)name);
    }

    @Override
    public String getSchemaType(Schema p) {
        String schemaType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = this.toModelName(schemaType);
        }
        return type;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations = objs.getOperations();
        List<CodegenOperation> operationList = operations.getOperation();
        for (CodegenOperation op : operationList) {
            int index = 1;
            for (CodegenParameter p : op.allParams) {
                if (Boolean.TRUE.equals(p.isArray)) {
                    p.vendorExtensions.put("x-protobuf-type", "repeated");
                } else if (Boolean.TRUE.equals(p.isNullable && p.isPrimitiveType)) {
                    p.vendorExtensions.put("x-protobuf-type", "optional");
                } else if (Boolean.TRUE.equals(p.isMap)) {
                    this.LOGGER.warn("Map parameter (name: {}, operation ID: {}) not yet supported", (Object)p.paramName, (Object)op.operationId);
                }
                if (!p.vendorExtensions.containsKey("x-protobuf-data-type")) {
                    if (Boolean.TRUE.equals(p.isArray)) {
                        p.vendorExtensions.put("x-protobuf-data-type", p.items.dataType);
                    } else {
                        p.vendorExtensions.put("x-protobuf-data-type", p.dataType);
                    }
                }
                p.vendorExtensions.putIfAbsent("x-protobuf-index", index);
                ++index;
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)op.returnType)) {
                op.vendorExtensions.put("x-grpc-response", "google.protobuf.Empty");
                continue;
            }
            if (Boolean.FALSE.equals(op.returnTypeIsPrimitive) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)op.returnContainer)) {
                op.vendorExtensions.put("x-grpc-response", op.returnType);
                continue;
            }
            if ("map".equals(op.returnContainer)) {
                this.LOGGER.warn("Map response (operation ID: {}) not yet supported", (Object)op.operationId);
                op.vendorExtensions.put("x-grpc-response-type", op.returnBaseType);
                continue;
            }
            if ("array".equals(op.returnContainer)) {
                op.vendorExtensions.put("x-grpc-response-type", "repeated " + op.returnBaseType);
                continue;
            }
            op.vendorExtensions.put("x-grpc-response-type", op.returnBaseType);
        }
        return objs;
    }

    @Override
    public String toModelImport(String name) {
        return StringUtils.underscore(name);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            Schema<?> inner = ModelUtils.getSchemaItems(p);
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "<string, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    private int generateFieldNumberFromString(String name) throws ProtoBufIndexComputationException {
        int fieldNumber = Math.abs(name.hashCode() % 0x1FFFFFFF);
        if (19000 <= fieldNumber && fieldNumber <= 19999) {
            this.LOGGER.error("Generated field number is in reserved range (19000, 19999) for %s, %d", (Object)name, (Object)fieldNumber);
            throw new ProtoBufIndexComputationException("Generated field number is in reserved range (19000, 19999).");
        }
        return fieldNumber;
    }

    private boolean parentVarsContainsVar(List<CodegenProperty> parentVars, CodegenProperty var) {
        boolean containsVar = false;
        for (CodegenProperty parentVar : parentVars) {
            if (!var.getDataType().equals(parentVar.getDataType()) || !var.getName().equals(parentVar.getName())) continue;
            containsVar = true;
            break;
        }
        return containsVar;
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.PROTOBUF;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }
}

