/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.ProfilerResult;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Result;
import sun.management.counter.Counter;

abstract class AbstractHotspotProfiler
implements InternalProfiler {
    private Map<String, Long> prevs;

    AbstractHotspotProfiler() {
    }

    protected abstract Collection<Counter> getCounters();

    @Override
    public boolean checkSupport(List<String> msgs) {
        try {
            Class.forName("sun.management.ManagementFactoryHelper");
            return true;
        }
        catch (ClassNotFoundException e) {
            msgs.add("Class not found: " + e.getMessage() + ", are you running HotSpot VM?");
            return false;
        }
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        HotspotInternalResult res = this.counters();
        ArrayList<ProfilerResult> results = new ArrayList<ProfilerResult>();
        for (Map.Entry<String, Long> e : res.getDiff().entrySet()) {
            results.add(new ProfilerResult("@unknown." + e.getKey(), e.getValue().longValue(), "unit?", AggregationPolicy.AVG));
        }
        return results;
    }

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        this.prevs = new HashMap<String, Long>();
        for (Counter counter : this.getCounters()) {
            this.prevs.put(counter.getName(), AbstractHotspotProfiler.convert(counter.getValue()));
        }
    }

    public static Long convert(Object o) {
        try {
            return Long.valueOf(String.valueOf(o));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    protected HotspotInternalResult counters() {
        TreeMap<String, Long> difference = new TreeMap<String, Long>();
        TreeMap<String, Long> current = new TreeMap<String, Long>();
        for (Counter counter : this.getCounters()) {
            Long prev = this.prevs.get(counter.getName());
            if (prev == null) continue;
            long diff = AbstractHotspotProfiler.convert(counter.getValue()) - prev;
            difference.put(counter.getName(), diff);
            current.put(counter.getName(), AbstractHotspotProfiler.convert(counter.getValue()));
        }
        return new HotspotInternalResult(current, difference);
    }

    public static <T> T getInstance(String name) {
        try {
            Object o = Class.forName("sun.management.ManagementFactoryHelper").getMethod("get" + name, new Class[0]).invoke(null, new Object[0]);
            return (T)o;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Should not be here");
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Should not be here");
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Should not be here");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Should not be here");
        }
    }

    static class HotspotInternalResult {
        private final Map<String, Long> current;
        private final Map<String, Long> diff;

        public HotspotInternalResult(Map<String, Long> current, Map<String, Long> diff) {
            this.current = current;
            this.diff = diff;
        }

        public Map<String, Long> getCurrent() {
            return this.current;
        }

        public Map<String, Long> getDiff() {
            return this.diff;
        }

        public String toString() {
            return "difference: " + this.diff.toString();
        }
    }
}

