/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.openjdk.jmh.util.InputStreamDrainer;

public class LinuxPerfUtil {
    public static final boolean IS_SUPPORTED;
    public static final boolean IS_DELAYED;
    public static final Collection<String> FAIL_MSGS;

    private static Collection<String> tryWith(String ... cmd) {
        ArrayList<String> messages = new ArrayList<String>();
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStreamDrainer errDrainer = new InputStreamDrainer(p.getErrorStream(), baos);
            InputStreamDrainer outDrainer = new InputStreamDrainer(p.getInputStream(), baos);
            errDrainer.start();
            outDrainer.start();
            int err = p.waitFor();
            errDrainer.join();
            outDrainer.join();
            if (err > 0) {
                messages.add(baos.toString());
            }
        }
        catch (IOException ex) {
            return Collections.singleton(ex.getMessage());
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
        return messages;
    }

    static {
        FAIL_MSGS = LinuxPerfUtil.tryWith("perf", "stat", "--log-fd", "2", "echo", "1");
        IS_SUPPORTED = FAIL_MSGS.isEmpty();
        Collection<String> delay = LinuxPerfUtil.tryWith("perf", "stat", "--log-fd", "2", "-D", "1", "echo", "1");
        IS_DELAYED = delay.isEmpty();
    }
}

