/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results.format;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.JSONResultFormat;
import org.openjdk.jmh.results.format.ResultFormat;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.results.format.TextResultFormat;
import org.openjdk.jmh.results.format.XSVResultFormat;

public class ResultFormatFactory {
    private ResultFormatFactory() {
    }

    public static ResultFormat getInstance(final ResultFormatType type, final String file) {
        return new ResultFormat(){

            @Override
            public void writeOut(Collection<RunResult> results) {
                try {
                    PrintWriter pw = new PrintWriter(file);
                    ResultFormat rf = ResultFormatFactory.getInstance(type, pw);
                    rf.writeOut(results);
                    pw.flush();
                    pw.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    public static ResultFormat getInstance(ResultFormatType type, PrintWriter writer) {
        switch (type) {
            case TEXT: {
                return new TextResultFormat(writer);
            }
            case CSV: {
                return new XSVResultFormat(writer, ",");
            }
            case SCSV: {
                return new XSVResultFormat(writer, ";");
            }
            case JSON: {
                return new JSONResultFormat(writer);
            }
        }
        throw new IllegalStateException("Unsupported result format: " + (Object)((Object)type));
    }
}

