/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openjdk.jmh.util.Multimap;

public class HashMultimap<K, V>
implements Multimap<K, V>,
Serializable {
    private static final long serialVersionUID = 2484428623123444998L;
    private final Map<K, Collection<V>> map = new HashMap<K, Collection<V>>();

    @Override
    public void put(K key, V value) {
        Collection<V> vs = this.map.get(key);
        if (vs == null) {
            vs = new ArrayList<V>();
            this.map.put(key, vs);
        }
        vs.add(value);
    }

    @Override
    public void putAll(K key, Collection<V> vvs) {
        Collection<V> vs = this.map.get(key);
        if (vs == null) {
            vs = new ArrayList<V>();
            this.map.put(key, vs);
        }
        vs.addAll(vvs);
    }

    @Override
    public Collection<V> get(K key) {
        Collection<V> vs = this.map.get(key);
        return vs == null ? Collections.emptyList() : Collections.unmodifiableCollection(vs);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Collection<K> keys() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>();
        for (K key : this.map.keySet()) {
            result.addAll(this.map.get(key));
        }
        return result;
    }

    @Override
    public void remove(K key) {
        this.map.remove(key);
    }

    @Override
    public void merge(Multimap<K, V> other) {
        for (K k : other.keys()) {
            this.putAll(k, other.get(k));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashMultimap that = (HashMultimap)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

