/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.SliderBehavior;
import javafx.animation.Transition;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.chart.NumberAxis;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import javafx.util.StringConverter;

public class SliderSkin
extends SkinBase<Slider> {
    private NumberAxis tickLine = null;
    private double trackToTickGap = 2.0;
    private boolean showTickMarks;
    private boolean tooltipConsumeAutoHidingEvents;
    private double thumbWidth;
    private double thumbHeight;
    private double trackStart;
    private double trackLength;
    private double thumbTop;
    private double thumbLeft;
    private double preDragThumbPos;
    private Point2D dragStart;
    private StackPane thumb;
    private StackPane track;
    private boolean trackClicked = false;
    private final SliderBehavior behavior;
    StringConverter<Number> stringConverterWrapper = new StringConverter<Number>(){
        Slider slider;
        {
            this.slider = (Slider)SliderSkin.this.getSkinnable();
        }

        public String toString(Number number) {
            return number != null ? this.slider.getLabelFormatter().toString((Object)number.doubleValue()) : "";
        }

        public Number fromString(String string) {
            return (Number)this.slider.getLabelFormatter().fromString(string);
        }
    };

    public SliderSkin(Slider slider) {
        super(slider);
        this.behavior = new SliderBehavior(slider);
        this.initialize();
        slider.requestLayout();
        this.registerChangeListener((ObservableValue<?>)slider.minProperty(), observableValue -> {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setLowerBound(slider.getMin());
            }
            ((Slider)this.getSkinnable()).requestLayout();
        });
        this.registerChangeListener((ObservableValue<?>)slider.maxProperty(), observableValue -> {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setUpperBound(slider.getMax());
            }
            ((Slider)this.getSkinnable()).requestLayout();
        });
        this.registerChangeListener((ObservableValue<?>)slider.valueProperty(), observableValue -> this.positionThumb(this.trackClicked));
        this.registerChangeListener((ObservableValue<?>)slider.orientationProperty(), observableValue -> {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setSide(slider.getOrientation() == Orientation.VERTICAL ? Side.RIGHT : (slider.getOrientation() == null ? Side.RIGHT : Side.BOTTOM));
            }
            ((Slider)this.getSkinnable()).requestLayout();
        });
        this.registerChangeListener((ObservableValue<?>)slider.showTickMarksProperty(), observableValue -> this.setShowTickMarks(slider.isShowTickMarks(), slider.isShowTickLabels()));
        this.registerChangeListener((ObservableValue<?>)slider.showTickLabelsProperty(), observableValue -> this.setShowTickMarks(slider.isShowTickMarks(), slider.isShowTickLabels()));
        this.registerChangeListener((ObservableValue<?>)slider.majorTickUnitProperty(), observableValue -> {
            if (this.tickLine != null) {
                this.tickLine.setTickUnit(slider.getMajorTickUnit());
                ((Slider)this.getSkinnable()).requestLayout();
            }
        });
        this.registerChangeListener((ObservableValue<?>)slider.minorTickCountProperty(), observableValue -> {
            if (this.tickLine != null) {
                this.tickLine.setMinorTickCount(Math.max(slider.getMinorTickCount(), 0) + 1);
                ((Slider)this.getSkinnable()).requestLayout();
            }
        });
        this.registerChangeListener((ObservableValue<?>)slider.labelFormatterProperty(), observableValue -> {
            if (this.tickLine != null) {
                if (slider.getLabelFormatter() == null) {
                    this.tickLine.setTickLabelFormatter(null);
                } else {
                    this.tickLine.setTickLabelFormatter(this.stringConverterWrapper);
                    this.tickLine.requestAxisLayout();
                }
            }
        });
        this.registerChangeListener((ObservableValue<?>)slider.snapToTicksProperty(), observableValue -> slider.adjustValue(slider.getValue()));
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        double d5;
        this.thumbWidth = this.snapSizeX(this.thumb.prefWidth(-1.0));
        this.thumbHeight = this.snapSizeY(this.thumb.prefHeight(-1.0));
        this.thumb.resize(this.thumbWidth, this.thumbHeight);
        double d6 = this.track.getBackground() == null ? 0.0 : (d5 = this.track.getBackground().getFills().size() > 0 ? ((BackgroundFill)this.track.getBackground().getFills().get(0)).getRadii().getTopLeftHorizontalRadius() : 0.0);
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            double d7 = this.showTickMarks ? this.tickLine.prefHeight(-1.0) : 0.0;
            double d8 = this.snapSizeY(this.track.prefHeight(-1.0));
            double d9 = Math.max(d8, this.thumbHeight);
            double d10 = d9 + (this.showTickMarks ? this.trackToTickGap + d7 : 0.0);
            double d11 = d2 + (d4 - d10) / 2.0;
            this.trackLength = this.snapSizeX(d3 - this.thumbWidth);
            this.trackStart = this.snapPositionX(d + this.thumbWidth / 2.0);
            double d12 = (int)(d11 + (d9 - d8) / 2.0);
            this.thumbTop = (int)(d11 + (d9 - this.thumbHeight) / 2.0);
            this.positionThumb(false);
            this.track.resizeRelocate((double)((int)(this.trackStart - d5)), d12, (double)((int)(this.trackLength + d5 + d5)), d8);
            if (this.showTickMarks) {
                this.tickLine.setLayoutX(this.trackStart);
                this.tickLine.setLayoutY(d12 + d8 + this.trackToTickGap);
                this.tickLine.resize(this.trackLength, d7);
                this.tickLine.requestAxisLayout();
            } else {
                if (this.tickLine != null) {
                    this.tickLine.resize(0.0, 0.0);
                    this.tickLine.requestAxisLayout();
                }
                this.tickLine = null;
            }
        } else {
            double d13 = this.showTickMarks ? this.tickLine.prefWidth(-1.0) : 0.0;
            double d14 = this.snapSizeX(this.track.prefWidth(-1.0));
            double d15 = Math.max(d14, this.thumbWidth);
            double d16 = d15 + (this.showTickMarks ? this.trackToTickGap + d13 : 0.0);
            double d17 = d + (d3 - d16) / 2.0;
            this.trackLength = this.snapSizeY(d4 - this.thumbHeight);
            this.trackStart = this.snapPositionY(d2 + this.thumbHeight / 2.0);
            double d18 = (int)(d17 + (d15 - d14) / 2.0);
            this.thumbLeft = (int)(d17 + (d15 - this.thumbWidth) / 2.0);
            this.positionThumb(false);
            this.track.resizeRelocate(d18, (double)((int)(this.trackStart - d5)), d14, (double)((int)(this.trackLength + d5 + d5)));
            if (this.showTickMarks) {
                this.tickLine.setLayoutX(d18 + d14 + this.trackToTickGap);
                this.tickLine.setLayoutY(this.trackStart);
                this.tickLine.resize(d13, this.trackLength);
                this.tickLine.requestAxisLayout();
            } else {
                if (this.tickLine != null) {
                    this.tickLine.resize(0.0, 0.0);
                    this.tickLine.requestAxisLayout();
                }
                this.tickLine = null;
            }
        }
    }

    @Override
    protected double computeMinWidth(double d, double d2, double d3, double d4, double d5) {
        Slider slider = (Slider)this.getSkinnable();
        if (slider.getOrientation() == Orientation.HORIZONTAL) {
            return d5 + this.minTrackLength() + this.thumb.minWidth(-1.0) + d3;
        }
        return d5 + this.thumb.prefWidth(-1.0) + d3;
    }

    @Override
    protected double computeMinHeight(double d, double d2, double d3, double d4, double d5) {
        Slider slider = (Slider)this.getSkinnable();
        if (slider.getOrientation() == Orientation.HORIZONTAL) {
            double d6 = this.showTickMarks ? this.tickLine.prefHeight(-1.0) + this.trackToTickGap : 0.0;
            return d2 + this.thumb.prefHeight(-1.0) + d6 + d4;
        }
        return d2 + this.minTrackLength() + this.thumb.prefHeight(-1.0) + d4;
    }

    @Override
    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        Slider slider = (Slider)this.getSkinnable();
        if (slider.getOrientation() == Orientation.HORIZONTAL) {
            if (this.showTickMarks) {
                return Math.max(140.0, this.tickLine.prefWidth(-1.0));
            }
            return 140.0;
        }
        double d6 = this.showTickMarks ? this.tickLine.prefWidth(-1.0) + this.trackToTickGap : 0.0;
        return d5 + Math.max(this.thumb.prefWidth(-1.0), this.track.prefWidth(-1.0)) + d6 + d3;
    }

    @Override
    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        Slider slider = (Slider)this.getSkinnable();
        if (slider.getOrientation() == Orientation.HORIZONTAL) {
            return d2 + Math.max(this.thumb.prefHeight(-1.0), this.track.prefHeight(-1.0)) + (this.showTickMarks ? this.trackToTickGap + this.tickLine.prefHeight(-1.0) : 0.0) + d4;
        }
        if (this.showTickMarks) {
            return Math.max(140.0, this.tickLine.prefHeight(-1.0));
        }
        return 140.0;
    }

    @Override
    protected double computeMaxWidth(double d, double d2, double d3, double d4, double d5) {
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            return Double.MAX_VALUE;
        }
        return ((Slider)this.getSkinnable()).prefWidth(-1.0);
    }

    @Override
    protected double computeMaxHeight(double d, double d2, double d3, double d4, double d5) {
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            return ((Slider)this.getSkinnable()).prefHeight(d);
        }
        return Double.MAX_VALUE;
    }

    private void initialize() {
        this.thumb = new StackPane(){

            public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
                switch (accessibleAttribute) {
                    case VALUE: {
                        return ((Slider)SliderSkin.this.getSkinnable()).getValue();
                    }
                }
                return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
            }
        };
        this.thumb.getStyleClass().setAll((Object[])new String[]{"thumb"});
        this.thumb.setAccessibleRole(AccessibleRole.THUMB);
        this.track = new StackPane();
        this.track.getStyleClass().setAll((Object[])new String[]{"track"});
        this.getChildren().clear();
        this.getChildren().addAll((Object[])new Node[]{this.track, this.thumb});
        this.setShowTickMarks(((Slider)this.getSkinnable()).isShowTickMarks(), ((Slider)this.getSkinnable()).isShowTickLabels());
        this.track.setOnMousePressed(mouseEvent -> {
            if (!this.thumb.isPressed()) {
                this.trackClicked = true;
                if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
                    this.behavior.trackPress((MouseEvent)mouseEvent, mouseEvent.getX() / this.trackLength);
                } else {
                    this.behavior.trackPress((MouseEvent)mouseEvent, mouseEvent.getY() / this.trackLength);
                }
                this.trackClicked = false;
            }
        });
        this.track.setOnMouseDragged(mouseEvent -> {
            if (!this.thumb.isPressed()) {
                if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
                    this.behavior.trackPress((MouseEvent)mouseEvent, mouseEvent.getX() / this.trackLength);
                } else {
                    this.behavior.trackPress((MouseEvent)mouseEvent, mouseEvent.getY() / this.trackLength);
                }
            }
        });
        this.thumb.setOnMousePressed(mouseEvent -> {
            this.behavior.thumbPressed((MouseEvent)mouseEvent, 0.0);
            this.dragStart = this.thumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
            this.preDragThumbPos = (((Slider)this.getSkinnable()).getValue() - ((Slider)this.getSkinnable()).getMin()) / (((Slider)this.getSkinnable()).getMax() - ((Slider)this.getSkinnable()).getMin());
        });
        this.thumb.setOnMouseReleased(mouseEvent -> this.behavior.thumbReleased((MouseEvent)mouseEvent));
        this.thumb.setOnMouseDragged(mouseEvent -> {
            Point2D point2D = this.thumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
            double d = ((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL ? point2D.getX() - this.dragStart.getX() : -(point2D.getY() - this.dragStart.getY());
            this.behavior.thumbDragged((MouseEvent)mouseEvent, this.preDragThumbPos + d / this.trackLength);
        });
        this.thumb.setOnMouseEntered(mouseEvent -> {
            Tooltip tooltip = ((Slider)this.getSkinnable()).getTooltip();
            if (tooltip != null && tooltip.isAutoHide() && !tooltip.consumeAutoHidingEventsProperty().isBound()) {
                this.tooltipConsumeAutoHidingEvents = tooltip.getConsumeAutoHidingEvents();
                tooltip.setConsumeAutoHidingEvents(false);
            }
        });
        this.thumb.setOnMouseExited(mouseEvent -> {
            Tooltip tooltip = ((Slider)this.getSkinnable()).getTooltip();
            if (tooltip != null && tooltip.isAutoHide() && !tooltip.consumeAutoHidingEventsProperty().isBound()) {
                tooltip.setConsumeAutoHidingEvents(this.tooltipConsumeAutoHidingEvents);
            }
        });
    }

    private void setShowTickMarks(boolean bl, boolean bl2) {
        this.showTickMarks = bl || bl2;
        Slider slider = (Slider)this.getSkinnable();
        if (this.showTickMarks) {
            if (this.tickLine == null) {
                this.tickLine = new NumberAxis();
                this.tickLine.setAutoRanging(false);
                this.tickLine.setSide(slider.getOrientation() == Orientation.VERTICAL ? Side.RIGHT : (slider.getOrientation() == null ? Side.RIGHT : Side.BOTTOM));
                this.tickLine.setUpperBound(slider.getMax());
                this.tickLine.setLowerBound(slider.getMin());
                this.tickLine.setTickUnit(slider.getMajorTickUnit());
                this.tickLine.setTickMarkVisible(bl);
                this.tickLine.setTickLabelsVisible(bl2);
                this.tickLine.setMinorTickVisible(bl);
                this.tickLine.setMinorTickCount(Math.max(slider.getMinorTickCount(), 0) + 1);
                if (slider.getLabelFormatter() != null) {
                    this.tickLine.setTickLabelFormatter(this.stringConverterWrapper);
                }
                this.getChildren().clear();
                this.getChildren().addAll((Object[])new Node[]{this.tickLine, this.track, this.thumb});
            } else {
                this.tickLine.setTickLabelsVisible(bl2);
                this.tickLine.setTickMarkVisible(bl);
                this.tickLine.setMinorTickVisible(bl);
            }
        } else {
            this.getChildren().clear();
            this.getChildren().addAll((Object[])new Node[]{this.track, this.thumb});
        }
        ((Slider)this.getSkinnable()).requestLayout();
    }

    void positionThumb(boolean bl) {
        double d;
        Slider slider = (Slider)this.getSkinnable();
        if (slider.getValue() > slider.getMax()) {
            return;
        }
        boolean bl2 = slider.getOrientation() == Orientation.HORIZONTAL;
        final double d2 = bl2 ? this.trackStart + (this.trackLength * ((slider.getValue() - slider.getMin()) / (slider.getMax() - slider.getMin())) - this.thumbWidth / 2.0) : this.thumbLeft;
        double d3 = d = bl2 ? this.thumbTop : this.snappedTopInset() + this.trackLength - this.trackLength * ((slider.getValue() - slider.getMin()) / (slider.getMax() - slider.getMin()));
        if (bl) {
            final double d4 = this.thumb.getLayoutX();
            final double d5 = this.thumb.getLayoutY();
            Transition transition = new Transition(this){
                final /* synthetic */ SliderSkin this$0;
                {
                    this.this$0 = sliderSkin;
                    this.setCycleDuration(Duration.millis((double)200.0));
                }

                protected void interpolate(double d3) {
                    if (!Double.isNaN(d4)) {
                        this.this$0.thumb.setLayoutX(d4 + d3 * (d2 - d4));
                    }
                    if (!Double.isNaN(d5)) {
                        this.this$0.thumb.setLayoutY(d5 + d3 * (d - d5));
                    }
                }
            };
            transition.play();
        } else {
            this.thumb.setLayoutX(d2);
            this.thumb.setLayoutY(d);
        }
    }

    double minTrackLength() {
        return 2.0 * this.thumb.prefWidth(-1.0);
    }
}

