/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.scene.AccessibleRole;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineJoin;
import javafx.util.Duration;

public class StackedAreaChart<X, Y>
extends XYChart<X, Y> {
    private Map<XYChart.Series<X, Y>, DoubleProperty> seriesYMultiplierMap = new HashMap<XYChart.Series<X, Y>, DoubleProperty>();
    private Timeline timeline;
    private BooleanProperty createSymbols = new StyleableBooleanProperty(true){

        protected void invalidated() {
            for (int i = 0; i < StackedAreaChart.this.getData().size(); ++i) {
                XYChart.Series series = (XYChart.Series)StackedAreaChart.this.getData().get(i);
                for (int j = 0; j < series.getData().size(); ++j) {
                    XYChart.Data data = (XYChart.Data)series.getData().get(j);
                    Node node = data.getNode();
                    if (this.get() && node == null) {
                        node = StackedAreaChart.this.createSymbol(series, StackedAreaChart.this.getData().indexOf((Object)series), data, j);
                        if (null == node) continue;
                        StackedAreaChart.this.getPlotChildren().add((Object)node);
                        continue;
                    }
                    if (this.get() || node == null) continue;
                    StackedAreaChart.this.getPlotChildren().remove((Object)node);
                    node = null;
                    data.setNode(null);
                }
            }
            StackedAreaChart.this.requestChartLayout();
        }

        public Object getBean() {
            return StackedAreaChart.this;
        }

        public String getName() {
            return "createSymbols";
        }

        public CssMetaData<StackedAreaChart<?, ?>, Boolean> getCssMetaData() {
            return StyleableProperties.CREATE_SYMBOLS;
        }
    };

    public final boolean getCreateSymbols() {
        return this.createSymbols.getValue();
    }

    public final void setCreateSymbols(boolean bl) {
        this.createSymbols.setValue(Boolean.valueOf(bl));
    }

    public final BooleanProperty createSymbolsProperty() {
        return this.createSymbols;
    }

    public StackedAreaChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2) {
        this(axis, axis2, FXCollections.observableArrayList());
    }

    public StackedAreaChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2, @NamedArg(value="data") ObservableList<XYChart.Series<X, Y>> observableList) {
        super(axis, axis2);
        if (!(axis2 instanceof ValueAxis)) {
            throw new IllegalArgumentException("Axis type incorrect, yAxis must be of ValueAxis type.");
        }
        this.setData(observableList);
    }

    private static double doubleValue(Number number) {
        return StackedAreaChart.doubleValue(number, 0.0);
    }

    private static double doubleValue(Number number, double d) {
        return number == null ? d : number.doubleValue();
    }

    @Override
    protected void dataItemAdded(XYChart.Series<X, Y> series, int n, XYChart.Data<X, Y> data) {
        Node node = this.createSymbol(series, this.getData().indexOf(series), data, n);
        if (this.shouldAnimate()) {
            boolean bl = false;
            if (n > 0 && n < series.getData().size() - 1) {
                bl = true;
                XYChart.Data data2 = (XYChart.Data)series.getData().get(n - 1);
                XYChart.Data data3 = (XYChart.Data)series.getData().get(n + 1);
                double d = this.getXAxis().toNumericValue(data2.getXValue());
                double d2 = this.getYAxis().toNumericValue(data2.getYValue());
                double d3 = this.getXAxis().toNumericValue(data3.getXValue());
                double d4 = this.getYAxis().toNumericValue(data3.getYValue());
                double d5 = this.getXAxis().toNumericValue(data.getXValue());
                double d6 = this.getYAxis().toNumericValue(data.getYValue());
                double d7 = (d4 - d2) / (d3 - d) * d5 + (d3 * d2 - d4 * d) / (d3 - d);
                data.setCurrentY(this.getYAxis().toRealValue(d7));
                data.setCurrentX(this.getXAxis().toRealValue(d5));
            } else if (n == 0 && series.getData().size() > 1) {
                bl = true;
                data.setCurrentX(((XYChart.Data)series.getData().get(1)).getXValue());
                data.setCurrentY(((XYChart.Data)series.getData().get(1)).getYValue());
            } else if (n == series.getData().size() - 1 && series.getData().size() > 1) {
                bl = true;
                int n2 = series.getData().size() - 2;
                data.setCurrentX(((XYChart.Data)series.getData().get(n2)).getXValue());
                data.setCurrentY(((XYChart.Data)series.getData().get(n2)).getYValue());
            } else if (node != null) {
                node.setOpacity(0.0);
                this.getPlotChildren().add((Object)node);
                FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)500.0), node);
                fadeTransition.setToValue(1.0);
                fadeTransition.play();
            }
            if (bl) {
                this.animate(new KeyFrame(Duration.ZERO, actionEvent -> {
                    if (node != null && !this.getPlotChildren().contains((Object)node)) {
                        this.getPlotChildren().add((Object)node);
                    }
                }, new KeyValue[]{new KeyValue(data.currentYProperty(), data.getCurrentY()), new KeyValue(data.currentXProperty(), data.getCurrentX())}), new KeyFrame(Duration.millis((double)800.0), new KeyValue[]{new KeyValue(data.currentYProperty(), data.getYValue(), Interpolator.EASE_BOTH), new KeyValue(data.currentXProperty(), data.getXValue(), Interpolator.EASE_BOTH)}));
            }
        } else if (node != null) {
            this.getPlotChildren().add((Object)node);
        }
    }

    @Override
    protected void dataItemRemoved(XYChart.Data<X, Y> data, XYChart.Series<X, Y> series) {
        Node node = data.getNode();
        if (node != null) {
            node.focusTraversableProperty().unbind();
        }
        int n = series.getItemIndex(data);
        if (this.shouldAnimate()) {
            boolean bl = false;
            int n2 = series.getDataSize();
            int n3 = series.getData().size();
            if (n > 0 && n < n2 - 1) {
                bl = true;
                XYChart.Data<X, Y> data2 = series.getItem(n - 1);
                XYChart.Data<X, Y> data3 = series.getItem(n + 1);
                double d = this.getXAxis().toNumericValue(data2.getXValue());
                double d2 = this.getYAxis().toNumericValue(data2.getYValue());
                double d3 = this.getXAxis().toNumericValue(data3.getXValue());
                double d4 = this.getYAxis().toNumericValue(data3.getYValue());
                double d5 = this.getXAxis().toNumericValue(data.getXValue());
                double d6 = this.getYAxis().toNumericValue(data.getYValue());
                double d7 = (d4 - d2) / (d3 - d) * d5 + (d3 * d2 - d4 * d) / (d3 - d);
                data.setCurrentX(this.getXAxis().toRealValue(d5));
                data.setCurrentY(this.getYAxis().toRealValue(d6));
                data.setXValue(this.getXAxis().toRealValue(d5));
                data.setYValue(this.getYAxis().toRealValue(d7));
            } else if (n == 0 && n3 > 1) {
                bl = true;
                data.setXValue(((XYChart.Data)series.getData().get(0)).getXValue());
                data.setYValue(((XYChart.Data)series.getData().get(0)).getYValue());
            } else if (n == n2 - 1 && n3 > 1) {
                bl = true;
                int n4 = n3 - 1;
                data.setXValue(((XYChart.Data)series.getData().get(n4)).getXValue());
                data.setYValue(((XYChart.Data)series.getData().get(n4)).getYValue());
            } else if (node != null) {
                node.setOpacity(0.0);
                FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)500.0), node);
                fadeTransition.setToValue(0.0);
                fadeTransition.setOnFinished(actionEvent -> {
                    this.getPlotChildren().remove((Object)node);
                    this.removeDataItemFromDisplay(series, data);
                    node.setOpacity(1.0);
                });
                fadeTransition.play();
            } else {
                data.setSeries(null);
                this.removeDataItemFromDisplay(series, data);
            }
            if (bl) {
                this.animate(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue(data.currentYProperty(), data.getCurrentY()), new KeyValue(data.currentXProperty(), data.getCurrentX())}), new KeyFrame(Duration.millis((double)800.0), actionEvent -> {
                    this.getPlotChildren().remove((Object)node);
                    this.removeDataItemFromDisplay(series, data);
                }, new KeyValue[]{new KeyValue(data.currentYProperty(), data.getYValue(), Interpolator.EASE_BOTH), new KeyValue(data.currentXProperty(), data.getXValue(), Interpolator.EASE_BOTH)}));
            }
        } else {
            this.getPlotChildren().remove((Object)node);
            this.removeDataItemFromDisplay(series, data);
        }
    }

    @Override
    protected void dataItemChanged(XYChart.Data<X, Y> data) {
    }

    @Override
    protected void seriesChanged(ListChangeListener.Change<? extends XYChart.Series> change) {
        for (int i = 0; i < this.getDataSize(); ++i) {
            XYChart.Series series = (XYChart.Series)this.getData().get(i);
            Path path = (Path)((Group)series.getNode()).getChildren().get(1);
            Path path2 = (Path)((Group)series.getNode()).getChildren().get(0);
            path.getStyleClass().setAll((Object[])new String[]{"chart-series-area-line", "series" + i, series.defaultColorStyleClass});
            path2.getStyleClass().setAll((Object[])new String[]{"chart-series-area-fill", "series" + i, series.defaultColorStyleClass});
            for (int j = 0; j < series.getData().size(); ++j) {
                XYChart.Data data = (XYChart.Data)series.getData().get(j);
                Node node = data.getNode();
                if (node == null) continue;
                node.getStyleClass().setAll((Object[])new String[]{"chart-area-symbol", "series" + i, "data" + j, series.defaultColorStyleClass});
            }
        }
    }

    @Override
    protected void seriesAdded(XYChart.Series<X, Y> series, int n) {
        Path path = new Path();
        Path path2 = new Path();
        path.setStrokeLineJoin(StrokeLineJoin.BEVEL);
        path2.setStrokeLineJoin(StrokeLineJoin.BEVEL);
        Group group = new Group(new Node[]{path2, path});
        series.setNode((Node)group);
        SimpleDoubleProperty simpleDoubleProperty = new SimpleDoubleProperty((Object)this, "seriesYMultiplier");
        this.seriesYMultiplierMap.put(series, (DoubleProperty)simpleDoubleProperty);
        if (this.shouldAnimate()) {
            simpleDoubleProperty.setValue((Number)0.0);
        } else {
            simpleDoubleProperty.setValue((Number)1.0);
        }
        this.getPlotChildren().add((Object)group);
        ArrayList<KeyFrame> arrayList = new ArrayList<KeyFrame>();
        if (this.shouldAnimate()) {
            arrayList.add(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)group.opacityProperty(), (Object)0), new KeyValue((WritableValue)simpleDoubleProperty, (Object)0)}));
            arrayList.add(new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)group.opacityProperty(), (Object)1)}));
            arrayList.add(new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)simpleDoubleProperty, (Object)1)}));
        }
        for (int i = 0; i < series.getData().size(); ++i) {
            XYChart.Data data = (XYChart.Data)series.getData().get(i);
            Node node = this.createSymbol(series, n, data, i);
            if (node == null) continue;
            if (this.shouldAnimate()) {
                node.setOpacity(0.0);
            }
            this.getPlotChildren().add((Object)node);
            if (!this.shouldAnimate()) continue;
            arrayList.add(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)0)}));
            arrayList.add(new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)1)}));
        }
        if (this.shouldAnimate()) {
            this.animate(arrayList.toArray(new KeyFrame[arrayList.size()]));
        }
    }

    @Override
    protected void seriesRemoved(XYChart.Series<X, Y> series) {
        this.seriesYMultiplierMap.remove(series);
        if (this.shouldAnimate()) {
            this.timeline = new Timeline(this.createSeriesRemoveTimeLine(series, 400L));
            this.timeline.play();
        } else {
            this.getPlotChildren().remove((Object)series.getNode());
            for (XYChart.Data data : series.getData()) {
                this.getPlotChildren().remove((Object)data.getNode());
            }
            this.removeSeriesFromDisplay(series);
        }
    }

    @Override
    protected void updateAxisRange() {
        Axis axis = this.getXAxis();
        Axis axis2 = this.getYAxis();
        if (axis.isAutoRanging()) {
            ArrayList arrayList = new ArrayList();
            for (Object object : this.getData()) {
                for (Object object2 : ((XYChart.Series)object).getData()) {
                    arrayList.add(((XYChart.Data)object2).getXValue());
                }
            }
            axis.invalidateRange(arrayList);
        }
        if (axis2.isAutoRanging()) {
            Object object2;
            Object object;
            double d = Double.MAX_VALUE;
            object = this.getDisplayedSeriesIterator();
            boolean bl = true;
            object2 = new TreeMap();
            TreeMap treeMap = new TreeMap();
            TreeMap<Double, Double> treeMap2 = new TreeMap<Double, Double>();
            while (object.hasNext()) {
                treeMap2.clear();
                XYChart.Series series = (XYChart.Series)object.next();
                for (Object object3 : series.getData()) {
                    if (object3 == null) continue;
                    double d2 = axis.toNumericValue(((XYChart.Data)object3).getXValue());
                    double d3 = axis2.toNumericValue(((XYChart.Data)object3).getYValue());
                    treeMap2.put(d2, d3);
                    if (bl) {
                        object2.put(d2, d3);
                        d = Math.min(d, d3);
                        continue;
                    }
                    if (treeMap.containsKey(d2)) {
                        object2.put(d2, (Double)treeMap.get(d2) + d3);
                        continue;
                    }
                    Map.Entry entry = treeMap.higherEntry(d2);
                    Map.Entry entry2 = treeMap.lowerEntry(d2);
                    if (entry != null && entry2 != null) {
                        object2.put(d2, (d2 - entry2.getKey()) / (entry.getKey() - entry2.getKey()) * ((Double)entry2.getValue() + (Double)entry.getValue()) + d3);
                        continue;
                    }
                    if (entry != null) {
                        object2.put(d2, (Double)entry.getValue() + d3);
                        continue;
                    }
                    if (entry2 != null) {
                        object2.put(d2, (Double)entry2.getValue() + d3);
                        continue;
                    }
                    object2.put(d2, d3);
                }
                for (Object object3 : treeMap.entrySet()) {
                    if (object2.keySet().contains(object3.getKey())) continue;
                    Double d4 = (Double)object3.getKey();
                    Double d5 = (Double)object3.getValue();
                    Map.Entry entry = treeMap2.higherEntry(d4);
                    Map.Entry entry3 = treeMap2.lowerEntry(d4);
                    if (entry != null && entry3 != null) {
                        object2.put(d4, (d4 - entry3.getKey()) / (entry.getKey() - entry3.getKey()) * ((Double)entry3.getValue() + (Double)entry.getValue()) + d5);
                        continue;
                    }
                    if (entry != null) {
                        object2.put(d4, (Double)entry.getValue() + d5);
                        continue;
                    }
                    if (entry3 != null) {
                        object2.put(d4, (Double)entry3.getValue() + d5);
                        continue;
                    }
                    object2.put(d4, d5);
                }
                treeMap.clear();
                treeMap.putAll(object2);
                object2.clear();
                bl = d == Double.MAX_VALUE;
            }
            if (d != Double.MAX_VALUE) {
                axis2.invalidateRange(Arrays.asList(axis2.toRealValue(d), axis2.toRealValue((Double)Collections.max(treeMap.values()))));
            }
        }
    }

    @Override
    protected void layoutPlotChildren() {
        ArrayList<DataPointInfo<X, Y>> arrayList = new ArrayList<DataPointInfo<X, Y>>();
        ArrayList<DataPointInfo<X, Y>> arrayList2 = new ArrayList<DataPointInfo<X, Y>>();
        for (int i = 0; i < this.getDataSize(); ++i) {
            Node node;
            Path path;
            XYChart.Series series = (XYChart.Series)this.getData().get(i);
            arrayList2.clear();
            for (DataPointInfo dataPointInfo : arrayList) {
                dataPointInfo.partOf = PartOf.PREVIOUS;
                arrayList2.add(dataPointInfo);
            }
            arrayList.clear();
            Iterator<Object> iterator = this.getDisplayedDataIterator(series);
            while (iterator.hasNext()) {
                XYChart.Data data = (XYChart.Data)iterator.next();
                path = new DataPointInfo(data, data.getXValue(), data.getYValue(), PartOf.CURRENT);
                arrayList2.add((DataPointInfo<X, Y>)path);
            }
            iterator = this.seriesYMultiplierMap.get(series);
            Path object2 = (Path)((Group)series.getNode()).getChildren().get(1);
            path = (Path)((Group)series.getNode()).getChildren().get(0);
            object2.getElements().clear();
            path.getElements().clear();
            int n = 0;
            this.sortAggregateList(arrayList2);
            Axis axis = this.getYAxis();
            Axis axis2 = this.getXAxis();
            boolean bl = false;
            boolean bl2 = false;
            int n2 = this.findNextCurrent(arrayList2, -1);
            int n3 = this.findPreviousCurrent(arrayList2, arrayList2.size());
            double d = axis.getZeroPosition();
            if (Double.isNaN(d)) {
                Object object = (ValueAxis)axis;
                d = object.getLowerBound() > 0.0 ? object.getDisplayPosition(object.getLowerBound()) : object.getDisplayPosition(object.getUpperBound());
            }
            for (DataPointInfo<X, Y> dataPointInfo : arrayList2) {
                if (n == n3) {
                    bl2 = true;
                }
                if (n == n2) {
                    bl = true;
                }
                node = dataPointInfo.dataItem;
                if (dataPointInfo.partOf.equals((Object)PartOf.CURRENT)) {
                    var20_24 = this.findPreviousPrevious(arrayList2, n);
                    var21_26 = this.findNextPrevious(arrayList2, n);
                    if (var20_24 == -1 || var21_26 == -1 && !arrayList2.get((int)var20_24).x.equals(dataPointInfo.x)) {
                        if (bl) {
                            XYChart.Data data = new XYChart.Data(dataPointInfo.x, 0);
                            this.addDropDown(arrayList, data, data.getXValue(), data.getYValue(), axis2.getDisplayPosition(data.getCurrentX()), d);
                        }
                        var24_30 = axis2.getDisplayPosition(node.getCurrentX());
                        var26_32 = axis.getDisplayPosition(axis.toRealValue(axis.toNumericValue(node.getCurrentY()) * iterator.getValue()));
                        this.addPoint(arrayList, (XYChart.Data<X, Y>)node, node.getXValue(), node.getYValue(), var24_30, var26_32, PartOf.CURRENT, false, !bl);
                        if (n == n3) {
                            XYChart.Data data = new XYChart.Data(dataPointInfo.x, 0);
                            this.addDropDown(arrayList, data, data.getXValue(), data.getYValue(), axis2.getDisplayPosition(data.getCurrentX()), d);
                        }
                    } else {
                        var22_27 = arrayList2.get(var20_24);
                        if (var22_27.x.equals(dataPointInfo.x)) {
                            if (var22_27.dropDown) {
                                var20_24 = this.findPreviousPrevious(arrayList2, var20_24);
                                var22_27 = arrayList2.get(var20_24);
                            }
                            if (var22_27.x.equals(dataPointInfo.x)) {
                                var24_30 = axis2.getDisplayPosition(node.getCurrentX());
                                var26_32 = axis.toNumericValue(node.getCurrentY()) + axis.toNumericValue(var22_27.y);
                                double d2 = axis.getDisplayPosition(axis.toRealValue(var26_32 * iterator.getValue()));
                                this.addPoint(arrayList, (XYChart.Data<X, Y>)node, dataPointInfo.x, axis.toRealValue(var26_32), var24_30, d2, PartOf.CURRENT, false, !bl);
                            }
                            if (bl2) {
                                this.addDropDown(arrayList, (XYChart.Data<X, Y>)node, var22_27.x, var22_27.y, var22_27.displayX, var22_27.displayY);
                            }
                        } else {
                            var23_29 = var21_26 == -1 ? null : arrayList2.get(var21_26);
                            var22_27 = var20_24 == -1 ? null : arrayList2.get(var20_24);
                            var24_30 = axis.toNumericValue(node.getCurrentY());
                            if (var22_27 != null && var23_29 != null) {
                                var26_32 = axis2.getDisplayPosition(node.getCurrentX());
                                double d3 = this.interpolate(var22_27.displayX, var22_27.displayY, var23_29.displayX, var23_29.displayY, var26_32);
                                var30_37 = this.interpolate(axis2.toNumericValue(var22_27.x), axis.toNumericValue(var22_27.y), axis2.toNumericValue(var23_29.x), axis.toNumericValue(var23_29.y), axis2.toNumericValue(dataPointInfo.x));
                                if (bl) {
                                    XYChart.Data data = new XYChart.Data(dataPointInfo.x, var30_37);
                                    this.addDropDown(arrayList, data, dataPointInfo.x, axis.toRealValue(var30_37), var26_32, d3);
                                }
                                double d4 = axis.getDisplayPosition(axis.toRealValue((var24_30 + var30_37) * iterator.getValue()));
                                this.addPoint(arrayList, (XYChart.Data<X, Y>)node, dataPointInfo.x, axis.toRealValue(var24_30 + var30_37), var26_32, d4, PartOf.CURRENT, false, !bl);
                                if (n == n3) {
                                    XYChart.Data data = new XYChart.Data(dataPointInfo.x, var30_37);
                                    this.addDropDown(arrayList, data, dataPointInfo.x, axis.toRealValue(var30_37), var26_32, d3);
                                }
                            }
                        }
                    }
                } else {
                    var20_24 = this.findPreviousCurrent(arrayList2, n);
                    var21_26 = this.findNextCurrent(arrayList2, n);
                    if (dataPointInfo.dropDown) {
                        if (axis2.toNumericValue(dataPointInfo.x) <= axis2.toNumericValue(arrayList2.get((int)n2).x) || axis2.toNumericValue(dataPointInfo.x) > axis2.toNumericValue(arrayList2.get((int)n3).x)) {
                            this.addDropDown(arrayList, (XYChart.Data<X, Y>)node, dataPointInfo.x, dataPointInfo.y, dataPointInfo.displayX, dataPointInfo.displayY);
                        }
                    } else if (var20_24 == -1 || var21_26 == -1) {
                        this.addPoint(arrayList, (XYChart.Data<X, Y>)node, dataPointInfo.x, dataPointInfo.y, dataPointInfo.displayX, dataPointInfo.displayY, PartOf.CURRENT, true, false);
                    } else {
                        var23_29 = arrayList2.get(var21_26);
                        if (!var23_29.x.equals(dataPointInfo.x)) {
                            var22_27 = arrayList2.get(var20_24);
                            var24_30 = axis2.getDisplayPosition(node.getCurrentX());
                            var26_32 = this.interpolate(axis2.toNumericValue(var22_27.x), axis.toNumericValue(var22_27.y), axis2.toNumericValue(var23_29.x), axis.toNumericValue(var23_29.y), axis2.toNumericValue(dataPointInfo.x));
                            double d5 = axis.toNumericValue(dataPointInfo.y) + var26_32;
                            var30_37 = axis.getDisplayPosition(axis.toRealValue(d5 * iterator.getValue()));
                            this.addPoint(arrayList, new XYChart.Data(dataPointInfo.x, var26_32), dataPointInfo.x, axis.toRealValue(d5), var24_30, var30_37, PartOf.CURRENT, true, true);
                        }
                    }
                }
                ++n;
                if (bl) {
                    bl = false;
                }
                if (!bl2) continue;
                bl2 = false;
            }
            if (!arrayList.isEmpty()) {
                object2.getElements().add((Object)new MoveTo(((DataPointInfo)arrayList.get((int)0)).displayX, ((DataPointInfo)arrayList.get((int)0)).displayY));
                path.getElements().add((Object)new MoveTo(((DataPointInfo)arrayList.get((int)0)).displayX, ((DataPointInfo)arrayList.get((int)0)).displayY));
            }
            for (DataPointInfo<X, Y> dataPointInfo : arrayList) {
                if (dataPointInfo.lineTo) {
                    object2.getElements().add((Object)new LineTo(dataPointInfo.displayX, dataPointInfo.displayY));
                } else {
                    object2.getElements().add((Object)new MoveTo(dataPointInfo.displayX, dataPointInfo.displayY));
                }
                path.getElements().add((Object)new LineTo(dataPointInfo.displayX, dataPointInfo.displayY));
                if (dataPointInfo.skipSymbol || (node = dataPointInfo.dataItem.getNode()) == null) continue;
                double d6 = node.prefWidth(-1.0);
                double d7 = node.prefHeight(-1.0);
                node.resizeRelocate(dataPointInfo.displayX - d6 / 2.0, dataPointInfo.displayY - d7 / 2.0, d6, d7);
            }
            for (int j = arrayList2.size() - 1; j > 0; --j) {
                DataPointInfo<X, Y> dataPointInfo;
                dataPointInfo = arrayList2.get(j);
                if (!PartOf.PREVIOUS.equals((Object)dataPointInfo.partOf)) continue;
                path.getElements().add((Object)new LineTo(dataPointInfo.displayX, dataPointInfo.displayY));
            }
            if (path.getElements().isEmpty()) continue;
            path.getElements().add((Object)new ClosePath());
        }
    }

    private void addDropDown(ArrayList<DataPointInfo<X, Y>> arrayList, XYChart.Data<X, Y> data, X x, Y y, double d, double d2) {
        DataPointInfo<X, Y> dataPointInfo = new DataPointInfo<X, Y>(true);
        dataPointInfo.setValues(data, x, y, d, d2, PartOf.CURRENT, true, false);
        arrayList.add(dataPointInfo);
    }

    private void addPoint(ArrayList<DataPointInfo<X, Y>> arrayList, XYChart.Data<X, Y> data, X x, Y y, double d, double d2, PartOf partOf, boolean bl, boolean bl2) {
        DataPointInfo<X, Y> dataPointInfo = new DataPointInfo<X, Y>();
        dataPointInfo.setValues(data, x, y, d, d2, partOf, bl, bl2);
        arrayList.add(dataPointInfo);
    }

    @Override
    void seriesBeingRemovedIsAdded(XYChart.Series<X, Y> series) {
        if (this.timeline != null) {
            this.timeline.setOnFinished(null);
            this.timeline.stop();
            this.timeline = null;
            this.getPlotChildren().remove((Object)series.getNode());
            for (XYChart.Data data : series.getData()) {
                this.getPlotChildren().remove((Object)data.getNode());
            }
            this.removeSeriesFromDisplay(series);
        }
    }

    private int findNextCurrent(ArrayList<DataPointInfo<X, Y>> arrayList, int n) {
        for (int i = n + 1; i < arrayList.size(); ++i) {
            if (!arrayList.get((int)i).partOf.equals((Object)PartOf.CURRENT)) continue;
            return i;
        }
        return -1;
    }

    private int findPreviousCurrent(ArrayList<DataPointInfo<X, Y>> arrayList, int n) {
        for (int i = n - 1; i >= 0; --i) {
            if (!arrayList.get((int)i).partOf.equals((Object)PartOf.CURRENT)) continue;
            return i;
        }
        return -1;
    }

    private int findPreviousPrevious(ArrayList<DataPointInfo<X, Y>> arrayList, int n) {
        for (int i = n - 1; i >= 0; --i) {
            if (!arrayList.get((int)i).partOf.equals((Object)PartOf.PREVIOUS)) continue;
            return i;
        }
        return -1;
    }

    private int findNextPrevious(ArrayList<DataPointInfo<X, Y>> arrayList, int n) {
        for (int i = n + 1; i < arrayList.size(); ++i) {
            if (!arrayList.get((int)i).partOf.equals((Object)PartOf.PREVIOUS)) continue;
            return i;
        }
        return -1;
    }

    private void sortAggregateList(ArrayList<DataPointInfo<X, Y>> arrayList) {
        Collections.sort(arrayList, (dataPointInfo, dataPointInfo2) -> {
            double d;
            XYChart.Data data = dataPointInfo.dataItem;
            XYChart.Data data2 = dataPointInfo2.dataItem;
            double d2 = this.getXAxis().toNumericValue(data.getXValue());
            return d2 < (d = this.getXAxis().toNumericValue(data2.getXValue())) ? -1 : (d2 == d ? 0 : 1);
        });
    }

    private double interpolate(double d, double d2, double d3, double d4, double d5) {
        return (d4 - d2) / (d3 - d) * (d5 - d) + d2;
    }

    private Node createSymbol(XYChart.Series<X, Y> series, int n, XYChart.Data<X, Y> data, int n2) {
        Node node = data.getNode();
        if (node == null && this.getCreateSymbols()) {
            node = new StackPane();
            node.setAccessibleRole(AccessibleRole.TEXT);
            node.setAccessibleRoleDescription("Point");
            node.setFocusTraversable(this.isAccessibilityActive());
            data.setNode(node);
        }
        if (node != null) {
            node.getStyleClass().setAll((Object[])new String[]{"chart-area-symbol", "series" + n, "data" + n2, series.defaultColorStyleClass});
        }
        return node;
    }

    @Override
    Legend.LegendItem createLegendItemForSeries(XYChart.Series<X, Y> series, int n) {
        Legend.LegendItem legendItem = new Legend.LegendItem(series.getName());
        legendItem.getSymbol().getStyleClass().addAll((Object[])new String[]{"chart-area-symbol", "series" + n, "area-legend-symbol", series.defaultColorStyleClass});
        return legendItem;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return StackedAreaChart.getClassCssMetaData();
    }

    static final class DataPointInfo<X, Y> {
        X x;
        Y y;
        double displayX;
        double displayY;
        XYChart.Data<X, Y> dataItem;
        PartOf partOf;
        boolean skipSymbol = false;
        boolean lineTo = false;
        boolean dropDown = false;

        DataPointInfo() {
        }

        DataPointInfo(XYChart.Data<X, Y> data, X x, Y y, PartOf partOf) {
            this.dataItem = data;
            this.x = x;
            this.y = y;
            this.partOf = partOf;
        }

        DataPointInfo(boolean bl) {
            this.dropDown = bl;
        }

        void setValues(XYChart.Data<X, Y> data, X x, Y y, double d, double d2, PartOf partOf, boolean bl, boolean bl2) {
            this.dataItem = data;
            this.x = x;
            this.y = y;
            this.displayX = d;
            this.displayY = d2;
            this.partOf = partOf;
            this.skipSymbol = bl;
            this.lineTo = bl2;
        }

        public final X getX() {
            return this.x;
        }

        public final Y getY() {
            return this.y;
        }
    }

    private static enum PartOf {
        CURRENT,
        PREVIOUS;

    }

    private static class StyleableProperties {
        private static final CssMetaData<StackedAreaChart<?, ?>, Boolean> CREATE_SYMBOLS = new CssMetaData<StackedAreaChart<?, ?>, Boolean>("-fx-create-symbols", BooleanConverter.getInstance(), Boolean.TRUE){

            public boolean isSettable(StackedAreaChart<?, ?> stackedAreaChart) {
                return stackedAreaChart.createSymbols == null || !stackedAreaChart.createSymbols.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(StackedAreaChart<?, ?> stackedAreaChart) {
                return (StyleableProperty)stackedAreaChart.createSymbolsProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(XYChart.getClassCssMetaData());
            arrayList.add(CREATE_SYMBOLS);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

