/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public abstract sealed class FixedCapacitySet<T>
extends AbstractSet<T> {
    private static final FixedCapacitySet<?> EMPTY = new Single();
    private boolean frozen;

    private static <T> FixedCapacitySet<T> empty() {
        return EMPTY;
    }

    public static <T> FixedCapacitySet<T> of(int n) {
        return n == 0 ? FixedCapacitySet.empty() : (n == 1 ? new Single() : (n == 2 ? new Duo() : (n < 10 ? new Hashless(n) : new OpenAddressed(n))));
    }

    public abstract boolean isSuperSetOf(Collection<?> var1);

    public final void freeze() {
        this.frozen = true;
    }

    protected final void ensureNotFrozen() {
        if (this.frozen) {
            throw new UnsupportedOperationException();
        }
    }

    static {
        EMPTY.freeze();
    }

    private static final class Single<T>
    extends FixedCapacitySet<T> {
        private T element;

        private Single() {
        }

        @Override
        public int size() {
            return this.element == null ? 0 : 1;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private boolean hasNext;
                {
                    this.hasNext = element != null;
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.hasNext = false;
                    return element;
                }
            };
        }

        @Override
        public boolean isSuperSetOf(Collection<?> collection) {
            return this.element == null || collection.contains(this.element);
        }

        @Override
        public boolean contains(Object object) {
            return this.element != null && this.element.equals(object);
        }

        @Override
        public boolean add(T t) {
            this.ensureNotFrozen();
            if (this.contains(Objects.requireNonNull(t, "e"))) {
                return false;
            }
            if (this.element != null) {
                throw new IllegalStateException("set is full");
            }
            this.element = t;
            return true;
        }

        @Override
        public int hashCode() {
            return this.element == null ? 0 : this.element.hashCode();
        }
    }

    private static final class Duo<T>
    extends FixedCapacitySet<T> {
        private T element1;
        private T element2;
        private int size;

        private Duo() {
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int index;

                @Override
                public boolean hasNext() {
                    return this.index < size;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.index++ == 0 ? element1 : element2;
                }
            };
        }

        @Override
        public boolean isSuperSetOf(Collection<?> collection) {
            return this.element1 == null || collection.contains(this.element1) && (this.element2 == null || collection.contains(this.element2));
        }

        @Override
        public boolean contains(Object object) {
            return this.element1 != null && this.element1.equals(object) || this.element2 != null && this.element2.equals(object);
        }

        @Override
        public boolean add(T t) {
            this.ensureNotFrozen();
            if (this.contains(Objects.requireNonNull(t, "e"))) {
                return false;
            }
            if (this.size == 2) {
                throw new IllegalStateException("set is full");
            }
            if (this.size == 0) {
                this.element1 = t;
            } else {
                this.element2 = t;
            }
            ++this.size;
            return true;
        }

        @Override
        public int hashCode() {
            return this.element1 == null ? 0 : this.element1.hashCode() + (this.element2 == null ? 0 : this.element2.hashCode());
        }
    }

    private static final class Hashless<T>
    extends FixedCapacitySet<T> {
        private final T[] elements;
        private int size;

        private Hashless(int n) {
            this.elements = new Object[n];
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int index;

                @Override
                public boolean hasNext() {
                    return this.index < size;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return elements[this.index++];
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.elements[i].equals(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isSuperSetOf(Collection<?> collection) {
            for (int i = 0; i < this.size; ++i) {
                if (collection.contains(this.elements[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean add(T t) {
            this.ensureNotFrozen();
            if (this.contains(Objects.requireNonNull(t, "e"))) {
                return false;
            }
            if (this.size == this.elements.length) {
                throw new IllegalStateException("set is full");
            }
            this.elements[this.size++] = t;
            return true;
        }

        @Override
        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.size; ++i) {
                n += this.elements[i].hashCode();
            }
            return n;
        }
    }

    private static final class OpenAddressed<T>
    extends FixedCapacitySet<T> {
        private final T[] elements;
        private final int requestedCapacity;
        private final int mask;
        private int size;

        private OpenAddressed(int n) {
            this.requestedCapacity = n;
            int n2 = 32 - Integer.numberOfLeadingZeros(n * 2 - n / 2);
            this.elements = new Object[1 << n2];
            this.mask = (1 << n2) - 1;
            assert (this.elements.length > this.requestedCapacity) : "must have more buckets than capacity";
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int index = this.findFilledBucket(0);

                private int findFilledBucket(int n) {
                    for (int i = n; i < elements.length; ++i) {
                        if (elements[i] == null) continue;
                        return i;
                    }
                    return -1;
                }

                @Override
                public boolean hasNext() {
                    return this.index >= 0;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object t = elements[this.index];
                    this.index = this.findFilledBucket(this.index + 1);
                    return t;
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            int n = this.determineBucketIndex(object);
            while (this.elements[n] != null) {
                if (this.elements[n].equals(object)) {
                    return true;
                }
                if (++n < this.elements.length) continue;
                n = 0;
            }
            return false;
        }

        @Override
        public boolean isSuperSetOf(Collection<?> collection) {
            for (int i = 0; i < this.elements.length; ++i) {
                T t = this.elements[i];
                if (t == null || collection.contains(t)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean add(T t) {
            this.ensureNotFrozen();
            int n = this.determineBucketIndex(t);
            while (this.elements[n] != null) {
                if (this.elements[n].equals(t)) {
                    return false;
                }
                if (++n < this.elements.length) continue;
                n = 0;
            }
            if (this.size == this.requestedCapacity) {
                throw new IllegalStateException("set is full");
            }
            this.elements[n] = t;
            ++this.size;
            return true;
        }

        @Override
        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.elements.length; ++i) {
                T t = this.elements[i];
                n += t == null ? 0 : t.hashCode();
            }
            return n;
        }

        private int determineBucketIndex(Object object) {
            int n = object.hashCode();
            return (n ^ n >>> 16) & this.mask;
        }
    }
}

