/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.ImmutablePseudoClassSetsCache;
import java.util.Objects;
import java.util.Set;
import javafx.css.PseudoClass;
import javafx.css.Selector;
import javafx.css.SimpleSelector;
import javafx.geometry.NodeOrientation;

public final class Match
implements Comparable<Match> {
    private final Selector selector;
    private final Set<PseudoClass> pseudoClasses;
    final int styleClassCount;
    final int idCount;
    final int specificity;

    Match(Selector selector, Set<PseudoClass> set, int n, int n2) {
        SimpleSelector simpleSelector;
        Objects.requireNonNull(selector);
        Objects.requireNonNull(set);
        this.selector = selector;
        this.idCount = n;
        this.styleClassCount = n2;
        this.pseudoClasses = ImmutablePseudoClassSetsCache.of(set);
        int n3 = set.size();
        if (selector instanceof SimpleSelector && (simpleSelector = (SimpleSelector)selector).getNodeOrientation() != NodeOrientation.INHERIT) {
            ++n3;
        }
        this.specificity = n << 8 | n2 << 4 | n3;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public Set<PseudoClass> getPseudoClasses() {
        return this.pseudoClasses;
    }

    public int getSpecificity() {
        return this.specificity;
    }

    @Override
    public int compareTo(Match match) {
        return this.specificity - match.specificity;
    }
}

