/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk.screencast;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class XdgDesktopPortal {
    private static final String METHOD_GTK = "gtk";
    private static final String METHOD_SCREENCAST = "dbusScreencast";
    private static final String METHOD_REMOTE_DESKTOP = "dbusRemoteDesktop";
    private static final String method;
    private static final boolean isRemoteDesktop;
    private static final boolean isScreencast;

    private XdgDesktopPortal() {
    }

    public static String getMethod() {
        return method;
    }

    public static boolean isRemoteDesktop() {
        return isRemoteDesktop;
    }

    public static boolean isScreencast() {
        return isScreencast;
    }

    private static String getDesktop() {
        String string = "gnome";
        String string2 = System.getenv("GNOME_DESKTOP_SESSION_ID");
        if (string2 != null) {
            return string;
        }
        String string3 = System.getenv("XDG_CURRENT_DESKTOP");
        return string3 != null && string3.toLowerCase().contains(string) ? string : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Integer getGnomeShellMajorVersion() {
        try {
            Process process = new ProcessBuilder("/usr/bin/gnome-shell", "--version").start();
            try (BufferedReader bufferedReader = process.inputReader();){
                if (!process.waitFor(2L, TimeUnit.SECONDS)) return null;
                if (process.exitValue() != 0) return null;
                String string = bufferedReader.readLine();
                if (string == null) return null;
                String[] stringArray = string.replaceAll("[^\\d.]", "").split("\\.");
                if (stringArray.length < 1) return null;
                Integer n = Integer.parseInt(stringArray[0]);
                return n;
            }
        }
        catch (IOException | IllegalThreadStateException | InterruptedException | NumberFormatException exception) {
            // empty catch block
        }
        return null;
    }

    static {
        Object object;
        String string = System.getenv("WAYLAND_DISPLAY");
        boolean bl = string != null && !string.isBlank();
        String string2 = METHOD_GTK;
        if (bl) {
            object = null;
            if ("gnome".equals(XdgDesktopPortal.getDesktop())) {
                object = XdgDesktopPortal.getGnomeShellMajorVersion();
            }
            String string3 = string2 = object != null && (Integer)object >= 47 ? METHOD_REMOTE_DESKTOP : METHOD_SCREENCAST;
        }
        if (!(METHOD_REMOTE_DESKTOP.equals(object = System.getProperty("javafx.robot.screenshotMethod", string2)) || METHOD_SCREENCAST.equals(object) || METHOD_GTK.equals(object))) {
            object = string2;
        }
        isRemoteDesktop = METHOD_REMOTE_DESKTOP.equals(object);
        isScreencast = METHOD_SCREENCAST.equals(object);
        method = object;
    }
}

