/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.headless;

import com.sun.glass.ui.Application;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;

public class NestedRunnableProcessor
implements Runnable {
    private final LinkedList<RunLoopEntry> activeRunLoops = new LinkedList();
    private final BlockingQueue<Runnable> runnableQueue = new LinkedBlockingQueue<Runnable>();

    @Override
    public void run() {
        this.newRunLoop();
    }

    void invokeLater(Runnable runnable) {
        this.runnableQueue.add(runnable);
    }

    void invokeAndWait(Runnable runnable) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.runnableQueue.add(() -> {
            try {
                runnable.run();
            }
            finally {
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Application.reportException(interruptedException);
        }
    }

    void stopProcessing() {
        for (RunLoopEntry runLoopEntry : this.activeRunLoops) {
            this.runnableQueue.add(() -> {
                runLoopEntry.active = false;
            });
        }
    }

    public Object newRunLoop() {
        RunLoopEntry runLoopEntry = new RunLoopEntry();
        this.activeRunLoops.push(runLoopEntry);
        runLoopEntry.active = true;
        while (runLoopEntry.active) {
            try {
                this.runnableQueue.take().run();
            }
            catch (Throwable throwable) {
                Application.reportException(throwable);
            }
        }
        return runLoopEntry.returnValue;
    }

    public void leaveCurrentLoop(Object object) {
        RunLoopEntry runLoopEntry = this.activeRunLoops.pop();
        runLoopEntry.active = false;
        runLoopEntry.returnValue = object;
    }

    private static class RunLoopEntry {
        boolean active;
        Object returnValue;

        private RunLoopEntry() {
        }
    }
}

