/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.text;

import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextLayoutFactory;
import com.sun.javafx.text.PrismTextLayout;
import java.util.concurrent.atomic.AtomicBoolean;

public class PrismTextLayoutFactory
implements TextLayoutFactory {
    private static final PrismTextLayoutFactory FACTORY = new PrismTextLayoutFactory();
    private static final TextLayout REUSABLE_INSTANCE = FACTORY.createLayout();
    private static final AtomicBoolean IN_USE = new AtomicBoolean(false);

    private PrismTextLayoutFactory() {
    }

    @Override
    public TextLayout createLayout() {
        return new PrismTextLayout(PrismFontFactory.cacheLayoutSize);
    }

    @Override
    public TextLayout getLayout() {
        if (IN_USE.compareAndSet(false, true)) {
            REUSABLE_INSTANCE.setAlignment(0);
            REUSABLE_INSTANCE.setWrapWidth(0.0f);
            REUSABLE_INSTANCE.setDirection(0);
            REUSABLE_INSTANCE.setContent(null);
            return REUSABLE_INSTANCE;
        }
        return this.createLayout();
    }

    @Override
    public void disposeLayout(TextLayout textLayout) {
        if (textLayout == REUSABLE_INSTANCE) {
            IN_USE.set(false);
        }
    }

    public static PrismTextLayoutFactory getFactory() {
        return FACTORY;
    }
}

