/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.videoio;

import org.opencv.core.Mat;

public class VideoCapture {
    protected final long nativeObj;

    protected VideoCapture(long addr) {
        this.nativeObj = addr;
    }

    public VideoCapture(String filename, int apiPreference) {
        this.nativeObj = VideoCapture.VideoCapture_0(filename, apiPreference);
    }

    public VideoCapture(String filename) {
        this.nativeObj = VideoCapture.VideoCapture_1(filename);
    }

    public VideoCapture(int index) {
        this.nativeObj = VideoCapture.VideoCapture_2(index);
    }

    public VideoCapture() {
        this.nativeObj = VideoCapture.VideoCapture_3();
    }

    public boolean grab() {
        boolean retVal = VideoCapture.grab_0(this.nativeObj);
        return retVal;
    }

    public boolean isOpened() {
        boolean retVal = VideoCapture.isOpened_0(this.nativeObj);
        return retVal;
    }

    public boolean open(String filename, int apiPreference) {
        boolean retVal = VideoCapture.open_0(this.nativeObj, filename, apiPreference);
        return retVal;
    }

    public boolean open(String filename) {
        boolean retVal = VideoCapture.open_1(this.nativeObj, filename);
        return retVal;
    }

    public boolean open(int cameraNum, int apiPreference) {
        boolean retVal = VideoCapture.open_2(this.nativeObj, cameraNum, apiPreference);
        return retVal;
    }

    public boolean open(int index) {
        boolean retVal = VideoCapture.open_3(this.nativeObj, index);
        return retVal;
    }

    public boolean read(Mat image) {
        boolean retVal = VideoCapture.read_0(this.nativeObj, image.nativeObj);
        return retVal;
    }

    public boolean retrieve(Mat image, int flag) {
        boolean retVal = VideoCapture.retrieve_0(this.nativeObj, image.nativeObj, flag);
        return retVal;
    }

    public boolean retrieve(Mat image) {
        boolean retVal = VideoCapture.retrieve_1(this.nativeObj, image.nativeObj);
        return retVal;
    }

    public boolean set(int propId, double value) {
        boolean retVal = VideoCapture.set_0(this.nativeObj, propId, value);
        return retVal;
    }

    public double get(int propId) {
        double retVal = VideoCapture.get_0(this.nativeObj, propId);
        return retVal;
    }

    public void release() {
        VideoCapture.release_0(this.nativeObj);
    }

    protected void finalize() throws Throwable {
        VideoCapture.delete(this.nativeObj);
    }

    private static native long VideoCapture_0(String var0, int var1);

    private static native long VideoCapture_1(String var0);

    private static native long VideoCapture_2(int var0);

    private static native long VideoCapture_3();

    private static native boolean grab_0(long var0);

    private static native boolean isOpened_0(long var0);

    private static native boolean open_0(long var0, String var2, int var3);

    private static native boolean open_1(long var0, String var2);

    private static native boolean open_2(long var0, int var2, int var3);

    private static native boolean open_3(long var0, int var2);

    private static native boolean read_0(long var0, long var2);

    private static native boolean retrieve_0(long var0, long var2, int var4);

    private static native boolean retrieve_1(long var0, long var2);

    private static native boolean set_0(long var0, int var2, double var3);

    private static native double get_0(long var0, int var2);

    private static native void release_0(long var0);

    private static native void delete(long var0);
}

