/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.openqa.selenium.ResourceLoader;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xlator {
    private static final String PROPERTY_PREFIX = "selenium.options.";

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("usage: Xlator <formatter> <input.html> [output]\nexample: Xlator java-rc c:\\my\\TestFoo.html\n");
            System.exit(1);
        }
        int i = 0;
        String outputFormat = args[i++];
        File testCaseHTML = new File(args[i++]);
        File outputFile = null;
        if (args.length == 3) {
            outputFile = new File(args[i++]);
        }
        HashMap<String, String> options = Xlator.extractOptions();
        String testName = Xlator.extractTestName(testCaseHTML);
        String output = Xlator.xlateTestCase(testName, outputFormat, Xlator.loadFile(testCaseHTML), options);
        if (outputFile == null) {
            System.out.println(output);
        } else {
            FileWriter fw = new FileWriter(outputFile);
            fw.write(output);
            fw.flush();
            fw.close();
        }
    }

    public static HashMap<String, String> extractOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        for (String string : System.getProperties().keySet()) {
            if (!string.startsWith(PROPERTY_PREFIX)) continue;
            String optionName = string.substring(PROPERTY_PREFIX.length());
            options.put(optionName, System.getProperty(string));
        }
        return options;
    }

    static String extractTestName(File testFile) {
        int dotIndex = testFile.getName().indexOf(46);
        if (dotIndex == -1) {
            return testFile.getName();
        }
        return testFile.getName().substring(0, dotIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String xlateTestCase(String testName, String outputFormat, String htmlSource, HashMap<String, String> options) throws Exception {
        Context cx = Context.enter();
        try {
            ScriptableObject scope = cx.initStandardObjects();
            Xlator.loadJSSource(cx, (Scriptable)scope, "/content/formats/html.js");
            Xlator.loadJSSource(cx, (Scriptable)scope, "/content/testCase.js");
            Xlator.loadJSSource(cx, (Scriptable)scope, "/content/tools.js");
            InputStream stream = Xlator.class.getResourceAsStream("/core/iedoc-core.xml");
            Document apiDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
            stream.close();
            Object wrappedAPIDoc = Context.javaToJS((Object)apiDoc, (Scriptable)scope);
            Scriptable commandClass = (Scriptable)scope.get("Command", (Scriptable)scope);
            ScriptableObject.putProperty((Scriptable)commandClass, (String)"apiDocument", (Object)wrappedAPIDoc);
            Scriptable seleniumAPI = (Scriptable)cx.evaluateString((Scriptable)scope, "window = new Object(); window.editor = new Object(); window.editor.seleniumAPI = new Object();", "<JavaEval>", 1, null);
            Xlator.loadJSSource(cx, seleniumAPI, "/core/scripts/selenium-api.js");
            cx.evaluateString((Scriptable)scope, "Log.write = function(msg) { java.lang.System.out.println(msg) }; log = new Log('format');", "<JavaEval>", 1, null);
            Function parse = Xlator.getFunction((Scriptable)scope, "parse");
            Scriptable myTestCase = cx.newObject((Scriptable)scope, "TestCase");
            parse.call(cx, (Scriptable)scope, (Scriptable)scope, new Object[]{myTestCase, htmlSource});
            ScriptableObject.putProperty((Scriptable)myTestCase, (String)"name", (Object)testName);
            Object wrappedResourceLoader = Context.javaToJS((Object)new ResourceLoader(cx, (Scriptable)scope), (Scriptable)scope);
            ScriptableObject.putProperty((Scriptable)scope, (String)"resourceLoader", (Object)wrappedResourceLoader);
            cx.evaluateString((Scriptable)scope, "function load(name) { var source = resourceLoader.evalResource('/content/formats/' + name);}", "<JavaEval>", 1, null);
            Xlator.loadJSSource(cx, (Scriptable)scope, "/content/formats/" + outputFormat + ".js");
            if (options != null) {
                for (String optionName : options.keySet()) {
                    Scriptable jsOptions = (Scriptable)scope.get("options", (Scriptable)scope);
                    ScriptableObject.putProperty((Scriptable)jsOptions, (String)optionName, (Object)options.get(optionName));
                }
            }
            Function format = Xlator.getFunction((Scriptable)scope, "format");
            Object result = format.call(cx, (Scriptable)scope, (Scriptable)scope, new Object[]{myTestCase, testName});
            String string = (String)result;
            return string;
        }
        finally {
            Context.exit();
        }
    }

    static String loadFile(File file) throws IOException {
        FileReader is = new FileReader(file);
        return Xlator.readerToString(is);
    }

    static String readerToString(Reader is) throws IOException {
        int n;
        StringBuffer sb = new StringBuffer();
        char[] b = new char[8192];
        while ((n = is.read(b)) > 0) {
            sb.append(b, 0, n);
        }
        return sb.toString();
    }

    private static void loadJSSource(Context cx, Scriptable scope, String fileName) throws IOException {
        String source = Xlator.loadResource(fileName);
        cx.evaluateString(scope, source, fileName, 1, null);
    }

    private static Function getFunction(Scriptable scope, String functionName) {
        Object fObj = scope.get(functionName, scope);
        if (!(fObj instanceof Function)) {
            throw new RuntimeException(functionName + " is undefined or not a function.");
        }
        return (Function)fObj;
    }

    static String loadResource(String resourceName) throws IOException {
        InputStream stream = Xlator.class.getResourceAsStream(resourceName);
        if (stream == null) {
            throw new RuntimeException("Couldn't find resource " + resourceName);
        }
        InputStreamReader reader = new InputStreamReader(stream);
        return Xlator.readerToString(reader);
    }
}

